/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.async;

import com.navercorp.pinpoint.bootstrap.async.AsyncContextAccessor;
import com.navercorp.pinpoint.bootstrap.async.AsyncContextCall;
import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.common.util.ArrayUtils;
import java.util.Objects;

public final class AsyncContextAccessorUtils {
    private static final AsyncContextCall ASYNC_CONTEXT_CALL = new AsyncContextCall(){

        @Override
        public AsyncContext getAsyncContext(Object object) {
            return AsyncContextAccessorUtils.getAsyncContext(object);
        }

        @Override
        public AsyncContext getAsyncContext(Object[] array, int index) {
            return AsyncContextAccessorUtils.getAsyncContext(array, index);
        }
    };

    public static AsyncContext getAsyncContext(Object[] array, int index) {
        if (!ArrayUtils.isArrayIndexValid((Object[])array, (int)index)) {
            return null;
        }
        return AsyncContextAccessorUtils.getAsyncContext(array[index]);
    }

    public static AsyncContext getAsyncContext(Object object) {
        if (object instanceof AsyncContextAccessor) {
            return ((AsyncContextAccessor)object)._$PINPOINT$_getAsyncContext();
        }
        return null;
    }

    public static void setAsyncContext(AsyncContext asyncContext, Object object) {
        if (object instanceof AsyncContextAccessor) {
            ((AsyncContextAccessor)object)._$PINPOINT$_setAsyncContext(asyncContext);
        }
    }

    public static void setAsyncContext(AsyncContext asyncContext, Object[] array, int index) {
        if (!ArrayUtils.isArrayIndexValid((Object[])array, (int)index)) {
            return;
        }
        AsyncContextAccessorUtils.setAsyncContext(asyncContext, array[index]);
    }

    public static AsyncContext findAsyncContext(Object[] array, int beginIndex) {
        if (ArrayUtils.isEmpty((Object[])array)) {
            return null;
        }
        int endIndex = array.length - 1;
        return AsyncContextAccessorUtils.findAsyncContext(array, beginIndex, endIndex);
    }

    public static AsyncContext findAsyncContext(Object[] array, int beginIndex, int endIndex) {
        return AsyncContextAccessorUtils.findAsyncContext(array, beginIndex, endIndex, ASYNC_CONTEXT_CALL);
    }

    public static AsyncContext findAsyncContext(Object[] array, int beginIndex, int endIndex, AsyncContextCall asyncContextCall) {
        Objects.requireNonNull(asyncContextCall, "asyncContextCall");
        if (ArrayUtils.isEmpty((Object[])array)) {
            return null;
        }
        int length = array.length - 1;
        if (beginIndex < 0 || beginIndex > endIndex || endIndex > length) {
            return null;
        }
        for (int i = beginIndex; i <= endIndex; ++i) {
            if (array[i] instanceof Object[]) {
                Object[] objects;
                for (Object object : objects = (Object[])array[i]) {
                    AsyncContext asyncContext = asyncContextCall.getAsyncContext(object);
                    if (asyncContext == null) continue;
                    return asyncContext;
                }
                continue;
            }
            AsyncContext asyncContext = asyncContextCall.getAsyncContext(array, i);
            if (asyncContext == null) continue;
            return asyncContext;
        }
        return null;
    }
}

