/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.offsetmgmt.api.data;

import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import org.apache.eventmesh.common.remote.offset.RecordOffset;
import org.apache.eventmesh.common.remote.offset.RecordPartition;
import org.apache.eventmesh.common.remote.offset.RecordPosition;
import org.apache.eventmesh.openconnect.offsetmgmt.api.callback.SendMessageCallback;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.DefaultKeyValue;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.KeyValue;

public class ConnectRecord {
    private final String recordId = UUID.randomUUID().toString();
    private Long timestamp;
    private Object data;
    private RecordPosition position;
    private KeyValue extensions;
    private SendMessageCallback callback;

    public ConnectRecord() {
    }

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp) {
        this(recordPartition, recordOffset, timestamp, null);
    }

    public ConnectRecord(RecordPartition recordPartition, RecordOffset recordOffset, Long timestamp, Object data) {
        this.position = recordPartition == null || recordOffset == null ? null : new RecordPosition(recordPartition, recordOffset);
        this.timestamp = timestamp;
        this.data = data;
    }

    public void addExtension(KeyValue extensions) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        Set<String> keySet = extensions.keySet();
        for (String key : keySet) {
            this.extensions.put(key, extensions.getObject(key));
        }
    }

    public void addExtension(String key, Object value) {
        if (this.extensions == null) {
            this.extensions = new DefaultKeyValue();
        }
        this.extensions.put(key, value);
    }

    public String getExtension(String key) {
        if (this.extensions == null || !this.extensions.containsKey(key)) {
            return null;
        }
        return this.extensions.getString(key);
    }

    public <T> T getExtension(String key, Class<T> c) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getObject(key, c);
    }

    public Object getExtensionObj(String key) {
        if (this.extensions == null) {
            return null;
        }
        return this.extensions.getObject(key);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConnectRecord)) {
            return false;
        }
        ConnectRecord that = (ConnectRecord)o;
        return Objects.equals(this.recordId, that.recordId) && Objects.equals(this.timestamp, that.timestamp) && Objects.equals(this.data, that.data) && Objects.equals(this.position, that.position) && Objects.equals(this.extensions, that.extensions);
    }

    public int hashCode() {
        return Objects.hash(this.recordId, this.timestamp, this.data, this.position, this.extensions);
    }

    public String toString() {
        return "ConnectRecord{recordId=" + this.recordId + ", timestamp=" + this.timestamp + ", data=" + this.data + ", position=" + this.position + ", extensions=" + this.extensions + "}";
    }

    @Generated
    public String getRecordId() {
        return this.recordId;
    }

    @Generated
    public Long getTimestamp() {
        return this.timestamp;
    }

    @Generated
    public Object getData() {
        return this.data;
    }

    @Generated
    public RecordPosition getPosition() {
        return this.position;
    }

    @Generated
    public KeyValue getExtensions() {
        return this.extensions;
    }

    @Generated
    public SendMessageCallback getCallback() {
        return this.callback;
    }

    @Generated
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    @Generated
    public void setData(Object data) {
        this.data = data;
    }

    @Generated
    public void setPosition(RecordPosition position) {
        this.position = position;
    }

    @Generated
    public void setExtensions(KeyValue extensions) {
        this.extensions = extensions;
    }

    @Generated
    public void setCallback(SendMessageCallback callback) {
        this.callback = callback;
    }
}

