/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.canal.interceptor;

import java.util.List;
import lombok.Generated;
import org.apache.eventmesh.common.config.connector.rdb.canal.CanalSinkIncrementConfig;
import org.apache.eventmesh.connector.canal.CanalConnectRecord;
import org.apache.eventmesh.connector.canal.dialect.DbDialect;
import org.apache.eventmesh.connector.canal.model.EventColumn;
import org.apache.eventmesh.connector.canal.model.EventType;
import org.apache.eventmesh.connector.canal.template.SqlTemplate;
import org.springframework.util.CollectionUtils;

public class SqlBuilderLoadInterceptor {
    private DbDialect dbDialect;

    public boolean before(CanalSinkIncrementConfig sinkConfig, CanalConnectRecord record) {
        SqlTemplate sqlTemplate = this.dbDialect.getSqlTemplate();
        EventType type = record.getEventType();
        String sql = null;
        String schemaName = record.isWithoutSchema() ? null : record.getSchemaName();
        String shardColumns = null;
        if (type.isInsert()) {
            sql = sqlTemplate.getMergeSql(schemaName, record.getTableName(), this.buildColumnNames(record.getKeys()), this.buildColumnNames(record.getColumns()), new String[0], true, shardColumns);
        } else if (type.isUpdate()) {
            boolean existOldKeys = !CollectionUtils.isEmpty(record.getOldKeys());
            boolean rowMode = sinkConfig.getSyncMode().isRow();
            String[] keyColumns = null;
            String[] otherColumns = null;
            if (existOldKeys) {
                keyColumns = this.buildColumnNames(record.getOldKeys());
                otherColumns = this.buildColumnNames(record.getUpdatedColumns(), record.getKeys());
            } else {
                keyColumns = this.buildColumnNames(record.getKeys());
                otherColumns = this.buildColumnNames(record.getUpdatedColumns());
            }
            sql = sqlTemplate.getUpdateSql(schemaName, record.getTableName(), keyColumns, otherColumns, true, shardColumns);
        } else if (type.isDelete()) {
            sql = sqlTemplate.getDeleteSql(schemaName, record.getTableName(), this.buildColumnNames(record.getKeys()));
        }
        if (record.getHint() != null) {
            record.setSql(record.getHint() + sql);
        } else {
            record.setSql(sql);
        }
        return false;
    }

    private String[] buildColumnNames(List<EventColumn> columns) {
        String[] result = new String[columns.size()];
        for (int i = 0; i < columns.size(); ++i) {
            EventColumn column = columns.get(i);
            result[i] = column.getColumnName();
        }
        return result;
    }

    private String[] buildColumnNames(List<EventColumn> columns1, List<EventColumn> columns2) {
        EventColumn column;
        String[] result = new String[columns1.size() + columns2.size()];
        int i = 0;
        for (i = 0; i < columns1.size(); ++i) {
            column = columns1.get(i);
            result[i] = column.getColumnName();
        }
        while (i < columns1.size() + columns2.size()) {
            column = columns2.get(i - columns1.size());
            result[i] = column.getColumnName();
            ++i;
        }
        return result;
    }

    @Generated
    public DbDialect getDbDialect() {
        return this.dbDialect;
    }

    @Generated
    public void setDbDialect(DbDialect dbDialect) {
        this.dbDialect = dbDialect;
    }
}

