/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.shared.security.auth;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.shared.security.auth.Credentials;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import lombok.Generated;
import lombok.NonNull;

public class DefaultCredentials
implements Credentials {
    private static final long serialVersionUID = 1L;
    private final String token;

    public DefaultCredentials(@NonNull String password, @NonNull String userName) {
        if (password == null) {
            throw new NullPointerException("password is marked non-null but is null");
        }
        if (userName == null) {
            throw new NullPointerException("userName is marked non-null but is null");
        }
        String decoded = userName + ":" + password;
        this.token = Base64.getEncoder().encodeToString(decoded.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getAuthenticationType() {
        return "Basic";
    }

    @Override
    public String getAuthenticationToken() {
        return this.token;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DefaultCredentials)) {
            return false;
        }
        DefaultCredentials other = (DefaultCredentials)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$token = this.token;
        String other$token = other.token;
        return !(this$token == null ? other$token != null : !this$token.equals(other$token));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof DefaultCredentials;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $token = this.token;
        result = result * 59 + ($token == null ? 43 : $token.hashCode());
        return result;
    }
}

