/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler.v1;

import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.admin.request.CreateTopicRequest;
import org.apache.eventmesh.runtime.admin.request.DeleteTopicRequest;
import org.apache.eventmesh.runtime.common.EventMeshHttpHandler;
import org.apache.eventmesh.runtime.core.plugin.MQAdminWrapper;
import org.apache.eventmesh.runtime.util.HttpRequestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventMeshHttpHandler(path="/topic")
public class TopicHandler
extends AbstractHttpHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TopicHandler.class);
    private final MQAdminWrapper admin;

    public TopicHandler(String connectorPluginType) {
        this.admin = new MQAdminWrapper(connectorPluginType);
        try {
            this.admin.init(null);
        }
        catch (Exception ignored) {
            log.info("failed to initialize MQAdminWrapper");
        }
    }

    @Override
    protected void get(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        List<TopicProperties> topicList = this.admin.getTopic();
        String result = JsonUtils.toJSONString(topicList);
        this.writeJson(ctx, result);
    }

    @Override
    protected void post(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        Objects.requireNonNull(body, "body can not be null");
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Content-Type", (Object)"application/json");
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        CreateTopicRequest createTopicRequest = (CreateTopicRequest)JsonUtils.mapToObject(body, CreateTopicRequest.class);
        String topicName = Objects.requireNonNull(createTopicRequest).getName();
        this.admin.createTopic(topicName);
        this.writeText(ctx, "");
    }

    @Override
    protected void delete(HttpRequest httpRequest, ChannelHandlerContext ctx) throws Exception {
        Map<String, Object> body = HttpRequestUtil.parseHttpRequestBody(httpRequest);
        Objects.requireNonNull(body, "body can not be null");
        DefaultHttpHeaders responseHeaders = new DefaultHttpHeaders();
        responseHeaders.add("Content-Type", (Object)"application/json");
        responseHeaders.add("Access-Control-Allow-Origin", (Object)"*");
        DeleteTopicRequest deleteTopicRequest = (DeleteTopicRequest)JsonUtils.mapToObject(body, DeleteTopicRequest.class);
        String topicName = Objects.requireNonNull(deleteTopicRequest).getName();
        this.admin.deleteTopic(topicName);
        this.writeText(ctx, "");
    }
}

