/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.metrics;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.eventmesh.metrics.api.model.InstrumentFurther;
import org.apache.eventmesh.metrics.api.model.LongCounterMetric;
import org.apache.eventmesh.metrics.api.model.Metric;

public class GeneralMetrics {
    private static final String METRIC_NAME = "general";
    private static final String GENERAL_METRICS_NAME_PREFIX = "eventmesh.general.";
    protected static final Map<String, Metric> metrics = new HashMap<String, Metric>(32);
    protected static final LongCounterMetric client2eventMeshMsgNum;
    protected static final LongCounterMetric eventMesh2mqMsgNum;
    protected static final LongCounterMetric mq2eventMeshMsgNum;
    protected static final LongCounterMetric eventMesh2clientMsgNum;

    public static Collection<Metric> getMetrics() {
        return metrics.values();
    }

    static {
        InstrumentFurther furtherCl2Em = new InstrumentFurther();
        furtherCl2Em.setUnit("1");
        furtherCl2Em.setDescription("message number of client send to EventMesh");
        furtherCl2Em.setName("eventmesh.general.client.eventmesh.message.num");
        client2eventMeshMsgNum = new LongCounterMetric(furtherCl2Em, METRIC_NAME);
        metrics.put("client2eventMeshMsgNum", (Metric)client2eventMeshMsgNum);
        InstrumentFurther furtherEm2Mq = new InstrumentFurther();
        furtherEm2Mq.setUnit("1");
        furtherEm2Mq.setDescription("message number of EventMesh send to MQ");
        furtherEm2Mq.setName("eventmesh.general.eventmesh.mq.message.num");
        eventMesh2mqMsgNum = new LongCounterMetric(furtherEm2Mq, METRIC_NAME);
        metrics.put("eventMesh2mqMsgNum", (Metric)eventMesh2mqMsgNum);
        InstrumentFurther furtherMq2Em = new InstrumentFurther();
        furtherMq2Em.setUnit("1");
        furtherMq2Em.setDescription("message number of MQ send to EventMesh");
        furtherMq2Em.setName("eventmesh.general.mq.eventmesh.message.num");
        mq2eventMeshMsgNum = new LongCounterMetric(furtherMq2Em, METRIC_NAME);
        metrics.put("mq2eventMeshMsgNum", (Metric)mq2eventMeshMsgNum);
        InstrumentFurther furtherEm2Cl = new InstrumentFurther();
        furtherEm2Cl.setUnit("1");
        furtherEm2Cl.setDescription("message number of EventMesh send to client");
        furtherEm2Cl.setName("eventmesh.general.eventmesh.client.message.num");
        eventMesh2clientMsgNum = new LongCounterMetric(furtherEm2Cl, METRIC_NAME);
        metrics.put("eventMesh2clientMsgNum", (Metric)eventMesh2clientMsgNum);
    }
}

