/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.eventmesh.common.protocol.grpc.adminserver;

import static io.grpc.MethodDescriptor.generateFullMethodName;

/**
 * AdminServiceGrpc
 */
@javax.annotation.Generated(
    value = "by gRPC proto compiler (version 1.40.0)",
    comments = "Source: event_mesh_admin_service.proto")
@io.grpc.stub.annotations.GrpcGenerated
public final class AdminServiceGrpc {

    private AdminServiceGrpc() {
    }

    public static final String SERVICE_NAME = "AdminService";

    // Static method descriptors that strictly reflect the proto.
    private static volatile io.grpc.MethodDescriptor<Payload,
        Payload> getInvokeBiStreamMethod;

    @io.grpc.stub.annotations.RpcMethod(
        fullMethodName = SERVICE_NAME + '/' + "invokeBiStream",
        requestType = Payload.class,
        responseType = Payload.class,
        methodType = io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
    public static io.grpc.MethodDescriptor<Payload,
        Payload> getInvokeBiStreamMethod() {
        io.grpc.MethodDescriptor<Payload, Payload> getInvokeBiStreamMethod;
        if ((getInvokeBiStreamMethod = AdminServiceGrpc.getInvokeBiStreamMethod) == null) {
            synchronized (AdminServiceGrpc.class) {
                if ((getInvokeBiStreamMethod = AdminServiceGrpc.getInvokeBiStreamMethod) == null) {
                    AdminServiceGrpc.getInvokeBiStreamMethod = getInvokeBiStreamMethod =
                        io.grpc.MethodDescriptor.<Payload, Payload>newBuilder()
                            .setType(io.grpc.MethodDescriptor.MethodType.BIDI_STREAMING)
                            .setFullMethodName(generateFullMethodName(SERVICE_NAME, "invokeBiStream"))
                            .setSampledToLocalTracing(true)
                            .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                                Payload.getDefaultInstance()))
                            .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                                Payload.getDefaultInstance()))
                            .setSchemaDescriptor(new AdminServiceMethodDescriptorSupplier("invokeBiStream"))
                            .build();
                }
            }
        }
        return getInvokeBiStreamMethod;
    }

    private static volatile io.grpc.MethodDescriptor<Payload,
        Payload> getInvokeMethod;

    @io.grpc.stub.annotations.RpcMethod(
        fullMethodName = SERVICE_NAME + '/' + "invoke",
        requestType = Payload.class,
        responseType = Payload.class,
        methodType = io.grpc.MethodDescriptor.MethodType.UNARY)
    public static io.grpc.MethodDescriptor<Payload,
        Payload> getInvokeMethod() {
        io.grpc.MethodDescriptor<Payload, Payload> getInvokeMethod;
        if ((getInvokeMethod = AdminServiceGrpc.getInvokeMethod) == null) {
            synchronized (AdminServiceGrpc.class) {
                if ((getInvokeMethod = AdminServiceGrpc.getInvokeMethod) == null) {
                    AdminServiceGrpc.getInvokeMethod = getInvokeMethod =
                        io.grpc.MethodDescriptor.<Payload, Payload>newBuilder()
                            .setType(io.grpc.MethodDescriptor.MethodType.UNARY)
                            .setFullMethodName(generateFullMethodName(SERVICE_NAME, "invoke"))
                            .setSampledToLocalTracing(true)
                            .setRequestMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                                Payload.getDefaultInstance()))
                            .setResponseMarshaller(io.grpc.protobuf.ProtoUtils.marshaller(
                                Payload.getDefaultInstance()))
                            .setSchemaDescriptor(new AdminServiceMethodDescriptorSupplier("invoke"))
                            .build();
                }
            }
        }
        return getInvokeMethod;
    }

    /**
     * Creates a new async stub that supports all call types for the service
     */
    public static AdminServiceStub newStub(io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<AdminServiceStub> factory =
            new io.grpc.stub.AbstractStub.StubFactory<AdminServiceStub>() {
                @Override
                public AdminServiceStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                    return new AdminServiceStub(channel, callOptions);
                }
            };
        return AdminServiceStub.newStub(factory, channel);
    }

    /**
     * Creates a new blocking-style stub that supports unary and streaming output calls on the service
     */
    public static AdminServiceBlockingStub newBlockingStub(
        io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<AdminServiceBlockingStub> factory =
            new io.grpc.stub.AbstractStub.StubFactory<AdminServiceBlockingStub>() {
                @Override
                public AdminServiceBlockingStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                    return new AdminServiceBlockingStub(channel, callOptions);
                }
            };
        return AdminServiceBlockingStub.newStub(factory, channel);
    }

    /**
     * Creates a new ListenableFuture-style stub that supports unary calls on the service
     */
    public static AdminServiceFutureStub newFutureStub(
        io.grpc.Channel channel) {
        io.grpc.stub.AbstractStub.StubFactory<AdminServiceFutureStub> factory =
            new io.grpc.stub.AbstractStub.StubFactory<AdminServiceFutureStub>() {
                @Override
                public AdminServiceFutureStub newStub(io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
                    return new AdminServiceFutureStub(channel, callOptions);
                }
            };
        return AdminServiceFutureStub.newStub(factory, channel);
    }

    /**
     *
     */
    public static abstract class AdminServiceImplBase implements io.grpc.BindableService {

        /**
         *
         */
        public io.grpc.stub.StreamObserver<Payload> invokeBiStream(
            io.grpc.stub.StreamObserver<Payload> responseObserver) {
            return io.grpc.stub.ServerCalls.asyncUnimplementedStreamingCall(getInvokeBiStreamMethod(), responseObserver);
        }

        /**
         *
         */
        public void invoke(Payload request,
            io.grpc.stub.StreamObserver<Payload> responseObserver) {
            io.grpc.stub.ServerCalls.asyncUnimplementedUnaryCall(getInvokeMethod(), responseObserver);
        }

        @Override
        public final io.grpc.ServerServiceDefinition bindService() {
            return io.grpc.ServerServiceDefinition.builder(getServiceDescriptor())
                .addMethod(
                    getInvokeBiStreamMethod(),
                    io.grpc.stub.ServerCalls.asyncBidiStreamingCall(
                        new MethodHandlers<
                            Payload,
                            Payload>(
                            this, METHODID_INVOKE_BI_STREAM)))
                .addMethod(
                    getInvokeMethod(),
                    io.grpc.stub.ServerCalls.asyncUnaryCall(
                        new MethodHandlers<
                            Payload,
                            Payload>(
                            this, METHODID_INVOKE)))
                .build();
        }
    }

    /**
     *
     */
    public static final class AdminServiceStub extends io.grpc.stub.AbstractAsyncStub<AdminServiceStub> {

        private AdminServiceStub(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected AdminServiceStub build(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new AdminServiceStub(channel, callOptions);
        }

        /**
         *
         */
        public io.grpc.stub.StreamObserver<Payload> invokeBiStream(
            io.grpc.stub.StreamObserver<Payload> responseObserver) {
            return io.grpc.stub.ClientCalls.asyncBidiStreamingCall(
                getChannel().newCall(getInvokeBiStreamMethod(), getCallOptions()), responseObserver);
        }

        /**
         *
         */
        public void invoke(Payload request,
            io.grpc.stub.StreamObserver<Payload> responseObserver) {
            io.grpc.stub.ClientCalls.asyncUnaryCall(
                getChannel().newCall(getInvokeMethod(), getCallOptions()), request, responseObserver);
        }
    }

    /**
     *
     */
    public static final class AdminServiceBlockingStub extends io.grpc.stub.AbstractBlockingStub<AdminServiceBlockingStub> {

        private AdminServiceBlockingStub(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected AdminServiceBlockingStub build(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new AdminServiceBlockingStub(channel, callOptions);
        }

        /**
         *
         */
        public Payload invoke(Payload request) {
            return io.grpc.stub.ClientCalls.blockingUnaryCall(
                getChannel(), getInvokeMethod(), getCallOptions(), request);
        }
    }

    /**
     *
     */
    public static final class AdminServiceFutureStub extends io.grpc.stub.AbstractFutureStub<AdminServiceFutureStub> {

        private AdminServiceFutureStub(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            super(channel, callOptions);
        }

        @Override
        protected AdminServiceFutureStub build(
            io.grpc.Channel channel, io.grpc.CallOptions callOptions) {
            return new AdminServiceFutureStub(channel, callOptions);
        }

        /**
         *
         */
        public com.google.common.util.concurrent.ListenableFuture<Payload> invoke(
            Payload request) {
            return io.grpc.stub.ClientCalls.futureUnaryCall(
                getChannel().newCall(getInvokeMethod(), getCallOptions()), request);
        }
    }

    private static final int METHODID_INVOKE = 0;
    private static final int METHODID_INVOKE_BI_STREAM = 1;

    private static final class MethodHandlers<Req, Resp> implements
        io.grpc.stub.ServerCalls.UnaryMethod<Req, Resp>,
        io.grpc.stub.ServerCalls.ServerStreamingMethod<Req, Resp>,
        io.grpc.stub.ServerCalls.ClientStreamingMethod<Req, Resp>,
        io.grpc.stub.ServerCalls.BidiStreamingMethod<Req, Resp> {

        private final AdminServiceImplBase serviceImpl;
        private final int methodId;

        MethodHandlers(AdminServiceImplBase serviceImpl, int methodId) {
            this.serviceImpl = serviceImpl;
            this.methodId = methodId;
        }

        @Override
        @SuppressWarnings("unchecked")
        public void invoke(Req request, io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_INVOKE:
                    serviceImpl.invoke((Payload) request,
                        (io.grpc.stub.StreamObserver<Payload>) responseObserver);
                    break;
                default:
                    throw new AssertionError();
            }
        }

        @Override
        @SuppressWarnings("unchecked")
        public io.grpc.stub.StreamObserver<Req> invoke(
            io.grpc.stub.StreamObserver<Resp> responseObserver) {
            switch (methodId) {
                case METHODID_INVOKE_BI_STREAM:
                    return (io.grpc.stub.StreamObserver<Req>) serviceImpl.invokeBiStream(
                        (io.grpc.stub.StreamObserver<Payload>) responseObserver);
                default:
                    throw new AssertionError();
            }
        }
    }

    private static abstract class AdminServiceBaseDescriptorSupplier
        implements io.grpc.protobuf.ProtoFileDescriptorSupplier, io.grpc.protobuf.ProtoServiceDescriptorSupplier {

        AdminServiceBaseDescriptorSupplier() {
        }

        @Override
        public com.google.protobuf.Descriptors.FileDescriptor getFileDescriptor() {
            return EventMeshAdminService.getDescriptor();
        }

        @Override
        public com.google.protobuf.Descriptors.ServiceDescriptor getServiceDescriptor() {
            return getFileDescriptor().findServiceByName("AdminService");
        }
    }

    private static final class AdminServiceFileDescriptorSupplier
        extends AdminServiceBaseDescriptorSupplier {

        AdminServiceFileDescriptorSupplier() {
        }
    }

    private static final class AdminServiceMethodDescriptorSupplier
        extends AdminServiceBaseDescriptorSupplier
        implements io.grpc.protobuf.ProtoMethodDescriptorSupplier {

        private final String methodName;

        AdminServiceMethodDescriptorSupplier(String methodName) {
            this.methodName = methodName;
        }

        @Override
        public com.google.protobuf.Descriptors.MethodDescriptor getMethodDescriptor() {
            return getServiceDescriptor().findMethodByName(methodName);
        }
    }

    private static volatile io.grpc.ServiceDescriptor serviceDescriptor;

    public static io.grpc.ServiceDescriptor getServiceDescriptor() {
        io.grpc.ServiceDescriptor result = serviceDescriptor;
        if (result == null) {
            synchronized (AdminServiceGrpc.class) {
                result = serviceDescriptor;
                if (result == null) {
                    serviceDescriptor = result = io.grpc.ServiceDescriptor.newBuilder(SERVICE_NAME)
                        .setSchemaDescriptor(new AdminServiceFileDescriptorSupplier())
                        .addMethod(getInvokeBiStreamMethod())
                        .addMethod(getInvokeMethod())
                        .build();
                }
            }
        }
        return result;
    }
}
