/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;

@PublicEvolving
public interface TableChange {
    public static AddColumn add(Column column) {
        return new AddColumn(column, null);
    }

    public static AddColumn add(Column column, @Nullable ColumnPosition position) {
        return new AddColumn(column, position);
    }

    public static AddUniqueConstraint add(UniqueConstraint constraint) {
        return new AddUniqueConstraint(constraint);
    }

    public static AddDistribution add(TableDistribution distribution) {
        return new AddDistribution(distribution);
    }

    public static AddWatermark add(WatermarkSpec watermarkSpec) {
        return new AddWatermark(watermarkSpec);
    }

    public static ModifyColumn modify(Column oldColumn, Column newColumn, @Nullable ColumnPosition columnPosition) {
        return new ModifyColumn(oldColumn, newColumn, columnPosition);
    }

    public static ModifyPhysicalColumnType modifyPhysicalColumnType(Column oldColumn, DataType newType) {
        return new ModifyPhysicalColumnType(oldColumn, newType);
    }

    public static ModifyColumnName modifyColumnName(Column oldColumn, String newName) {
        return new ModifyColumnName(oldColumn, newName);
    }

    public static ModifyColumnComment modifyColumnComment(Column oldColumn, String newComment) {
        return new ModifyColumnComment(oldColumn, newComment);
    }

    public static ModifyColumnPosition modifyColumnPosition(Column oldColumn, ColumnPosition columnPosition) {
        return new ModifyColumnPosition(oldColumn, columnPosition);
    }

    public static ModifyUniqueConstraint modify(UniqueConstraint newConstraint) {
        return new ModifyUniqueConstraint(newConstraint);
    }

    public static ModifyDistribution modify(TableDistribution distribution) {
        return new ModifyDistribution(distribution);
    }

    public static ModifyWatermark modify(WatermarkSpec newWatermarkSpec) {
        return new ModifyWatermark(newWatermarkSpec);
    }

    public static DropColumn dropColumn(String columnName) {
        return new DropColumn(columnName);
    }

    public static DropWatermark dropWatermark() {
        return DropWatermark.INSTANCE;
    }

    public static DropConstraint dropConstraint(String constraintName) {
        return new DropConstraint(constraintName);
    }

    public static DropDistribution dropDistribution() {
        return DropDistribution.INSTANCE;
    }

    public static SetOption set(String key, String value) {
        return new SetOption(key, value);
    }

    public static ResetOption reset(String key) {
        return new ResetOption(key);
    }

    public static ModifyRefreshStatus modifyRefreshStatus(CatalogMaterializedTable.RefreshStatus refreshStatus) {
        return new ModifyRefreshStatus(refreshStatus);
    }

    public static ModifyRefreshHandler modifyRefreshHandler(String refreshHandlerDesc, byte[] refreshHandlerBytes) {
        return new ModifyRefreshHandler(refreshHandlerDesc, refreshHandlerBytes);
    }

    public static ModifyDefinitionQuery modifyDefinitionQuery(String definitionQuery) {
        return new ModifyDefinitionQuery(definitionQuery);
    }

    @PublicEvolving
    public static class ModifyDefinitionQuery
    implements MaterializedTableChange {
        private final String definitionQuery;

        public ModifyDefinitionQuery(String definitionQuery) {
            this.definitionQuery = definitionQuery;
        }

        public String getDefinitionQuery() {
            return this.definitionQuery;
        }

        public String toString() {
            return "ModifyDefinitionQuery{definitionQuery='" + this.definitionQuery + "'}";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifyDefinitionQuery that = (ModifyDefinitionQuery)o;
            return Objects.equals(this.definitionQuery, that.definitionQuery);
        }

        public int hashCode() {
            return Objects.hash(this.definitionQuery);
        }
    }

    @PublicEvolving
    public static class ModifyRefreshHandler
    implements MaterializedTableChange {
        private final String refreshHandlerDesc;
        private final byte[] refreshHandlerBytes;

        public ModifyRefreshHandler(String refreshHandlerDesc, byte[] refreshHandlerBytes) {
            this.refreshHandlerDesc = refreshHandlerDesc;
            this.refreshHandlerBytes = refreshHandlerBytes;
        }

        public String getRefreshHandlerDesc() {
            return this.refreshHandlerDesc;
        }

        public byte[] getRefreshHandlerBytes() {
            return this.refreshHandlerBytes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifyRefreshHandler that = (ModifyRefreshHandler)o;
            return Objects.equals(this.refreshHandlerDesc, that.refreshHandlerDesc) && Arrays.equals(this.refreshHandlerBytes, that.refreshHandlerBytes);
        }

        public int hashCode() {
            int result = Objects.hash(this.refreshHandlerDesc);
            result = 31 * result + Arrays.hashCode(this.refreshHandlerBytes);
            return result;
        }

        public String toString() {
            return "ModifyRefreshHandler{refreshHandlerDesc='" + this.refreshHandlerDesc + "', refreshHandlerBytes=" + Arrays.toString(this.refreshHandlerBytes) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyRefreshStatus
    implements MaterializedTableChange {
        private final CatalogMaterializedTable.RefreshStatus refreshStatus;

        public ModifyRefreshStatus(CatalogMaterializedTable.RefreshStatus refreshStatus) {
            this.refreshStatus = refreshStatus;
        }

        public CatalogMaterializedTable.RefreshStatus getRefreshStatus() {
            return this.refreshStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ModifyRefreshStatus that = (ModifyRefreshStatus)o;
            return this.refreshStatus == that.refreshStatus;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.refreshStatus});
        }

        public String toString() {
            return "ModifyRefreshStatus{refreshStatus=" + String.valueOf((Object)this.refreshStatus) + "}";
        }
    }

    @PublicEvolving
    public static interface MaterializedTableChange
    extends TableChange {
    }

    @PublicEvolving
    public static interface CatalogTableChange
    extends TableChange {
    }

    @PublicEvolving
    public static final class After
    implements ColumnPosition {
        private final String column;

        private After(String column) {
            this.column = column;
        }

        public String column() {
            return this.column;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof After)) {
                return false;
            }
            After after = (After)o;
            return Objects.equals(this.column, after.column);
        }

        public int hashCode() {
            return Objects.hash(this.column);
        }

        public String toString() {
            return String.format("AFTER %s", EncodingUtils.escapeIdentifier(this.column));
        }
    }

    @PublicEvolving
    public static final class First
    implements ColumnPosition {
        private static final First INSTANCE = new First();

        private First() {
        }

        public String toString() {
            return "FIRST";
        }
    }

    @PublicEvolving
    public static interface ColumnPosition {
        public static ColumnPosition first() {
            return First.INSTANCE;
        }

        public static ColumnPosition after(String column) {
            return new After(column);
        }
    }

    @PublicEvolving
    public static class ResetOption
    implements CatalogTableChange {
        private final String key;

        public ResetOption(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ResetOption)) {
                return false;
            }
            ResetOption that = (ResetOption)o;
            return Objects.equals(this.key, that.key);
        }

        public int hashCode() {
            return Objects.hash(this.key);
        }

        public String toString() {
            return "ResetOption{key='" + this.key + "'}";
        }
    }

    @PublicEvolving
    public static class SetOption
    implements CatalogTableChange {
        private final String key;
        private final String value;

        private SetOption(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof SetOption)) {
                return false;
            }
            SetOption setOption = (SetOption)o;
            return Objects.equals(this.key, setOption.key) && Objects.equals(this.value, setOption.value);
        }

        public int hashCode() {
            return Objects.hash(this.key, this.value);
        }

        public String toString() {
            return "SetOption{key='" + this.key + "', value='" + this.value + "'}";
        }
    }

    @PublicEvolving
    public static class DropDistribution
    implements CatalogTableChange {
        static final DropDistribution INSTANCE = new DropDistribution();

        public String toString() {
            return "DropDistribution";
        }
    }

    @PublicEvolving
    public static class DropConstraint
    implements CatalogTableChange {
        private final String constraintName;

        private DropConstraint(String constraintName) {
            this.constraintName = constraintName;
        }

        public String getConstraintName() {
            return this.constraintName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DropConstraint)) {
                return false;
            }
            DropConstraint that = (DropConstraint)o;
            return Objects.equals(this.constraintName, that.constraintName);
        }

        public int hashCode() {
            return Objects.hash(this.constraintName);
        }

        public String toString() {
            return "DropConstraint{constraintName='" + this.constraintName + "'}";
        }
    }

    @PublicEvolving
    public static class DropWatermark
    implements CatalogTableChange {
        static final DropWatermark INSTANCE = new DropWatermark();

        public String toString() {
            return "DropWatermark";
        }
    }

    @PublicEvolving
    public static class DropColumn
    implements CatalogTableChange,
    MaterializedTableChange {
        private final String columnName;

        private DropColumn(String columnName) {
            this.columnName = columnName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DropColumn)) {
                return false;
            }
            DropColumn that = (DropColumn)o;
            return Objects.equals(this.columnName, that.columnName);
        }

        public int hashCode() {
            return Objects.hash(this.columnName);
        }

        public String toString() {
            return "DropColumn{columnName='" + this.columnName + "'}";
        }
    }

    @PublicEvolving
    public static class ModifyWatermark
    implements CatalogTableChange {
        private final WatermarkSpec newWatermark;

        public ModifyWatermark(WatermarkSpec newWatermark) {
            this.newWatermark = newWatermark;
        }

        public WatermarkSpec getNewWatermark() {
            return this.newWatermark;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModifyWatermark)) {
                return false;
            }
            ModifyWatermark that = (ModifyWatermark)o;
            return Objects.equals(this.newWatermark, that.newWatermark);
        }

        public int hashCode() {
            return Objects.hash(this.newWatermark);
        }

        public String toString() {
            return "ModifyWatermark{newWatermark=" + String.valueOf(this.newWatermark) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyDistribution
    implements CatalogTableChange {
        private final TableDistribution distribution;

        private ModifyDistribution(TableDistribution distribution) {
            this.distribution = distribution;
        }

        public TableDistribution getDistribution() {
            return this.distribution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModifyDistribution)) {
                return false;
            }
            ModifyDistribution that = (ModifyDistribution)o;
            return Objects.equals(this.distribution, that.distribution);
        }

        public int hashCode() {
            return Objects.hash(this.distribution);
        }

        public String toString() {
            return "ModifyDistribution{distribution=" + String.valueOf(this.distribution) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyUniqueConstraint
    implements CatalogTableChange {
        private final UniqueConstraint newConstraint;

        public ModifyUniqueConstraint(UniqueConstraint newConstraint) {
            this.newConstraint = newConstraint;
        }

        public UniqueConstraint getNewConstraint() {
            return this.newConstraint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModifyUniqueConstraint)) {
                return false;
            }
            ModifyUniqueConstraint that = (ModifyUniqueConstraint)o;
            return Objects.equals(this.newConstraint, that.newConstraint);
        }

        public int hashCode() {
            return Objects.hash(this.newConstraint);
        }

        public String toString() {
            return "ModifyUniqueConstraint{newConstraint=" + String.valueOf(this.newConstraint) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyColumnName
    extends ModifyColumn {
        private ModifyColumnName(Column oldColumn, String newName) {
            super(oldColumn, ModifyColumnName.createNewColumn(oldColumn, newName), null);
        }

        private static Column createNewColumn(Column oldColumn, String newName) {
            if (oldColumn instanceof Column.PhysicalColumn) {
                return Column.physical(newName, oldColumn.getDataType()).withComment(oldColumn.comment);
            }
            if (oldColumn instanceof Column.MetadataColumn) {
                Column.MetadataColumn metadataColumn = (Column.MetadataColumn)oldColumn;
                return Column.metadata(newName, oldColumn.getDataType(), metadataColumn.getMetadataKey().orElse(null), metadataColumn.isVirtual()).withComment(oldColumn.comment);
            }
            return Column.computed(newName, ((Column.ComputedColumn)oldColumn).getExpression()).withComment(oldColumn.comment);
        }

        public String getOldColumnName() {
            return this.oldColumn.getName();
        }

        public String getNewColumnName() {
            return this.newColumn.getName();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ModifyColumnName && super.equals(o);
        }

        @Override
        public String toString() {
            return "ModifyColumnName{Column=" + String.valueOf(this.oldColumn) + ", newName=" + this.getNewColumnName() + "}";
        }
    }

    @PublicEvolving
    public static class ModifyPhysicalColumnType
    extends ModifyColumn {
        private ModifyPhysicalColumnType(Column oldColumn, DataType newType) {
            super(oldColumn, oldColumn.copy(newType), null);
            Preconditions.checkArgument((boolean)oldColumn.isPhysical());
        }

        public DataType getNewType() {
            return this.newColumn.getDataType();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ModifyPhysicalColumnType && super.equals(o);
        }

        @Override
        public String toString() {
            return "ModifyPhysicalColumnType{Column=" + String.valueOf(this.oldColumn) + ", newType=" + String.valueOf(this.getNewType()) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyColumnPosition
    extends ModifyColumn {
        public ModifyColumnPosition(Column oldColumn, ColumnPosition newPosition) {
            super(oldColumn, oldColumn, newPosition);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ModifyColumnPosition && super.equals(o);
        }

        @Override
        public String toString() {
            return "ModifyColumnPosition{Column=" + String.valueOf(this.oldColumn) + ", newPosition=" + String.valueOf(this.newPosition) + "}";
        }
    }

    @PublicEvolving
    public static class ModifyColumnComment
    extends ModifyColumn {
        private final String newComment;

        private ModifyColumnComment(Column oldColumn, String newComment) {
            super(oldColumn, oldColumn.withComment(newComment), null);
            this.newComment = newComment;
        }

        public String getNewComment() {
            return this.newComment;
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof ModifyColumnComment && super.equals(o);
        }

        @Override
        public String toString() {
            return "ModifyColumnComment{Column=" + String.valueOf(this.oldColumn) + ", newComment='" + this.newComment + "'}";
        }
    }

    @PublicEvolving
    public static class ModifyColumn
    implements CatalogTableChange {
        protected final Column oldColumn;
        protected final Column newColumn;
        @Nullable
        protected final ColumnPosition newPosition;

        public ModifyColumn(Column oldColumn, Column newColumn, @Nullable ColumnPosition newPosition) {
            this.oldColumn = oldColumn;
            this.newColumn = newColumn;
            this.newPosition = newPosition;
        }

        public Column getOldColumn() {
            return this.oldColumn;
        }

        public Column getNewColumn() {
            return this.newColumn;
        }

        @Nullable
        public ColumnPosition getNewPosition() {
            return this.newPosition;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ModifyColumn)) {
                return false;
            }
            ModifyColumn that = (ModifyColumn)o;
            return Objects.equals(this.oldColumn, that.oldColumn) && Objects.equals(this.newColumn, that.newColumn) && Objects.equals(this.newPosition, that.newPosition);
        }

        public int hashCode() {
            return Objects.hash(this.oldColumn, this.newColumn, this.newPosition);
        }

        public String toString() {
            return "ModifyColumn{oldColumn=" + String.valueOf(this.oldColumn) + ", newColumn=" + String.valueOf(this.newColumn) + ", newPosition=" + String.valueOf(this.newPosition) + "}";
        }
    }

    @PublicEvolving
    public static class AddWatermark
    implements CatalogTableChange {
        private final WatermarkSpec watermarkSpec;

        private AddWatermark(WatermarkSpec watermarkSpec) {
            this.watermarkSpec = watermarkSpec;
        }

        public WatermarkSpec getWatermark() {
            return this.watermarkSpec;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddWatermark)) {
                return false;
            }
            AddWatermark that = (AddWatermark)o;
            return Objects.equals(this.watermarkSpec, that.watermarkSpec);
        }

        public int hashCode() {
            return Objects.hash(this.watermarkSpec);
        }

        public String toString() {
            return "AddWatermark{watermarkSpec=" + String.valueOf(this.watermarkSpec) + "}";
        }
    }

    @PublicEvolving
    public static class AddDistribution
    implements CatalogTableChange {
        private final TableDistribution distribution;

        private AddDistribution(TableDistribution distribution) {
            this.distribution = distribution;
        }

        public TableDistribution getDistribution() {
            return this.distribution;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddDistribution)) {
                return false;
            }
            AddDistribution that = (AddDistribution)o;
            return Objects.equals(this.distribution, that.distribution);
        }

        public int hashCode() {
            return Objects.hash(this.distribution);
        }

        public String toString() {
            return "AddDistribution{distribution=" + String.valueOf(this.distribution) + "}";
        }
    }

    @PublicEvolving
    public static class AddUniqueConstraint
    implements CatalogTableChange {
        private final UniqueConstraint constraint;

        private AddUniqueConstraint(UniqueConstraint constraint) {
            this.constraint = constraint;
        }

        public UniqueConstraint getConstraint() {
            return this.constraint;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddUniqueConstraint)) {
                return false;
            }
            AddUniqueConstraint that = (AddUniqueConstraint)o;
            return Objects.equals(this.constraint, that.constraint);
        }

        public int hashCode() {
            return Objects.hash(this.constraint);
        }

        public String toString() {
            return "AddUniqueConstraint{constraint=" + String.valueOf(this.constraint) + "}";
        }
    }

    @PublicEvolving
    public static class AddColumn
    implements CatalogTableChange,
    MaterializedTableChange {
        private final Column column;
        private final ColumnPosition position;

        private AddColumn(Column column, ColumnPosition position) {
            this.column = column;
            this.position = position;
        }

        public Column getColumn() {
            return this.column;
        }

        @Nullable
        public ColumnPosition getPosition() {
            return this.position;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AddColumn)) {
                return false;
            }
            AddColumn addColumn = (AddColumn)o;
            return Objects.equals(this.column, addColumn.column) && Objects.equals(this.position, addColumn.position);
        }

        public int hashCode() {
            return Objects.hash(this.column, this.position);
        }

        public String toString() {
            return "AddColumn{column=" + String.valueOf(this.column) + ", position=" + String.valueOf(this.position) + "}";
        }
    }
}

