/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.runtime.operators.rank;

import java.util.Objects;
import org.apache.flink.api.common.functions.OpenContext;
import org.apache.flink.api.common.state.StateTtlConfig;
import org.apache.flink.api.common.state.ValueState;
import org.apache.flink.api.common.state.ValueStateDescriptor;
import org.apache.flink.api.common.typeinfo.Types;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.runtime.generated.GeneratedRecordComparator;
import org.apache.flink.table.runtime.keyselector.RowDataKeySelector;
import org.apache.flink.table.runtime.operators.rank.AbstractTopNFunction;
import org.apache.flink.table.runtime.operators.rank.RankRange;
import org.apache.flink.table.runtime.operators.rank.RankType;
import org.apache.flink.table.runtime.typeutils.InternalTypeInfo;
import org.apache.flink.util.Collector;

public abstract class AbstractSyncStateTopNFunction
extends AbstractTopNFunction {
    private ValueState<Long> rankEndState;
    protected long rankEnd;

    public AbstractSyncStateTopNFunction(StateTtlConfig ttlConfig, InternalTypeInfo<RowData> inputRowType, GeneratedRecordComparator generatedSortKeyComparator, RowDataKeySelector sortKeySelector, RankType rankType, RankRange rankRange, boolean generateUpdateBefore, boolean outputRankNumber) {
        super(ttlConfig, inputRowType, generatedSortKeyComparator, sortKeySelector, rankType, rankRange, generateUpdateBefore, outputRankNumber);
    }

    @Override
    public void open(OpenContext openContext) throws Exception {
        super.open(openContext);
        if (!this.isConstantRankEnd) {
            ValueStateDescriptor rankStateDesc = new ValueStateDescriptor("rankEnd", Types.LONG);
            if (this.ttlConfig.isEnabled()) {
                rankStateDesc.enableTimeToLive(this.ttlConfig);
            }
            this.rankEndState = this.getRuntimeContext().getState(rankStateDesc);
        }
    }

    protected long initRankEnd(RowData row) throws Exception {
        if (this.isConstantRankEnd) {
            this.rankEnd = Objects.requireNonNull(this.constantRankEnd);
            return this.rankEnd;
        }
        Long rankEndValue = (Long)this.rankEndState.value();
        long curRankEnd = (Long)this.rankEndFetcher.apply(row);
        if (rankEndValue == null) {
            this.rankEnd = curRankEnd;
            this.rankEndState.update((Object)this.rankEnd);
            return this.rankEnd;
        }
        this.rankEnd = rankEndValue;
        if (this.rankEnd != curRankEnd) {
            this.invalidCounter.inc();
        }
        return this.rankEnd;
    }

    protected boolean isInRankEnd(long rank) {
        return rank <= this.rankEnd;
    }

    protected boolean isInRankRange(long rank) {
        return rank <= this.rankEnd && rank >= this.rankStart;
    }

    protected void collectInsert(Collector<RowData> out, RowData inputRow, long rank) {
        this.collectInsert(out, inputRow, rank, this.rankEnd);
    }

    protected void collectDelete(Collector<RowData> out, RowData inputRow, long rank) {
        this.collectDelete(out, inputRow, rank, this.rankEnd);
    }

    protected void collectUpdateAfter(Collector<RowData> out, RowData inputRow, long rank) {
        this.collectUpdateAfter(out, inputRow, rank, this.rankEnd);
    }

    protected void collectUpdateBefore(Collector<RowData> out, RowData inputRow, long rank) {
        this.collectUpdateBefore(out, inputRow, rank, this.rankEnd);
    }
}

