/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.catalog;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.api.Schema;
import org.apache.flink.table.api.TableException;
import org.apache.flink.table.catalog.CatalogMaterializedTable;
import org.apache.flink.table.catalog.CatalogModel;
import org.apache.flink.table.catalog.CatalogTable;
import org.apache.flink.table.catalog.Column;
import org.apache.flink.table.catalog.Index;
import org.apache.flink.table.catalog.IntervalFreshness;
import org.apache.flink.table.catalog.ResolvedCatalogMaterializedTable;
import org.apache.flink.table.catalog.ResolvedCatalogModel;
import org.apache.flink.table.catalog.ResolvedCatalogTable;
import org.apache.flink.table.catalog.ResolvedCatalogView;
import org.apache.flink.table.catalog.ResolvedSchema;
import org.apache.flink.table.catalog.TableDistribution;
import org.apache.flink.table.catalog.UniqueConstraint;
import org.apache.flink.table.catalog.WatermarkSpec;
import org.apache.flink.table.catalog.exceptions.CatalogException;
import org.apache.flink.table.expressions.ResolvedExpression;
import org.apache.flink.table.expressions.SqlFactory;
import org.apache.flink.table.types.DataType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.utils.EncodingUtils;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.StringUtils;

@Internal
public final class CatalogPropertiesUtil {
    public static final String IS_GENERIC = "is_generic";
    public static final String FLINK_PROPERTY_PREFIX = "flink.";
    private static final String SEPARATOR = ".";
    private static final String SCHEMA = "schema";
    private static final String NAME = "name";
    private static final String DATA_TYPE = "data-type";
    private static final String EXPR = "expr";
    private static final String METADATA = "metadata";
    private static final String VIRTUAL = "virtual";
    private static final String PRIMARY_KEY = "primary-key";
    private static final String COLUMNS = "columns";
    private static final String PARTITION = "partition";
    private static final String KEYS = "keys";
    private static final String PARTITION_KEYS = CatalogPropertiesUtil.compoundKey("partition", "keys");
    private static final String WATERMARK = "watermark";
    private static final String WATERMARK_ROWTIME = "rowtime";
    private static final String WATERMARK_STRATEGY = "strategy";
    private static final String WATERMARK_STRATEGY_EXPR = CatalogPropertiesUtil.compoundKey("strategy", "expr");
    private static final String WATERMARK_STRATEGY_DATA_TYPE = CatalogPropertiesUtil.compoundKey("strategy", "data-type");
    private static final String PRIMARY_KEY_NAME = CatalogPropertiesUtil.compoundKey("primary-key", "name");
    private static final String PRIMARY_KEY_COLUMNS = CatalogPropertiesUtil.compoundKey("primary-key", "columns");
    private static final String INDEX = "index";
    private static final String INDEX_NAME = "name";
    private static final String INDEX_COLUMNS = "columns";
    private static final String COMMENT = "comment";
    private static final String SNAPSHOT = "snapshot";
    private static final String DEFINITION_QUERY = "definition-query";
    private static final String FRESHNESS_INTERVAL = "freshness-interval";
    private static final String FRESHNESS_UNIT = "freshness-unit";
    private static final String LOGICAL_REFRESH_MODE = "logical-refresh-mode";
    private static final String REFRESH_MODE = "refresh-mode";
    private static final String REFRESH_STATUS = "refresh-status";
    private static final String REFRESH_HANDLER_DESC = "refresh-handler-desc";
    private static final String REFRESH_HANDLER_BYTES = "refresh-handler-bytes";
    private static final String MODEL_INPUT_SCHEMA = "input-schema";
    private static final String MODEL_OUTPUT_SCHEMA = "output-schema";
    private static final String DISTRIBUTION = "distribution";
    private static final String DISTRIBUTION_KIND = "distribution.kind";
    private static final String DISTRIBUTION_BUCKETS = "distribution.buckets";
    private static final String DISTRIBUTION_KEYS = CatalogPropertiesUtil.compoundKey("distribution", "keys");

    public static Map<String, String> serializeCatalogTable(ResolvedCatalogTable resolvedTable, SqlFactory sqlFactory) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            CatalogPropertiesUtil.serializeResolvedSchema(properties, resolvedTable.getResolvedSchema(), sqlFactory);
            String comment = resolvedTable.getComment();
            if (comment != null && !comment.isEmpty()) {
                properties.put(COMMENT, comment);
            }
            Optional<Long> snapshot = resolvedTable.getSnapshot();
            snapshot.ifPresent(snapshotId -> properties.put(SNAPSHOT, Long.toString(snapshotId)));
            CatalogPropertiesUtil.serializePartitionKeys(properties, resolvedTable.getPartitionKeys());
            Optional<TableDistribution> distribution = resolvedTable.getDistribution();
            distribution.ifPresent(d -> CatalogPropertiesUtil.serializeTableDistribution(properties, d));
            properties.putAll(resolvedTable.getOptions());
            properties.remove(IS_GENERIC);
            return properties;
        }
        catch (Exception e) {
            throw new CatalogException("Error in serializing catalog table.", e);
        }
    }

    public static Map<String, String> serializeCatalogView(ResolvedCatalogView resolvedView, SqlFactory sqlFactory) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            CatalogPropertiesUtil.serializeResolvedSchema(properties, resolvedView.getResolvedSchema(), sqlFactory);
            String comment = resolvedView.getComment();
            if (comment != null && !comment.isEmpty()) {
                properties.put(COMMENT, comment);
            }
            properties.putAll(resolvedView.getOptions());
            properties.remove(IS_GENERIC);
            return properties;
        }
        catch (Exception e) {
            throw new CatalogException("Error in serializing catalog view.", e);
        }
    }

    public static Map<String, String> serializeCatalogMaterializedTable(ResolvedCatalogMaterializedTable resolvedMaterializedTable, SqlFactory sqlFactory) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            CatalogPropertiesUtil.serializeResolvedSchema(properties, resolvedMaterializedTable.getResolvedSchema(), sqlFactory);
            String comment = resolvedMaterializedTable.getComment();
            if (comment != null && comment.length() > 0) {
                properties.put(COMMENT, comment);
            }
            Optional<Long> snapshot = resolvedMaterializedTable.getSnapshot();
            snapshot.ifPresent(snapshotId -> properties.put(SNAPSHOT, Long.toString(snapshotId)));
            CatalogPropertiesUtil.serializePartitionKeys(properties, resolvedMaterializedTable.getPartitionKeys());
            Optional<TableDistribution> distribution = resolvedMaterializedTable.getDistribution();
            distribution.ifPresent(d -> CatalogPropertiesUtil.serializeTableDistribution(properties, d));
            properties.putAll(resolvedMaterializedTable.getOptions());
            properties.put(DEFINITION_QUERY, resolvedMaterializedTable.getDefinitionQuery());
            IntervalFreshness intervalFreshness = resolvedMaterializedTable.getDefinitionFreshness();
            properties.put(FRESHNESS_INTERVAL, intervalFreshness.getInterval());
            properties.put(FRESHNESS_UNIT, intervalFreshness.getTimeUnit().name());
            properties.put(LOGICAL_REFRESH_MODE, resolvedMaterializedTable.getLogicalRefreshMode().name());
            properties.put(REFRESH_MODE, resolvedMaterializedTable.getRefreshMode().name());
            properties.put(REFRESH_STATUS, resolvedMaterializedTable.getRefreshStatus().name());
            resolvedMaterializedTable.getRefreshHandlerDescription().ifPresent(refreshHandlerDesc -> properties.put(REFRESH_HANDLER_DESC, (String)refreshHandlerDesc));
            if (resolvedMaterializedTable.getSerializedRefreshHandler() != null) {
                properties.put(REFRESH_HANDLER_BYTES, EncodingUtils.encodeBytesToBase64(resolvedMaterializedTable.getSerializedRefreshHandler()));
            }
            return properties;
        }
        catch (Exception e) {
            throw new CatalogException("Error in serializing catalog materialized table.", e);
        }
    }

    public static Map<String, String> serializeResolvedCatalogModel(ResolvedCatalogModel resolvedModel, SqlFactory sqlFactory) {
        try {
            HashMap<String, String> properties = new HashMap<String, String>();
            CatalogPropertiesUtil.serializeResolvedModelSchema(properties, resolvedModel.getResolvedInputSchema(), resolvedModel.getResolvedOutputSchema(), sqlFactory);
            String comment = resolvedModel.getComment();
            if (comment != null && !comment.isEmpty()) {
                properties.put(COMMENT, comment);
            }
            properties.putAll(resolvedModel.getOptions());
            return properties;
        }
        catch (Exception e) {
            throw new CatalogException("Error in serializing catalog model.", e);
        }
    }

    public static CatalogTable deserializeCatalogTable(Map<String, String> properties) {
        return CatalogPropertiesUtil.deserializeCatalogTable(properties, null);
    }

    public static CatalogTable deserializeCatalogTable(Map<String, String> properties, @Nullable String fallbackKey) {
        try {
            int count = CatalogPropertiesUtil.getCount(properties, SCHEMA, "name");
            String schemaKey = SCHEMA;
            if (count == 0 && fallbackKey != null) {
                schemaKey = fallbackKey;
            }
            Schema schema = CatalogPropertiesUtil.deserializeSchema(properties, schemaKey);
            String comment = properties.get(COMMENT);
            Long snapshot = properties.containsKey(SNAPSHOT) ? CatalogPropertiesUtil.getValue(properties, SNAPSHOT, Long::parseLong) : null;
            List<String> partitionKeys = CatalogPropertiesUtil.deserializePartitionKeys(properties);
            Map<String, String> options = CatalogPropertiesUtil.deserializeOptions(properties);
            TableDistribution distribution = CatalogPropertiesUtil.deserializeTableDistribution(properties);
            return CatalogTable.newBuilder().schema(schema).comment(comment).partitionKeys(partitionKeys).distribution(distribution).options(options).snapshot(snapshot).build();
        }
        catch (Exception e) {
            throw new CatalogException("Error in deserializing catalog table.", e);
        }
    }

    public static CatalogMaterializedTable deserializeCatalogMaterializedTable(Map<String, String> properties) {
        try {
            Schema schema = CatalogPropertiesUtil.deserializeSchema(properties, SCHEMA);
            String comment = properties.get(COMMENT);
            Long snapshot = properties.containsKey(SNAPSHOT) ? CatalogPropertiesUtil.getValue(properties, SNAPSHOT, Long::parseLong) : null;
            List<String> partitionKeys = CatalogPropertiesUtil.deserializePartitionKeys(properties);
            Map<String, String> options = CatalogPropertiesUtil.deserializeOptions(properties);
            String definitionQuery = properties.get(DEFINITION_QUERY);
            String freshnessInterval = properties.get(FRESHNESS_INTERVAL);
            IntervalFreshness.TimeUnit timeUnit = IntervalFreshness.TimeUnit.valueOf(properties.get(FRESHNESS_UNIT));
            IntervalFreshness freshness = IntervalFreshness.of(freshnessInterval, timeUnit);
            CatalogMaterializedTable.LogicalRefreshMode logicalRefreshMode = CatalogMaterializedTable.LogicalRefreshMode.valueOf(properties.get(LOGICAL_REFRESH_MODE));
            CatalogMaterializedTable.RefreshMode refreshMode = CatalogMaterializedTable.RefreshMode.valueOf(properties.get(REFRESH_MODE));
            CatalogMaterializedTable.RefreshStatus refreshStatus = CatalogMaterializedTable.RefreshStatus.valueOf(properties.get(REFRESH_STATUS));
            String refreshHandlerDesc = properties.get(REFRESH_HANDLER_DESC);
            String refreshHandlerStringBytes = properties.get(REFRESH_HANDLER_BYTES);
            byte[] refreshHandlerBytes = StringUtils.isNullOrWhitespaceOnly((String)refreshHandlerStringBytes) ? null : EncodingUtils.decodeBase64ToBytes(refreshHandlerStringBytes);
            TableDistribution distribution = CatalogPropertiesUtil.deserializeTableDistribution(properties);
            CatalogMaterializedTable.Builder builder = CatalogMaterializedTable.newBuilder();
            builder.schema(schema).comment(comment).partitionKeys(partitionKeys).distribution(distribution).options(options).snapshot(snapshot).definitionQuery(definitionQuery).freshness(freshness).logicalRefreshMode(logicalRefreshMode).refreshMode(refreshMode).refreshStatus(refreshStatus).refreshHandlerDescription(refreshHandlerDesc).serializedRefreshHandler(refreshHandlerBytes);
            return builder.build();
        }
        catch (Exception e) {
            throw new CatalogException("Error in deserializing catalog materialized table.", e);
        }
    }

    public static CatalogModel deserializeCatalogModel(Map<String, String> properties) {
        try {
            Schema.Builder inputSchemaBuilder = Schema.newBuilder();
            CatalogPropertiesUtil.deserializeColumns(properties, MODEL_INPUT_SCHEMA, inputSchemaBuilder);
            Schema inputSchema = inputSchemaBuilder.build();
            Schema.Builder outputSchemaBuilder = Schema.newBuilder();
            CatalogPropertiesUtil.deserializeColumns(properties, MODEL_OUTPUT_SCHEMA, outputSchemaBuilder);
            Schema outputSchema = outputSchemaBuilder.build();
            Map<String, String> modelOptions = CatalogPropertiesUtil.deserializeOptions(properties);
            String comment = properties.get(COMMENT);
            return CatalogModel.of(inputSchema, outputSchema, modelOptions, comment);
        }
        catch (Exception e) {
            throw new CatalogException("Error in deserializing catalog model.", e);
        }
    }

    private static Map<String, String> deserializeOptions(Map<String, String> map) {
        return map.entrySet().stream().filter(e -> {
            String key = (String)e.getKey();
            return !key.startsWith("distribution.") && !key.startsWith(PARTITION_KEYS + SEPARATOR) && !key.startsWith(SCHEMA) && !key.equals(COMMENT) && !key.equals(SNAPSHOT) && !CatalogPropertiesUtil.isMaterializedTableAttribute(key) && !CatalogPropertiesUtil.isModelAttribute(key);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean isMaterializedTableAttribute(String key) {
        return key.equals(DEFINITION_QUERY) || key.equals(FRESHNESS_INTERVAL) || key.equals(FRESHNESS_UNIT) || key.equals(LOGICAL_REFRESH_MODE) || key.equals(REFRESH_MODE) || key.equals(REFRESH_STATUS) || key.equals(REFRESH_HANDLER_DESC) || key.equals(REFRESH_HANDLER_BYTES);
    }

    private static boolean isModelAttribute(String key) {
        return key.startsWith("input-schema.") || key.startsWith("output-schema.");
    }

    private static List<String> deserializePartitionKeys(Map<String, String> map) {
        int partitionCount = CatalogPropertiesUtil.getCount(map, PARTITION_KEYS, "name");
        ArrayList<String> partitionKeys = new ArrayList<String>();
        for (int i = 0; i < partitionCount; ++i) {
            String partitionNameKey = CatalogPropertiesUtil.compoundKey(PARTITION_KEYS, i, "name");
            String partitionName = CatalogPropertiesUtil.getValue(map, partitionNameKey);
            partitionKeys.add(partitionName);
        }
        return partitionKeys;
    }

    private static TableDistribution deserializeTableDistribution(Map<String, String> map) {
        String distributionKind = map.get(DISTRIBUTION_KIND);
        if (distributionKind == null) {
            return null;
        }
        TableDistribution.Kind kind = TableDistribution.Kind.valueOf(distributionKind);
        Integer bucketCount = map.get(DISTRIBUTION_BUCKETS) == null ? null : Integer.valueOf(map.get(DISTRIBUTION_BUCKETS));
        ArrayList<String> bucketKeys = new ArrayList<String>();
        int i = 0;
        String bucketNameKey = CatalogPropertiesUtil.compoundKey(DISTRIBUTION_KEYS, i, "name");
        while (map.containsKey(bucketNameKey)) {
            String bucketName = CatalogPropertiesUtil.getValue(map, bucketNameKey);
            bucketKeys.add(bucketName);
            bucketNameKey = CatalogPropertiesUtil.compoundKey(DISTRIBUTION_KEYS, ++i, "name");
        }
        return TableDistribution.of(kind, bucketCount, bucketKeys);
    }

    private static Schema deserializeSchema(Map<String, String> map, String schemaKey) {
        Schema.Builder builder = Schema.newBuilder();
        CatalogPropertiesUtil.deserializeColumns(map, schemaKey, builder);
        CatalogPropertiesUtil.deserializeWatermark(map, schemaKey, builder);
        CatalogPropertiesUtil.deserializePrimaryKey(map, schemaKey, builder);
        CatalogPropertiesUtil.deserializeIndexes(map, schemaKey, builder);
        return builder.build();
    }

    private static void deserializeIndexes(Map<String, String> map, String schemaKey, Schema.Builder builder) {
        String indexKey = CatalogPropertiesUtil.compoundKey(schemaKey, INDEX);
        int indexCount = CatalogPropertiesUtil.getCount(map, indexKey, "name");
        for (int i = 0; i < indexCount; ++i) {
            String indexNameKey = CatalogPropertiesUtil.compoundKey(indexKey, i, "name");
            String indexColumnsKey = CatalogPropertiesUtil.compoundKey(indexKey, i, "columns");
            String indexName = CatalogPropertiesUtil.getValue(map, indexNameKey);
            String[] indexColumns = CatalogPropertiesUtil.getValue(map, indexColumnsKey, s -> s.split(","));
            builder.indexNamed(indexName, List.of(indexColumns));
        }
    }

    private static void deserializePrimaryKey(Map<String, String> map, String schemaKey, Schema.Builder builder) {
        String constraintNameKey = CatalogPropertiesUtil.compoundKey(schemaKey, PRIMARY_KEY_NAME);
        String columnsKey = CatalogPropertiesUtil.compoundKey(schemaKey, PRIMARY_KEY_COLUMNS);
        if (map.containsKey(constraintNameKey)) {
            String constraintName = CatalogPropertiesUtil.getValue(map, constraintNameKey);
            String[] columns = CatalogPropertiesUtil.getValue(map, columnsKey, s -> s.split(","));
            builder.primaryKeyNamed(constraintName, columns);
        }
    }

    private static void deserializeWatermark(Map<String, String> map, String schemaKey, Schema.Builder builder) {
        String watermarkKey = CatalogPropertiesUtil.compoundKey(schemaKey, WATERMARK);
        int watermarkCount = CatalogPropertiesUtil.getCount(map, watermarkKey, WATERMARK_ROWTIME);
        for (int i = 0; i < watermarkCount; ++i) {
            String rowtimeKey = CatalogPropertiesUtil.compoundKey(watermarkKey, i, WATERMARK_ROWTIME);
            String exprKey = CatalogPropertiesUtil.compoundKey(watermarkKey, i, WATERMARK_STRATEGY_EXPR);
            String rowtime = CatalogPropertiesUtil.getValue(map, rowtimeKey);
            String expr = CatalogPropertiesUtil.getValue(map, exprKey);
            builder.watermark(rowtime, expr);
        }
    }

    private static void deserializeColumns(Map<String, String> map, String schemaKey, Schema.Builder builder) {
        int fieldCount = CatalogPropertiesUtil.getCount(map, schemaKey, "name");
        for (int i = 0; i < fieldCount; ++i) {
            String nameKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, "name");
            String dataTypeKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, DATA_TYPE);
            String exprKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, EXPR);
            String metadataKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, METADATA);
            String virtualKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, VIRTUAL);
            String commentKey = CatalogPropertiesUtil.compoundKey(schemaKey, i, COMMENT);
            String name = CatalogPropertiesUtil.getValue(map, nameKey);
            if (map.containsKey(exprKey)) {
                String expr = CatalogPropertiesUtil.getValue(map, exprKey);
                builder.columnByExpression(name, expr);
            } else if (map.containsKey(metadataKey)) {
                String metadata = CatalogPropertiesUtil.getValue(map, metadataKey);
                String dataType = CatalogPropertiesUtil.getValue(map, dataTypeKey);
                boolean isVirtual = CatalogPropertiesUtil.getValue(map, virtualKey, Boolean::parseBoolean);
                if (metadata.equals(name)) {
                    builder.columnByMetadata(name, dataType, null, isVirtual);
                } else {
                    builder.columnByMetadata(name, dataType, metadata, isVirtual);
                }
            } else {
                String dataType = CatalogPropertiesUtil.getValue(map, dataTypeKey);
                builder.column(name, dataType);
            }
            if (!map.containsKey(commentKey)) continue;
            String comment = CatalogPropertiesUtil.getValue(map, commentKey);
            builder.withComment(comment);
        }
    }

    private static void serializePartitionKeys(Map<String, String> map, List<String> keys) {
        Preconditions.checkNotNull(keys);
        CatalogPropertiesUtil.putIndexedProperties(map, PARTITION_KEYS, Collections.singletonList("name"), keys.stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    private static void serializeTableDistribution(Map<String, String> map, TableDistribution distribution) {
        if (distribution == null) {
            return;
        }
        map.put(DISTRIBUTION_KIND, distribution.getKind().name());
        distribution.getBucketCount().ifPresent(bc -> map.put(DISTRIBUTION_BUCKETS, String.valueOf(bc)));
        CatalogPropertiesUtil.putIndexedProperties(map, DISTRIBUTION_KEYS, Collections.singletonList("name"), distribution.getBucketKeys().stream().map(Collections::singletonList).collect(Collectors.toList()));
    }

    private static void serializeResolvedModelSchema(Map<String, String> map, ResolvedSchema inputSchema, ResolvedSchema outputSchema, SqlFactory sqlFactory) {
        Preconditions.checkNotNull((Object)inputSchema);
        Preconditions.checkNotNull((Object)outputSchema);
        CatalogPropertiesUtil.serializeColumnsWithKey(map, inputSchema.getColumns(), MODEL_INPUT_SCHEMA, sqlFactory);
        CatalogPropertiesUtil.serializeColumnsWithKey(map, outputSchema.getColumns(), MODEL_OUTPUT_SCHEMA, sqlFactory);
    }

    private static void serializeResolvedSchema(Map<String, String> map, ResolvedSchema schema, SqlFactory sqlFactory) {
        Preconditions.checkNotNull((Object)schema);
        CatalogPropertiesUtil.serializeColumns(map, schema.getColumns(), sqlFactory);
        CatalogPropertiesUtil.serializeWatermarkSpecs(map, schema.getWatermarkSpecs(), sqlFactory);
        schema.getPrimaryKey().ifPresent(pk -> CatalogPropertiesUtil.serializePrimaryKey(map, pk));
        CatalogPropertiesUtil.serializeIndexes(map, schema.getIndexes());
    }

    private static void serializeIndexes(Map<String, String> map, List<Index> indexes) {
        if (!indexes.isEmpty()) {
            ArrayList<List<String>> indexValues = new ArrayList<List<String>>();
            for (Index index : indexes) {
                indexValues.add(Arrays.asList(index.getName(), String.join((CharSequence)",", index.getColumns())));
            }
            CatalogPropertiesUtil.putIndexedProperties(map, CatalogPropertiesUtil.compoundKey(SCHEMA, INDEX), Arrays.asList("name", "columns"), indexValues);
        }
    }

    private static void serializePrimaryKey(Map<String, String> map, UniqueConstraint constraint) {
        map.put(CatalogPropertiesUtil.compoundKey(SCHEMA, PRIMARY_KEY_NAME), constraint.getName());
        map.put(CatalogPropertiesUtil.compoundKey(SCHEMA, PRIMARY_KEY_COLUMNS), String.join((CharSequence)",", constraint.getColumns()));
    }

    private static void serializeWatermarkSpecs(Map<String, String> map, List<WatermarkSpec> specs, SqlFactory sqlFactory) {
        if (!specs.isEmpty()) {
            ArrayList<List<String>> watermarkValues = new ArrayList<List<String>>();
            for (WatermarkSpec spec : specs) {
                watermarkValues.add(Arrays.asList(spec.getRowtimeAttribute(), CatalogPropertiesUtil.serializeResolvedExpression(spec.getWatermarkExpression(), sqlFactory), CatalogPropertiesUtil.serializeDataType(spec.getWatermarkExpression().getOutputDataType())));
            }
            CatalogPropertiesUtil.putIndexedProperties(map, CatalogPropertiesUtil.compoundKey(SCHEMA, WATERMARK), Arrays.asList(WATERMARK_ROWTIME, WATERMARK_STRATEGY_EXPR, WATERMARK_STRATEGY_DATA_TYPE), watermarkValues);
        }
    }

    private static void serializeColumns(Map<String, String> map, List<Column> columns, SqlFactory sqlFactory) {
        CatalogPropertiesUtil.serializeColumnsWithKey(map, columns, SCHEMA, sqlFactory);
    }

    private static void serializeColumnsWithKey(Map<String, String> map, List<Column> columns, String schemaKey, SqlFactory sqlFactory) {
        String[] names = CatalogPropertiesUtil.serializeColumnNames(columns);
        String[] dataTypes = CatalogPropertiesUtil.serializeColumnDataTypes(columns);
        String[] expressions = CatalogPropertiesUtil.serializeColumnComputations(columns, sqlFactory);
        String[] metadata = CatalogPropertiesUtil.serializeColumnMetadataKeys(columns);
        String[] virtual = CatalogPropertiesUtil.serializeColumnVirtuality(columns);
        String[] comments = CatalogPropertiesUtil.serializeColumnComments(columns);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        for (int i = 0; i < columns.size(); ++i) {
            values.add(Arrays.asList(names[i], dataTypes[i], expressions[i], metadata[i], virtual[i], comments[i]));
        }
        CatalogPropertiesUtil.putIndexedProperties(map, schemaKey, Arrays.asList("name", DATA_TYPE, EXPR, METADATA, VIRTUAL, COMMENT), values);
    }

    private static String serializeResolvedExpression(ResolvedExpression resolvedExpression, SqlFactory sqlFactory) {
        try {
            return resolvedExpression.asSerializableString(sqlFactory);
        }
        catch (TableException e) {
            throw new TableException(String.format("Expression '%s' cannot be stored in a durable catalog. Currently, only SQL expressions have a well-defined string representation that is used to serialize a catalog object into a map of string-based properties.", resolvedExpression.asSummaryString()), e);
        }
    }

    private static String serializeDataType(DataType dataType) {
        LogicalType type = dataType.getLogicalType();
        try {
            return type.asSerializableString();
        }
        catch (TableException e) {
            throw new TableException(String.format("Data type '%s' cannot be stored in a durable catalog. Only data types that have a well-defined string representation can be used when serializing a catalog object into a map of string-based properties. This excludes anonymously defined, unregistered types such as structured types in particular.", type.asSummaryString()), e);
        }
    }

    private static String[] serializeColumnNames(List<Column> columns) {
        return (String[])columns.stream().map(Column::getName).toArray(String[]::new);
    }

    private static String[] serializeColumnDataTypes(List<Column> columns) {
        return (String[])columns.stream().map(Column::getDataType).map(CatalogPropertiesUtil::serializeDataType).toArray(String[]::new);
    }

    private static String[] serializeColumnComputations(List<Column> columns, SqlFactory sqlFactory) {
        return (String[])columns.stream().map(column -> {
            if (column instanceof Column.ComputedColumn) {
                Column.ComputedColumn c = (Column.ComputedColumn)column;
                return CatalogPropertiesUtil.serializeResolvedExpression(c.getExpression(), sqlFactory);
            }
            return null;
        }).toArray(String[]::new);
    }

    private static String[] serializeColumnMetadataKeys(List<Column> columns) {
        return (String[])columns.stream().map(column -> {
            if (column instanceof Column.MetadataColumn) {
                Column.MetadataColumn c = (Column.MetadataColumn)column;
                return c.getMetadataKey().orElse(c.getName());
            }
            return null;
        }).toArray(String[]::new);
    }

    private static String[] serializeColumnVirtuality(List<Column> columns) {
        return (String[])columns.stream().map(column -> {
            if (column instanceof Column.MetadataColumn) {
                Column.MetadataColumn c = (Column.MetadataColumn)column;
                return Boolean.toString(c.isVirtual());
            }
            return null;
        }).toArray(String[]::new);
    }

    private static String[] serializeColumnComments(List<Column> columns) {
        return (String[])columns.stream().map(c -> c.getComment().orElse(null)).toArray(String[]::new);
    }

    private static void putIndexedProperties(Map<String, String> map, String key, List<String> subKeys, List<List<String>> subKeyValues) {
        Preconditions.checkNotNull((Object)key);
        Preconditions.checkNotNull(subKeys);
        Preconditions.checkNotNull(subKeyValues);
        for (int idx = 0; idx < subKeyValues.size(); ++idx) {
            List<String> values = subKeyValues.get(idx);
            if (values == null || values.size() != subKeys.size()) {
                throw new IllegalArgumentException("Values must have same arity as keys.");
            }
            if (values.stream().allMatch(Objects::isNull)) {
                throw new IllegalArgumentException("Values must have at least one non-null value.");
            }
            for (int keyIdx = 0; keyIdx < values.size(); ++keyIdx) {
                String value = values.get(keyIdx);
                if (value == null) continue;
                map.put(CatalogPropertiesUtil.compoundKey(key, idx, subKeys.get(keyIdx)), values.get(keyIdx));
            }
        }
    }

    private static int getCount(Map<String, String> map, String key, String suffix) {
        String escapedKey = Pattern.quote(key);
        String escapedSuffix = Pattern.quote(suffix);
        String escapedSeparator = Pattern.quote(SEPARATOR);
        Pattern pattern = Pattern.compile("^" + escapedKey + escapedSeparator + "(\\d+)" + escapedSeparator + escapedSuffix);
        IntStream indexes = map.keySet().stream().flatMapToInt(k -> {
            Matcher matcher = pattern.matcher((CharSequence)k);
            if (matcher.find()) {
                return IntStream.of(Integer.parseInt(matcher.group(1)));
            }
            return IntStream.empty();
        });
        return indexes.max().orElse(-1) + 1;
    }

    private static String getValue(Map<String, String> map, String key) {
        return (String)CatalogPropertiesUtil.getValue(map, key, Function.identity());
    }

    private static <T> T getValue(Map<String, String> map, String key, Function<String, T> parser) {
        String value = map.get(key);
        if (value == null) {
            throw new IllegalArgumentException(String.format("Could not find property key '%s'.", key));
        }
        try {
            return parser.apply(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not parse value for property key '%s': %s", key, value));
        }
    }

    private static String compoundKey(Object ... components) {
        return Stream.of(components).map(Object::toString).collect(Collectors.joining(SEPARATOR));
    }

    private CatalogPropertiesUtil() {
    }
}

