/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.router.webapp;

import com.google.inject.Inject;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.router.Router;
import org.apache.hadoop.yarn.server.router.webapp.MetricsOverviewTable;
import org.apache.hadoop.yarn.server.router.webapp.RouterBlock;
import org.apache.hadoop.yarn.server.router.webapp.dao.RouterInfo;
import org.apache.hadoop.yarn.webapp.View;
import org.apache.hadoop.yarn.webapp.view.HtmlBlock;
import org.apache.hadoop.yarn.webapp.view.InfoBlock;

public class AboutBlock
extends RouterBlock {
    private final Router router;

    @Inject
    AboutBlock(Router router, View.ViewContext ctx) {
        super(router, ctx);
        this.router = router;
    }

    protected void render(HtmlBlock.Block html) {
        boolean isEnabled = this.isYarnFederationEnabled();
        this.initUserHelpInformationDiv(html, isEnabled);
        html.__(MetricsOverviewTable.class);
        this.initYarnRouterBasicInformation(isEnabled);
        html.__(InfoBlock.class);
    }

    private void initYarnRouterBasicInformation(boolean isEnabled) {
        FederationStateStoreFacade facade = FederationStateStoreFacade.getInstance((Configuration)this.router.getConfig());
        RouterInfo routerInfo = new RouterInfo(this.router);
        String lastStartTime = DateFormatUtils.format((long)routerInfo.getStartedOn(), (String)"yyyy-MM-dd HH:mm:ss");
        try {
            this.info("Yarn Router Overview").__("Federation Enabled:", (Object)String.valueOf(isEnabled)).__("Router ID:", (Object)routerInfo.getClusterId()).__("Router state:", (Object)routerInfo.getState()).__("Router SubCluster Count:", (Object)facade.getSubClusters(true).size()).__("Router RMStateStore:", (Object)routerInfo.getRouterStateStore()).__("Router started on:", (Object)lastStartTime).__("Router version:", (Object)(routerInfo.getRouterBuildVersion() + " on " + routerInfo.getRouterVersionBuiltOn())).__("Hadoop version:", (Object)(routerInfo.getHadoopBuildVersion() + " on " + routerInfo.getHadoopVersionBuiltOn()));
        }
        catch (YarnException e) {
            LOG.error("initYarnRouterBasicInformation error.", (Throwable)e);
        }
    }
}

