/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.nativetask.buffer;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.mapred.nativetask.buffer.BufferType;

@InterfaceAudience.Private
public class OutputBuffer {
    protected ByteBuffer byteBuffer;
    private final BufferType type;

    public OutputBuffer(BufferType type, int outputBufferCapacity) {
        this.type = type;
        if (outputBufferCapacity > 0) {
            switch (type) {
                case DIRECT_BUFFER: {
                    this.byteBuffer = ByteBuffer.allocateDirect(outputBufferCapacity);
                    this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
                    break;
                }
                case HEAP_BUFFER: {
                    this.byteBuffer = ByteBuffer.allocate(outputBufferCapacity);
                    this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
                }
            }
        }
    }

    public OutputBuffer(byte[] bytes) {
        this.type = BufferType.HEAP_BUFFER;
        int outputBufferCapacity = bytes.length;
        if (outputBufferCapacity > 0) {
            this.byteBuffer = ByteBuffer.wrap(bytes);
            this.byteBuffer.order(ByteOrder.BIG_ENDIAN);
            this.byteBuffer.position(0);
        }
    }

    public BufferType getType() {
        return this.type;
    }

    public ByteBuffer getByteBuffer() {
        return this.byteBuffer;
    }

    public int length() {
        return this.byteBuffer.position();
    }

    public void rewind() {
        this.byteBuffer.position(0);
    }

    public int limit() {
        return this.byteBuffer.limit();
    }
}

