/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import com.microsoft.azure.cosmosdb.rx.internal.Strings;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;

public class GoneException
extends DocumentClientException {
    public GoneException(String msg) {
        this(msg, (String)null);
    }

    public GoneException() {
        this("The requested resource is no longer available at the server.", (String)null);
    }

    public GoneException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(410, error, responseHeaders);
        BridgeInternal.setLSN(this, lsn);
        BridgeInternal.setPartitionKeyRangeId(this, partitionKeyRangeId);
    }

    public GoneException(String message, String requestUri) {
        this(message, (Exception)null, new HashMap<String, String>(), requestUri);
    }

    public GoneException(String message, Exception innerException, URI requestUri, String localIpAddress) {
        this(GoneException.message(localIpAddress, message), innerException, (HttpResponseHeaders)null, requestUri);
    }

    public GoneException(Exception innerException) {
        this("The requested resource is no longer available at the server.", innerException, new HashMap<String, String>(), (String)null);
    }

    public GoneException(String message, HttpResponseHeaders headers, URI requestUri) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUri != null ? requestUri.toString() : null);
    }

    public GoneException(String message, HttpResponseHeaders headers, String requestUri) {
        super(message, null, HttpUtils.asMap(headers), 410, requestUri);
    }

    public GoneException(String message, Exception innerException, HttpResponseHeaders headers, URI requestUri) {
        super(message, innerException, HttpUtils.asMap(headers), 410, requestUri != null ? requestUri.toString() : null);
    }

    public GoneException(String message, Exception innerException, Map<String, String> headers, String requestUri) {
        super(message, innerException, headers, 410, requestUri);
    }

    public GoneException(Error error, Map<String, String> headers) {
        super(410, error, headers);
    }

    private static String message(String localIP, String baseMessage) {
        if (!Strings.isNullOrEmpty(localIP)) {
            return String.format("%s, Local IP: %s", baseMessage, localIP);
        }
        return baseMessage;
    }
}

