/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.sls.synthetic;

import java.util.Collection;
import java.util.Random;
import org.apache.commons.math3.distribution.LogNormalDistribution;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.apache.commons.math3.random.JDKRandomGenerator;

public final class SynthUtils {
    private SynthUtils() {
    }

    public static int getWeighted(Collection<Double> weights, Random rr) {
        double totalWeight = 0.0;
        for (Double i : weights) {
            totalWeight += i.doubleValue();
        }
        double rand = rr.nextDouble() * totalWeight;
        double cur = 0.0;
        int ind = 0;
        for (Double i : weights) {
            if ((cur += i.doubleValue()) > rand) break;
            ++ind;
        }
        return ind;
    }

    public static NormalDistribution getNormalDist(JDKRandomGenerator rand, double average, double stdDev) {
        if (average <= 0.0) {
            return null;
        }
        if (stdDev == 0.0) {
            stdDev = average / 6.0;
        }
        NormalDistribution ret = new NormalDistribution(average, stdDev, 1.0E-9);
        ret.reseedRandomGenerator(rand.nextLong());
        return ret;
    }

    public static LogNormalDistribution getLogNormalDist(JDKRandomGenerator rand, double mean, double stdDev) {
        if (mean <= 0.0) {
            return null;
        }
        if (stdDev == 0.0) {
            stdDev = mean / 6.0;
        }
        double var = stdDev * stdDev;
        double sigmasq = Math.log1p(var / (mean * mean));
        double sigma = Math.sqrt(sigmasq);
        double mu = Math.log(mean) - 0.5 * sigmasq;
        LogNormalDistribution ret = new LogNormalDistribution(mu, sigma, 1.0E-9);
        ret.reseedRandomGenerator(rand.nextLong());
        return ret;
    }
}

