/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.rumen;

import com.fasterxml.jackson.core.JsonEncoding;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.mapreduce.ID;
import org.apache.hadoop.tools.rumen.datatypes.DataType;
import org.apache.hadoop.tools.rumen.serializers.DefaultRumenSerializer;
import org.apache.hadoop.tools.rumen.serializers.ObjectStringSerializer;

public class JsonObjectMapperWriter<T>
implements Closeable {
    private JsonGenerator writer;

    public JsonObjectMapperWriter(OutputStream output, boolean prettyPrint) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        SimpleModule module = new SimpleModule("Default Serializer", new Version(0, 1, 1, "FINAL", "", ""));
        module.addSerializer(DataType.class, (JsonSerializer)new DefaultRumenSerializer());
        module.addSerializer(ID.class, new ObjectStringSerializer());
        mapper.registerModule((Module)module);
        this.writer = mapper.getFactory().createGenerator(output, JsonEncoding.UTF8);
        if (prettyPrint) {
            this.writer.useDefaultPrettyPrinter();
        }
    }

    public void write(T object) throws IOException {
        this.writer.writeObject(object);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }
}

