/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.rx.internal.query;

import com.microsoft.azure.cosmosdb.ChangeFeedOptions;
import com.microsoft.azure.cosmosdb.FeedOptions;
import com.microsoft.azure.cosmosdb.FeedOptionsBase;
import com.microsoft.azure.cosmosdb.FeedResponse;
import com.microsoft.azure.cosmosdb.Resource;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import com.microsoft.azure.cosmosdb.rx.internal.query.Fetcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Observable;
import rx.Observer;
import rx.functions.Func1;
import rx.functions.Func2;
import rx.observables.AsyncOnSubscribe;

public class Paginator {
    private static final Logger logger = LoggerFactory.getLogger(Paginator.class);

    public static <T extends Resource> Observable<FeedResponse<T>> getPaginatedChangeFeedQueryResultAsObservable(ChangeFeedOptions feedOptions, Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Class<T> resourceType, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable((FeedOptionsBase)feedOptions, createRequestFunc, executeFunc, resourceType, -1, maxPageSize, true);
    }

    public static <T extends Resource> Observable<FeedResponse<T>> getPaginatedQueryResultAsObservable(FeedOptions feedOptions, Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Class<T> resourceType, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable(feedOptions, createRequestFunc, executeFunc, resourceType, -1, maxPageSize);
    }

    public static <T extends Resource> Observable<FeedResponse<T>> getPaginatedQueryResultAsObservable(FeedOptions options, Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc, Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Class<T> resourceType, int top, int maxPageSize) {
        return Paginator.getPaginatedQueryResultAsObservable((FeedOptionsBase)options, createRequestFunc, executeFunc, resourceType, top, maxPageSize, false);
    }

    private static <T extends Resource> Observable<FeedResponse<T>> getPaginatedQueryResultAsObservable(final FeedOptionsBase options, final Func2<String, Integer, RxDocumentServiceRequest> createRequestFunc, final Func1<RxDocumentServiceRequest, Observable<FeedResponse<T>>> executeFunc, Class<T> resourceType, final int top, final int maxPageSize, final boolean isChangeFeed) {
        Observable obs = Observable.defer(() -> Observable.create((AsyncOnSubscribe)new AsyncOnSubscribe<Fetcher, FeedResponse<T>>(){

            protected Fetcher generateState() {
                return new Fetcher((Func2<String, Integer, RxDocumentServiceRequest>)createRequestFunc, executeFunc, options, isChangeFeed, top, maxPageSize);
            }

            protected Fetcher next(Fetcher fetcher, long requested, Observer<Observable<? extends FeedResponse<T>>> observer) {
                assert (requested == 1L) : "requested amount expected to be 1";
                if (fetcher.shouldFetchMore()) {
                    Observable respObs = fetcher.nextPage();
                    observer.onNext(respObs);
                } else {
                    logger.debug("No more results");
                    observer.onCompleted();
                }
                return fetcher;
            }
        }).rebatchRequests(1));
        return obs;
    }
}

