/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.function;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.FunctionSet;
import org.ojalgo.function.ParameterFunction;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.function.UnaryFunction;
import org.ojalgo.scalar.PrimitiveScalar;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.type.context.NumberContext;

public final class QuaternionFunction
extends FunctionSet<Quaternion> {
    public static final Unary ABS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return Quaternion.valueOf(arg.norm());
        }
    };
    public static final Unary ACOS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.getPureVersor().negate().multiply(ACOSH.invoke(arg));
        }
    };
    public static final Unary ACOSH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg.add(SQRT.invoke(arg.multiply(arg).subtract(PrimitiveMath.ONE))));
        }
    };
    public static final Binary ADD = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.add(arg2);
        }
    };
    public static final Unary ASIN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = SQRT.invoke(Quaternion.ONE.subtract(POWER.invoke(arg, 2)));
            Quaternion aNumber = tmpNmbr = Quaternion.I.multiply(arg).add(tmpNmbr);
            return LOG.invoke(aNumber).multiply(Quaternion.I).negate();
        }
    };
    public static final Unary ASINH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = arg.multiply(arg).add(PrimitiveMath.ONE);
            return LOG.invoke(arg.add(SQRT.invoke(tmpNmbr)));
        }
    };
    public static final Unary ATAN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = Quaternion.I.add(arg).divide(Quaternion.I.subtract(arg));
            return LOG.invoke(tmpNmbr).multiply(Quaternion.I).divide(PrimitiveMath.TWO);
        }
    };
    public static final Binary ATAN2 = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return ATAN.invoke(arg1.divide(arg2));
        }
    };
    public static final Unary ATANH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpNmbr = arg.add(PrimitiveMath.ONE).divide(Quaternion.ONE.subtract(arg));
            return LOG.invoke(tmpNmbr).divide(PrimitiveMath.TWO);
        }
    };
    public static final Unary CARDINALITY = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return PrimitiveScalar.isSmall(PrimitiveMath.ONE, arg.norm()) ? Quaternion.ZERO : Quaternion.ONE;
        }
    };
    public static final Unary CBRT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return ROOT.invoke(arg, 3);
        }
    };
    public static final Unary CEIL = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            double tmpScalar = PrimitiveFunction.CEIL.invoke(arg.scalar());
            double tmpI = PrimitiveFunction.CEIL.invoke(arg.i);
            double tmpJ = PrimitiveFunction.CEIL.invoke(arg.j);
            double tmpK = PrimitiveFunction.CEIL.invoke(arg.k);
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final Unary CONJUGATE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.conjugate();
        }
    };
    public static final Unary COS = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return COSH.invoke(arg.multiply(Quaternion.I));
        }
    };
    public static final Unary COSH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).add(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final Binary DIVIDE = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.divide(arg2);
        }
    };
    public static final Unary EXP = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            if (arg.isReal()) {
                double tmpScalar = PrimitiveFunction.EXP.invoke(arg.scalar());
                return Quaternion.valueOf(tmpScalar);
            }
            double tmpNorm = PrimitiveFunction.EXP.invoke(arg.scalar());
            double[] tmpUnit = arg.unit();
            double tmpPhase = arg.getVectorLength();
            return Quaternion.makePolar(tmpNorm, tmpUnit, tmpPhase);
        }
    };
    public static final Unary EXPM1 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).subtract(1.0);
        }
    };
    public static final Unary FLOOR = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            double tmpScalar = PrimitiveFunction.FLOOR.invoke(arg.scalar());
            double tmpI = PrimitiveFunction.FLOOR.invoke(arg.i);
            double tmpJ = PrimitiveFunction.FLOOR.invoke(arg.j);
            double tmpK = PrimitiveFunction.FLOOR.invoke(arg.k);
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final Binary HYPOT = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return Quaternion.valueOf(PrimitiveFunction.HYPOT.invoke(arg1.norm(), arg2.norm()));
        }
    };
    public static final Unary INVERT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return POWER.invoke(arg, -1);
        }
    };
    public static final Unary LOG = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            double tmpNorm = arg.norm();
            double[] tmpUnitVector = arg.unit();
            double tmpPhase = PrimitiveFunction.ACOS.invoke(arg.scalar() / tmpNorm);
            double tmpScalar = PrimitiveFunction.LOG.invoke(tmpNorm);
            double tmpI = tmpUnitVector[0] * tmpPhase;
            double tmpJ = tmpUnitVector[1] * tmpPhase;
            double tmpK = tmpUnitVector[2] * tmpPhase;
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final Unary LOG10 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg).divide(PrimitiveFunction.LOG.invoke(10.0));
        }
    };
    public static final Unary LOG1P = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(arg.add(1.0));
        }
    };
    public static final Unary LOGISTIC = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return Quaternion.ONE.divide(Quaternion.ONE.add(EXP.invoke(arg.negate())));
        }
    };
    public static final Unary LOGIT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return LOG.invoke(Quaternion.ONE.divide(Quaternion.ONE.subtract(arg)));
        }
    };
    public static final Binary MAX = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            Quaternion retVal = null;
            retVal = arg1.norm() >= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final Binary MIN = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            Quaternion retVal = null;
            retVal = arg1.norm() <= arg2.norm() ? arg1 : arg2;
            return retVal;
        }
    };
    public static final Binary MULTIPLY = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.multiply(arg2);
        }
    };
    public static final Unary NEGATE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.negate();
        }
    };
    public static final Binary POW = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return EXP.invoke(LOG.invoke(arg1).multiply(arg2));
        }
    };
    public static final Parameter POWER = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            Quaternion tmpInvoke = LOG.invoke(arg);
            Quaternion tmpMultiply = tmpInvoke.multiply(param);
            return EXP.invoke(tmpMultiply);
        }
    };
    public static final Unary RINT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            double tmpScalar = PrimitiveFunction.RINT.invoke(arg.scalar());
            double tmpI = PrimitiveFunction.RINT.invoke(arg.i);
            double tmpJ = PrimitiveFunction.RINT.invoke(arg.j);
            double tmpK = PrimitiveFunction.RINT.invoke(arg.k);
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final Parameter ROOT = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            if (param != 0) {
                return EXP.invoke(LOG.invoke(arg).divide(param));
            }
            throw new IllegalArgumentException();
        }
    };
    public static final Parameter SCALE = new Parameter(){

        @Override
        public final Quaternion invoke(Quaternion arg, int param) {
            double tmpScalar = PrimitiveFunction.SCALE.invoke(arg.scalar(), param);
            double tmpI = PrimitiveFunction.SCALE.invoke(arg.i, param);
            double tmpJ = PrimitiveFunction.SCALE.invoke(arg.j, param);
            double tmpK = PrimitiveFunction.SCALE.invoke(arg.k, param);
            return Quaternion.of(tmpScalar, tmpI, tmpJ, tmpK);
        }
    };
    public static final Unary SIGNUM = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg.signum();
        }
    };
    public static final Unary SIN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return SINH.invoke(arg.multiply(Quaternion.I)).multiply(Quaternion.I.negate());
        }
    };
    public static final Unary SINH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return EXP.invoke(arg).subtract(EXP.invoke(arg.negate())).divide(PrimitiveMath.TWO);
        }
    };
    public static final Unary SQRT = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return ROOT.invoke(arg, 2);
        }
    };
    public static final Unary SQRT1PX2 = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return SQRT.invoke(Quaternion.ONE.add(arg.multiply(arg)));
        }
    };
    public static final Binary SUBTRACT = new Binary(){

        @Override
        public final Quaternion invoke(Quaternion arg1, Quaternion arg2) {
            return arg1.subtract(arg2);
        }
    };
    public static final Unary TAN = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return TANH.invoke(arg.multiply(Quaternion.I)).multiply(Quaternion.I.negate());
        }
    };
    public static final Unary TANH = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            Quaternion tmpDivisor;
            Quaternion tmpMinus;
            Quaternion tmpPlus = EXP.invoke(arg);
            Quaternion tmpDividend = tmpPlus.subtract(tmpMinus = EXP.invoke(arg.negate()));
            Quaternion retVal = tmpDividend.equals(tmpDivisor = tmpPlus.add(tmpMinus)) ? Quaternion.ONE : (tmpDividend.equals(tmpDivisor.negate()) ? Quaternion.ONE.negate() : tmpDividend.divide(tmpDivisor));
            return retVal;
        }
    };
    public static final Unary VALUE = new Unary(){

        @Override
        public final Quaternion invoke(Quaternion arg) {
            return arg;
        }
    };
    private static final double _1_0 = 1.0;
    private static final QuaternionFunction SET = new QuaternionFunction();

    public static QuaternionFunction getSet() {
        return SET;
    }

    private QuaternionFunction() {
    }

    @Override
    public UnaryFunction<Quaternion> abs() {
        return ABS;
    }

    @Override
    public UnaryFunction<Quaternion> acos() {
        return ACOS;
    }

    @Override
    public UnaryFunction<Quaternion> acosh() {
        return ACOSH;
    }

    @Override
    public BinaryFunction<Quaternion> add() {
        return ADD;
    }

    @Override
    public UnaryFunction<Quaternion> asin() {
        return ASIN;
    }

    @Override
    public UnaryFunction<Quaternion> asinh() {
        return ASINH;
    }

    @Override
    public UnaryFunction<Quaternion> atan() {
        return ATAN;
    }

    @Override
    public BinaryFunction<Quaternion> atan2() {
        return ATAN2;
    }

    @Override
    public UnaryFunction<Quaternion> atanh() {
        return ATANH;
    }

    @Override
    public UnaryFunction<Quaternion> cardinality() {
        return CARDINALITY;
    }

    @Override
    public UnaryFunction<Quaternion> cbrt() {
        return CBRT;
    }

    @Override
    public UnaryFunction<Quaternion> ceil() {
        return CEIL;
    }

    @Override
    public UnaryFunction<Quaternion> conjugate() {
        return CONJUGATE;
    }

    @Override
    public UnaryFunction<Quaternion> cos() {
        return COS;
    }

    @Override
    public UnaryFunction<Quaternion> cosh() {
        return COSH;
    }

    @Override
    public BinaryFunction<Quaternion> divide() {
        return DIVIDE;
    }

    public Unary enforce(NumberContext context) {
        return t -> Quaternion.valueOf(context.enforce(t));
    }

    @Override
    public UnaryFunction<Quaternion> exp() {
        return EXP;
    }

    @Override
    public UnaryFunction<Quaternion> expm1() {
        return EXPM1;
    }

    @Override
    public UnaryFunction<Quaternion> floor() {
        return FLOOR;
    }

    @Override
    public BinaryFunction<Quaternion> hypot() {
        return HYPOT;
    }

    @Override
    public UnaryFunction<Quaternion> invert() {
        return INVERT;
    }

    @Override
    public UnaryFunction<Quaternion> log() {
        return LOG;
    }

    @Override
    public UnaryFunction<Quaternion> log10() {
        return LOG10;
    }

    @Override
    public UnaryFunction<Quaternion> log1p() {
        return LOG1P;
    }

    @Override
    public UnaryFunction<Quaternion> logistic() {
        return LOGISTIC;
    }

    @Override
    public UnaryFunction<Quaternion> logit() {
        return LOGIT;
    }

    @Override
    public BinaryFunction<Quaternion> max() {
        return MAX;
    }

    @Override
    public BinaryFunction<Quaternion> min() {
        return MIN;
    }

    @Override
    public BinaryFunction<Quaternion> multiply() {
        return MULTIPLY;
    }

    @Override
    public UnaryFunction<Quaternion> negate() {
        return NEGATE;
    }

    @Override
    public BinaryFunction<Quaternion> pow() {
        return POW;
    }

    @Override
    public ParameterFunction<Quaternion> power() {
        return POWER;
    }

    @Override
    public UnaryFunction<Quaternion> rint() {
        return RINT;
    }

    @Override
    public ParameterFunction<Quaternion> root() {
        return ROOT;
    }

    @Override
    public ParameterFunction<Quaternion> scale() {
        return SCALE;
    }

    @Override
    public UnaryFunction<Quaternion> signum() {
        return SIGNUM;
    }

    @Override
    public UnaryFunction<Quaternion> sin() {
        return SIN;
    }

    @Override
    public UnaryFunction<Quaternion> sinh() {
        return SINH;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt() {
        return SQRT;
    }

    @Override
    public UnaryFunction<Quaternion> sqrt1px2() {
        return SQRT1PX2;
    }

    @Override
    public BinaryFunction<Quaternion> subtract() {
        return SUBTRACT;
    }

    @Override
    public UnaryFunction<Quaternion> tan() {
        return TAN;
    }

    @Override
    public UnaryFunction<Quaternion> tanh() {
        return TANH;
    }

    @Override
    public UnaryFunction<Quaternion> value() {
        return VALUE;
    }

    @FunctionalInterface
    public static interface Unary
    extends UnaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg) {
            return this.invoke(Quaternion.valueOf(arg)).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Parameter
    extends ParameterFunction<Quaternion> {
        @Override
        default public double invoke(double arg, int param) {
            return this.invoke(Quaternion.valueOf(arg), param).doubleValue();
        }
    }

    @FunctionalInterface
    public static interface Binary
    extends BinaryFunction<Quaternion> {
        @Override
        default public double invoke(double arg1, double arg2) {
            return this.invoke(Quaternion.valueOf(arg1), Quaternion.valueOf(arg2)).doubleValue();
        }
    }
}

