/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import java.math.BigDecimal;
import java.util.Objects;
import java.util.Optional;
import org.ojalgo.access.Access1D;
import org.ojalgo.access.Access2D;
import org.ojalgo.access.AccessUtils;
import org.ojalgo.access.Structure2D;
import org.ojalgo.array.Array1D;
import org.ojalgo.matrix.MatrixUtils;
import org.ojalgo.matrix.decomposition.DynamicEvD;
import org.ojalgo.matrix.decomposition.HermitianEvD;
import org.ojalgo.matrix.decomposition.MatrixDecomposition;
import org.ojalgo.matrix.decomposition.OldGeneralEvD;
import org.ojalgo.matrix.decomposition.RawEigenvalue;
import org.ojalgo.matrix.store.ComplexDenseStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.type.context.NumberContext;

public interface Eigenvalue<N extends Number>
extends MatrixDecomposition<N>,
MatrixDecomposition.Hermitian<N>,
MatrixDecomposition.Determinant<N>,
MatrixDecomposition.Values<N> {
    public static final Factory<BigDecimal> BIG = (typical, hermitian) -> hermitian ? new HermitianEvD.Big() : null;
    public static final Factory<ComplexNumber> COMPLEX = (typical, hermitian) -> hermitian ? new HermitianEvD.Complex() : null;
    public static final Factory<Double> PRIMITIVE = new Factory<Double>(){

        @Override
        public Eigenvalue<Double> make(Structure2D typical) {
            if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new DynamicEvD.Primitive();
            }
            return new RawEigenvalue.Dynamic();
        }

        @Override
        public Eigenvalue<Double> make(Structure2D typical, boolean hermitian) {
            if (hermitian) {
                if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                    return new HermitianEvD.SimultaneousPrimitive();
                }
                return new RawEigenvalue.Symmetric();
            }
            if (8192L < typical.countColumns() && typical.count() <= 0x7FFFFFF7L) {
                return new OldGeneralEvD.Primitive();
            }
            return new RawEigenvalue.General();
        }
    };

    public static <N extends Number> Eigenvalue<N> make(Access2D<N> typical) {
        return Eigenvalue.make(typical, MatrixUtils.isHermitian(typical));
    }

    public static <N extends Number> Eigenvalue<N> make(Access2D<N> typical, boolean hermitian) {
        N tmpNumber = typical.get(0L, 0L);
        if (tmpNumber instanceof BigDecimal) {
            return BIG.make(typical, hermitian);
        }
        if (tmpNumber instanceof ComplexNumber) {
            return COMPLEX.make(typical, hermitian);
        }
        if (tmpNumber instanceof Double) {
            return PRIMITIVE.make(typical, hermitian);
        }
        throw new IllegalArgumentException();
    }

    public static <N extends Number> boolean equals(MatrixStore<N> matrix, Eigenvalue<N> decomposition, NumberContext context) {
        MatrixStore<N> tmpD = decomposition.getD();
        MatrixStore<MatrixStore<N>> tmpV = decomposition.getV();
        MatrixStore<MatrixStore<N>> tmpStore1 = matrix.multiply(tmpV);
        MatrixStore<MatrixStore<N>> tmpStore2 = tmpV.multiply(tmpD);
        return AccessUtils.equals(tmpStore1, tmpStore2, context);
    }

    public static <N extends Number> MatrixStore<N> reconstruct(Eigenvalue<N> decomposition) {
        MatrixStore<MatrixStore<N>> tmpV = decomposition.getV();
        return tmpV.multiply(decomposition.getD()).multiply((MatrixStore<Object>)tmpV.conjugate());
    }

    @Deprecated
    default public void copyEigenvector(int index, Array1D<ComplexNumber> destination) {
        MatrixStore<N> tmpV = this.getV();
        MatrixStore<N> tmpD = this.getD();
        long tmpDimension = tmpD.countColumns();
        int prevCol = index - 1;
        int nextCol = index + 1;
        if ((long)index < tmpDimension - 1L && tmpD.doubleValue(nextCol, index) != 0.0) {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set(i, (Object)ComplexNumber.of(tmpV.doubleValue(i, index), tmpV.doubleValue(i, nextCol)));
                ++i;
            }
        } else if (index > 0 && tmpD.doubleValue(prevCol, index) != 0.0) {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set(i, (Object)ComplexNumber.of(tmpV.doubleValue(i, prevCol), -tmpV.doubleValue(i, index)));
                ++i;
            }
        } else {
            int i = 0;
            while ((long)i < tmpDimension) {
                destination.set((long)i, tmpV.doubleValue(i, index));
                ++i;
            }
        }
    }

    public MatrixStore<N> getD();

    default public Eigenpair getEigenpair(int index) {
        long tmpDimension = this.getV().countColumns();
        ComplexDenseStore retVal = (ComplexDenseStore)ComplexDenseStore.FACTORY.makeZero(tmpDimension, 1L);
        this.copyEigenvector(index, (Array1D<ComplexNumber>)retVal.sliceColumn(0L, index));
        return new Eigenpair((ComplexNumber)this.getEigenvalues().get(index), retVal);
    }

    public Array1D<ComplexNumber> getEigenvalues();

    default public void getEigenvalues(double[] realParts, Optional<double[]> imaginaryParts) {
        Objects.requireNonNull(realParts);
        Objects.requireNonNull(imaginaryParts);
        Array1D<ComplexNumber> values = this.getEigenvalues();
        int length = realParts.length;
        if (imaginaryParts.isPresent()) {
            double[] imagParts = imaginaryParts.get();
            for (int i = 0; i < length; ++i) {
                ComplexNumber value = (ComplexNumber)values.get(i);
                realParts[i] = value.getReal();
                imagParts[i] = value.getImaginary();
            }
        } else {
            for (int i = 0; i < length; ++i) {
                realParts[i] = values.doubleValue(i);
            }
        }
    }

    @Deprecated
    default public MatrixStore<ComplexNumber> getEigenvector(int index) {
        long tmpDimension = this.getV().countColumns();
        ComplexDenseStore retVal = (ComplexDenseStore)ComplexDenseStore.FACTORY.makeZero(tmpDimension, 1L);
        this.copyEigenvector(index, (Array1D<ComplexNumber>)retVal.sliceColumn(0L, index));
        return retVal;
    }

    default public MatrixStore<ComplexNumber> getEigenvectors() {
        long tmpDimension = this.getV().countColumns();
        ComplexDenseStore retVal = (ComplexDenseStore)ComplexDenseStore.FACTORY.makeZero(tmpDimension, tmpDimension);
        int j = 0;
        while ((long)j < tmpDimension) {
            this.copyEigenvector(j, (Array1D<ComplexNumber>)retVal.sliceColumn(0L, j));
            ++j;
        }
        return retVal;
    }

    public ComplexNumber getTrace();

    public MatrixStore<N> getV();

    public boolean isHermitian();

    @Override
    public boolean isOrdered();

    @Override
    default public MatrixStore<N> reconstruct() {
        return Eigenvalue.reconstruct(this);
    }

    public static interface Factory<N extends Number>
    extends MatrixDecomposition.Factory<Eigenvalue<N>> {
        default public Eigenvalue<N> make(boolean hermitian) {
            return this.make(MatrixDecomposition.TYPICAL, hermitian);
        }

        @Override
        default public Eigenvalue<N> make(Structure2D typical) {
            if (typical instanceof Access2D) {
                return this.make(typical, MatrixUtils.isHermitian((Access2D)typical));
            }
            return this.make(typical, false);
        }

        public Eigenvalue<N> make(Structure2D var1, boolean var2);
    }

    public static class Eigenpair
    implements Comparable<Eigenpair> {
        public final ComplexNumber value;
        public final Access1D<ComplexNumber> vector;

        public Eigenpair(ComplexNumber aValue, Access1D<ComplexNumber> aVector) {
            this.value = aValue;
            this.vector = aVector;
        }

        @Override
        public int compareTo(Eigenpair other) {
            return other.value.compareTo(this.value);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof Eigenpair)) {
                return false;
            }
            Eigenpair other = (Eigenpair)obj;
            if (this.value == null ? other.value != null : !this.value.equals(other.value)) {
                return false;
            }
            return !(this.vector == null ? other.vector != null : !this.vector.equals(other.vector));
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            result = 31 * result + (this.vector == null ? 0 : this.vector.hashCode());
            return result;
        }
    }
}

