/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store;

import org.ojalgo.ProgrammingError;
import org.ojalgo.matrix.store.ElementsConsumer;
import org.ojalgo.matrix.store.FactoryStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.scalar.Scalar;

final class SingleStore<N extends Number>
extends FactoryStore<N> {
    private final N myNumber;
    private final double myValue;

    private SingleStore(PhysicalStore.Factory<N, ?> factory, int rowsCount, int columnsCount) {
        super(factory, rowsCount, columnsCount);
        this.myNumber = null;
        this.myValue = 0.0;
        ProgrammingError.throwForIllegalInvocation();
    }

    SingleStore(PhysicalStore.Factory<N, ?> factory, Number element) {
        super(factory, 1, 1);
        this.myNumber = factory.scalar().cast(element);
        this.myValue = ((Number)this.myNumber).doubleValue();
    }

    @Override
    public MatrixStore<N> conjugate() {
        return new SingleStore(this.physical(), (Number)((Scalar)this.physical().scalar().convert((Number)this.myNumber).conjugate()).getNumber());
    }

    @Override
    public double doubleValue(long anInd) {
        return this.myValue;
    }

    @Override
    public double doubleValue(long aRow, long aCol) {
        return this.myValue;
    }

    @Override
    public N get(long aRow, long aCol) {
        return this.myNumber;
    }

    @Override
    public MatrixStore<N> multiply(MatrixStore<N> right) {
        PhysicalStore.Factory tmpFactory = this.physical();
        PhysicalStore retVal = (PhysicalStore)tmpFactory.copy(right);
        retVal.modifyAll(tmpFactory.function().multiply().first(this.myNumber));
        return retVal;
    }

    @Override
    public void supplyTo(ElementsConsumer<N> receiver) {
        this.addNonzerosTo(receiver);
    }

    @Override
    public Scalar<N> toScalar(long row, long column) {
        return this.physical().scalar().convert((Number)this.myNumber);
    }

    @Override
    public MatrixStore<N> transpose() {
        return this;
    }

    @Override
    protected void addNonzerosTo(ElementsConsumer<N> consumer) {
        consumer.fillOne(0L, 0L, this.myNumber);
    }
}

