/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.store.operation;

import java.math.BigDecimal;
import org.ojalgo.array.blas.AXPY;
import org.ojalgo.matrix.store.operation.MatrixOperation;
import org.ojalgo.scalar.ComplexNumber;

public final class ApplyLDU
extends MatrixOperation {
    public static final ApplyLDU SETUP = new ApplyLDU();
    public static int THRESHOLD = 256;

    public static void invoke(BigDecimal[] data, int structure, int firstColumn, int columnLimit, BigDecimal[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            BigDecimal tmpScalar = hermitian ? multipliers[j] : data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke(data, j * structure, 1, tmpScalar.negate(), multipliers, 0, 1, tmpFirstRow, structure);
        }
    }

    public static void invoke(ComplexNumber[] data, int structure, int firstColumn, int columnLimit, ComplexNumber[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            ComplexNumber tmpScalar = hermitian ? multipliers[j].conjugate() : data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke((Number[])data, (int)(j * structure), (int)1, (Number)tmpScalar.negate(), (Number[])multipliers, (int)0, (int)1, (int)tmpFirstRow, (int)structure);
        }
    }

    public static void invoke(double[] data, int structure, int firstColumn, int columnLimit, double[] multipliers, int iterationPoint, boolean hermitian) {
        for (int j = firstColumn; j < columnLimit; ++j) {
            double tmpScalar = hermitian ? multipliers[j] : data[iterationPoint + j * structure];
            int tmpFirstRow = hermitian ? j : iterationPoint + 1;
            AXPY.invoke(data, j * structure, 1, -tmpScalar, multipliers, 0, 1, tmpFirstRow, structure);
        }
    }

    private ApplyLDU() {
    }

    @Override
    public int threshold() {
        return THRESHOLD;
    }
}

