/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.random;

import org.ojalgo.constant.PrimitiveMath;
import org.ojalgo.function.PrimitiveFunction;
import org.ojalgo.random.AbstractContinuous;

public class Uniform
extends AbstractContinuous {
    private static final long serialVersionUID = -8198257914507986404L;
    private final double myLower;
    private final double myRange;

    public static int randomInteger(int limit) {
        return (int)PrimitiveFunction.FLOOR.invoke((double)limit * Math.random());
    }

    public static int randomInteger(int lower, int higher) {
        return lower + Uniform.randomInteger(higher - lower);
    }

    public static long randomInteger(long limit) {
        return (long)PrimitiveFunction.FLOOR.invoke((double)limit * Math.random());
    }

    public Uniform() {
        this(PrimitiveMath.ZERO, PrimitiveMath.ONE);
    }

    public Uniform(double lower, double range) {
        if (range <= PrimitiveMath.ZERO) {
            throw new IllegalArgumentException("The range must be larger than 0.0!");
        }
        this.myLower = lower;
        this.myRange = range;
    }

    @Override
    public double getDistribution(double value) {
        double retVal = PrimitiveMath.ZERO;
        if (value <= this.myLower + this.myRange && this.myLower <= value) {
            retVal = (value - this.myLower) / this.myRange;
        } else if (this.myLower <= value) {
            retVal = PrimitiveMath.ONE;
        }
        return retVal;
    }

    @Override
    public double getExpected() {
        return this.myLower + this.myRange / PrimitiveMath.TWO;
    }

    @Override
    public double getProbability(double value) {
        double retVal = PrimitiveMath.ZERO;
        if (this.myLower <= value && value <= this.myLower + this.myRange) {
            retVal = PrimitiveMath.ONE / this.myRange;
        }
        return retVal;
    }

    @Override
    public double getQuantile(double probality) {
        this.checkProbabilty(probality);
        return this.myLower + probality * this.myRange;
    }

    @Override
    public double getVariance() {
        return this.myRange * this.myRange / PrimitiveMath.TWELVE;
    }

    @Override
    protected double generate() {
        return this.myLower + this.myRange * this.random().nextDouble();
    }
}

