/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.s3a.adapter;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSSessionCredentials;
import com.amazonaws.auth.AnonymousAWSCredentials;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.s3a.CredentialInitializationException;
import org.apache.hadoop.fs.s3a.S3AUtils;
import org.apache.hadoop.fs.s3a.impl.InstantiationIOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsSessionCredentials;

public final class V1ToV2AwsCredentialProviderAdapter
implements AwsCredentialsProvider,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(V1ToV2AwsCredentialProviderAdapter.class);
    private final AWSCredentialsProvider v1CredentialsProvider;

    private V1ToV2AwsCredentialProviderAdapter(AWSCredentialsProvider v1CredentialsProvider) {
        this.v1CredentialsProvider = Objects.requireNonNull(v1CredentialsProvider);
    }

    public AwsCredentials resolveCredentials() {
        try {
            AWSCredentials toAdapt = this.v1CredentialsProvider.getCredentials();
            return V1ToV2AwsCredentialProviderAdapter.convertToV2Credentials(toAdapt);
        }
        catch (SdkClientException e) {
            throw new CredentialInitializationException(e.toString(), e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.v1CredentialsProvider instanceof Closeable) {
            ((Closeable)this.v1CredentialsProvider).close();
        } else if (this.v1CredentialsProvider instanceof AutoCloseable) {
            S3AUtils.closeAutocloseables(LOG, (AutoCloseable)this.v1CredentialsProvider);
        }
    }

    static AwsCredentials convertToV2Credentials(AWSCredentials toAdapt) {
        if (toAdapt instanceof AWSSessionCredentials) {
            return AwsSessionCredentials.create((String)toAdapt.getAWSAccessKeyId(), (String)toAdapt.getAWSSecretKey(), (String)((AWSSessionCredentials)toAdapt).getSessionToken());
        }
        if (toAdapt instanceof AnonymousAWSCredentials) {
            return AnonymousCredentialsProvider.create().resolveCredentials();
        }
        return AwsBasicCredentials.create((String)toAdapt.getAWSAccessKeyId(), (String)toAdapt.getAWSSecretKey());
    }

    public String toString() {
        return "V1ToV2AwsCredentialProviderAdapter{v1CredentialsProvider=" + this.v1CredentialsProvider + '}';
    }

    static AwsCredentialsProvider create(AWSCredentialsProvider v1CredentialsProvider) {
        return new V1ToV2AwsCredentialProviderAdapter(v1CredentialsProvider);
    }

    static AwsCredentialsProvider create(Configuration conf, String className, @Nullable URI uri) throws InstantiationIOException, IOException {
        AWSCredentialsProvider instance = S3AUtils.getInstanceFromReflection(className, conf, uri, AWSCredentialsProvider.class, "getInstance", "fs.s3a.aws.credentials.provider");
        return V1ToV2AwsCredentialProviderAdapter.create(instance);
    }
}

