/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity;

import com.microsoft.azure.cosmosdb.BridgeInternal;
import com.microsoft.azure.cosmosdb.DocumentClientException;
import com.microsoft.azure.cosmosdb.Error;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.HttpUtils;
import io.reactivex.netty.protocol.http.client.HttpResponseHeaders;
import java.net.URI;
import java.util.Map;

public class ServiceUnavailableException
extends DocumentClientException {
    public ServiceUnavailableException() {
        this("Service is currently unavailable, please retry after a while. If this problem persists please contact support.");
    }

    public ServiceUnavailableException(Error error, long lsn, String partitionKeyRangeId, Map<String, String> responseHeaders) {
        super(404, error, responseHeaders);
        BridgeInternal.setLSN((DocumentClientException)this, (long)lsn);
        BridgeInternal.setPartitionKeyRangeId((DocumentClientException)this, (String)partitionKeyRangeId);
    }

    public ServiceUnavailableException(String message) {
        this(message, null, (HttpResponseHeaders)null, null);
    }

    public ServiceUnavailableException(String message, HttpResponseHeaders headers, String requestUri) {
        this(message, null, headers, requestUri);
    }

    public ServiceUnavailableException(String message, HttpResponseHeaders headers, URI requestUri) {
        this(message, headers, requestUri != null ? requestUri.toString() : null);
    }

    public ServiceUnavailableException(Exception innerException) {
        this("Service is currently unavailable, please retry after a while. If this problem persists please contact support.", innerException, null, null);
    }

    public ServiceUnavailableException(String message, Exception innerException, HttpResponseHeaders headers, String requestUri) {
        super(String.format("%s: %s", "Service is currently unavailable, please retry after a while. If this problem persists please contact support.", message), innerException, HttpUtils.asMap((HttpResponseHeaders)headers), 503, requestUri != null ? requestUri.toString() : null);
    }
}

