/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.microsoft.azure.cosmosdb.ConsistencyLevel;
import com.microsoft.azure.cosmosdb.IndexingDirective;
import com.microsoft.azure.cosmosdb.internal.ContentSerializationFormat;
import com.microsoft.azure.cosmosdb.internal.EnumerationDirection;
import com.microsoft.azure.cosmosdb.internal.FanoutOperationState;
import com.microsoft.azure.cosmosdb.internal.MigrateCollectionDirective;
import com.microsoft.azure.cosmosdb.internal.ReadFeedKeyType;
import com.microsoft.azure.cosmosdb.internal.RemoteStorageType;
import com.microsoft.azure.cosmosdb.internal.ResourceId;
import com.microsoft.azure.cosmosdb.internal.ResourceType;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdConstants;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestArgs;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdRequestFrame;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdToken;
import com.microsoft.azure.cosmosdb.internal.directconnectivity.rntbd.RntbdTokenStream;
import com.microsoft.azure.cosmosdb.rx.internal.RxDocumentServiceRequest;
import io.netty.buffer.ByteBuf;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.lang3.EnumUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.validator.routines.DoubleValidator;
import org.apache.commons.validator.routines.LongValidator;

@JsonFilter(value="RntbdToken")
final class RntbdRequestHeaders
extends RntbdTokenStream<RntbdConstants.RntbdRequestHeader> {
    private static final String UrlTrim = "/+";
    private static final DoubleValidator doubleValidator = DoubleValidator.getInstance();
    private static final LongValidator longValidator = LongValidator.getInstance();

    RntbdRequestHeaders(RntbdRequestArgs args, RntbdRequestFrame frame) {
        this();
        Objects.requireNonNull(args, "args");
        Objects.requireNonNull(frame, "frame");
        RxDocumentServiceRequest request = args.getServiceRequest();
        byte[] content = request.getContent();
        this.getPayloadPresent().setValue(content != null && content.length > 0);
        this.getReplicaPath().setValue(args.getReplicaPath());
        Map headers = request.getHeaders();
        this.addAimHeader(headers);
        this.addAllowScanOnQuery(headers);
        this.addBinaryIdIfPresent(headers);
        this.addCanCharge(headers);
        this.addCanOfferReplaceComplete(headers);
        this.addCanThrottle(headers);
        this.addCollectionRemoteStorageSecurityIdentifier(headers);
        this.addConsistencyLevelHeader(headers);
        this.addContentSerializationFormat(headers);
        this.addContinuationToken(request);
        this.addDateHeader(headers);
        this.addDisableRUPerMinuteUsage(headers);
        this.addEmitVerboseTracesInQuery(headers);
        this.addEnableLogging(headers);
        this.addEnableLowPrecisionOrderBy(headers);
        this.addEntityId(headers);
        this.addEnumerationDirection(headers);
        this.addExcludeSystemProperties(headers);
        this.addFanoutOperationStateHeader(headers);
        this.addIfModifiedSinceHeader(headers);
        this.addIndexingDirectiveHeader(headers);
        this.addIsAutoScaleRequest(headers);
        this.addIsFanout(headers);
        this.addIsReadOnlyScript(headers);
        this.addIsUserRequest(headers);
        this.addMatchHeader(headers, frame.getOperationType());
        this.addMigrateCollectionDirectiveHeader(headers);
        this.addPageSize(headers);
        this.addPopulateCollectionThroughputInfo(headers);
        this.addPopulatePartitionStatistics(headers);
        this.addPopulateQueryMetrics(headers);
        this.addPopulateQuotaInfo(headers);
        this.addProfileRequest(headers);
        this.addQueryForceScan(headers);
        this.addRemoteStorageType(headers);
        this.addResourceIdOrPathHeaders(request);
        this.addResponseContinuationTokenLimitInKb(headers);
        this.addShareThroughput(headers);
        this.addStartAndEndKeys(headers);
        this.addSupportSpatialLegacyCoordinates(headers);
        this.addUsePolygonsSmallerThanAHemisphere(headers);
        this.fillTokenFromHeader(headers, this::getAllowTentativeWrites, "x-ms-cosmos-allow-tentative-writes");
        this.fillTokenFromHeader(headers, this::getAuthorizationToken, "authorization");
        this.fillTokenFromHeader(headers, this::getBinaryPassThroughRequest, "x-ms-binary-passthrough-request");
        this.fillTokenFromHeader(headers, this::getBindReplicaDirective, "x-ms-bind-replica");
        this.fillTokenFromHeader(headers, this::getClientRetryAttemptCount, "x-ms-client-retry-attempt-count");
        this.fillTokenFromHeader(headers, this::getCollectionPartitionIndex, "collection-partition-index");
        this.fillTokenFromHeader(headers, this::getCollectionRid, "x-ms-documentdb-collection-rid");
        this.fillTokenFromHeader(headers, this::getCollectionServiceIndex, "collection-service-index");
        this.fillTokenFromHeader(headers, this::getEffectivePartitionKey, "x-ms-effective-partition-key");
        this.fillTokenFromHeader(headers, this::getEnableDynamicRidRangeAllocation, "x-ms-enable-dynamic-rid-range-allocation");
        this.fillTokenFromHeader(headers, this::getFilterBySchemaRid, "x-ms-documentdb-filterby-schema-rid");
        this.fillTokenFromHeader(headers, this::getGatewaySignature, "x-ms-gateway-signature");
        this.fillTokenFromHeader(headers, this::getPartitionCount, "x-ms-documentdb-partitioncount");
        this.fillTokenFromHeader(headers, this::getPartitionKey, "x-ms-documentdb-partitionkey");
        this.fillTokenFromHeader(headers, this::getPartitionKeyRangeId, "x-ms-documentdb-partitionkeyrangeid");
        this.fillTokenFromHeader(headers, this::getPartitionResourceFilter, "x-ms-partition-resource-filter");
        this.fillTokenFromHeader(headers, this::getPostTriggerExclude, "x-ms-documentdb-post-trigger-exclude");
        this.fillTokenFromHeader(headers, this::getPostTriggerInclude, "x-ms-documentdb-post-trigger-include");
        this.fillTokenFromHeader(headers, this::getPreTriggerExclude, "x-ms-documentdb-pre-trigger-exclude");
        this.fillTokenFromHeader(headers, this::getPreTriggerInclude, "x-ms-documentdb-pre-trigger-include");
        this.fillTokenFromHeader(headers, this::getPrimaryMasterKey, "x-ms-primary-master-key");
        this.fillTokenFromHeader(headers, this::getPrimaryReadonlyKey, "x-ms-primary-readonly-key");
        this.fillTokenFromHeader(headers, this::getRemainingTimeInMsOnClientRequest, "x-ms-remaining-time-in-ms-on-client");
        this.fillTokenFromHeader(headers, this::getResourceSchemaName, "x-ms-resource-schema-name");
        this.fillTokenFromHeader(headers, this::getResourceTokenExpiry, "x-ms-documentdb-expiry-seconds");
        this.fillTokenFromHeader(headers, this::getRestoreMetadataFilter, "x-ms-restore-metadata-filter");
        this.fillTokenFromHeader(headers, this::getRestoreParams, "x-ms-restore-params");
        this.fillTokenFromHeader(headers, this::getSecondaryMasterKey, "x-ms-secondary-master-key");
        this.fillTokenFromHeader(headers, this::getSecondaryReadonlyKey, "x-ms-secondary-readonly-key");
        this.fillTokenFromHeader(headers, this::getSessionToken, "x-ms-session-token");
        this.fillTokenFromHeader(headers, this::getSharedOfferThroughput, "x-ms-cosmos-shared-offer-throughput");
        this.fillTokenFromHeader(headers, this::getTargetGlobalCommittedLsn, "x-ms-target-global-committed-lsn");
        this.fillTokenFromHeader(headers, this::getTargetLsn, "x-ms-target-lsn");
        this.fillTokenFromHeader(headers, this::getTimeToLiveInSeconds, "x-ms-time-to-live-in-seconds");
        this.fillTokenFromHeader(headers, this::getTransportRequestID, "x-ms-transport-request-id");
        this.fillTokenFromHeader(headers, this::getClientVersion, "x-ms-version");
    }

    private RntbdRequestHeaders() {
        super(RntbdConstants.RntbdRequestHeader.set, RntbdConstants.RntbdRequestHeader.map);
    }

    static RntbdRequestHeaders decode(ByteBuf in) {
        RntbdRequestHeaders metadata = new RntbdRequestHeaders();
        return RntbdRequestHeaders.decode(in, metadata);
    }

    private RntbdToken getAIM() {
        return this.get(RntbdConstants.RntbdRequestHeader.A_IM);
    }

    private RntbdToken getAllowTentativeWrites() {
        return this.get(RntbdConstants.RntbdRequestHeader.AllowTentativeWrites);
    }

    private RntbdToken getAttachmentName() {
        return this.get(RntbdConstants.RntbdRequestHeader.AttachmentName);
    }

    private RntbdToken getAuthorizationToken() {
        return this.get(RntbdConstants.RntbdRequestHeader.AuthorizationToken);
    }

    private RntbdToken getBinaryId() {
        return this.get(RntbdConstants.RntbdRequestHeader.BinaryId);
    }

    private RntbdToken getBinaryPassThroughRequest() {
        return this.get(RntbdConstants.RntbdRequestHeader.BinaryPassthroughRequest);
    }

    private RntbdToken getBindReplicaDirective() {
        return this.get(RntbdConstants.RntbdRequestHeader.BindReplicaDirective);
    }

    private RntbdToken getCanCharge() {
        return this.get(RntbdConstants.RntbdRequestHeader.CanCharge);
    }

    private RntbdToken getCanOfferReplaceComplete() {
        return this.get(RntbdConstants.RntbdRequestHeader.CanOfferReplaceComplete);
    }

    private RntbdToken getCanThrottle() {
        return this.get(RntbdConstants.RntbdRequestHeader.CanThrottle);
    }

    private RntbdToken getClientRetryAttemptCount() {
        return this.get(RntbdConstants.RntbdRequestHeader.ClientRetryAttemptCount);
    }

    private RntbdToken getClientVersion() {
        return this.get(RntbdConstants.RntbdRequestHeader.ClientVersion);
    }

    private RntbdToken getCollectionName() {
        return this.get(RntbdConstants.RntbdRequestHeader.CollectionName);
    }

    private RntbdToken getCollectionPartitionIndex() {
        return this.get(RntbdConstants.RntbdRequestHeader.CollectionPartitionIndex);
    }

    private RntbdToken getCollectionRemoteStorageSecurityIdentifier() {
        return this.get(RntbdConstants.RntbdRequestHeader.CollectionRemoteStorageSecurityIdentifier);
    }

    private RntbdToken getCollectionRid() {
        return this.get(RntbdConstants.RntbdRequestHeader.CollectionRid);
    }

    private RntbdToken getCollectionServiceIndex() {
        return this.get(RntbdConstants.RntbdRequestHeader.CollectionServiceIndex);
    }

    private RntbdToken getConflictName() {
        return this.get(RntbdConstants.RntbdRequestHeader.ConflictName);
    }

    private RntbdToken getConsistencyLevel() {
        return this.get(RntbdConstants.RntbdRequestHeader.ConsistencyLevel);
    }

    private RntbdToken getContentSerializationFormat() {
        return this.get(RntbdConstants.RntbdRequestHeader.ContentSerializationFormat);
    }

    private RntbdToken getContinuationToken() {
        return this.get(RntbdConstants.RntbdRequestHeader.ContinuationToken);
    }

    private RntbdToken getDatabaseName() {
        return this.get(RntbdConstants.RntbdRequestHeader.DatabaseName);
    }

    private RntbdToken getDate() {
        return this.get(RntbdConstants.RntbdRequestHeader.Date);
    }

    private RntbdToken getDisableRUPerMinuteUsage() {
        return this.get(RntbdConstants.RntbdRequestHeader.DisableRUPerMinuteUsage);
    }

    private RntbdToken getDocumentName() {
        return this.get(RntbdConstants.RntbdRequestHeader.DocumentName);
    }

    private RntbdToken getEffectivePartitionKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.EffectivePartitionKey);
    }

    private RntbdToken getEmitVerboseTracesInQuery() {
        return this.get(RntbdConstants.RntbdRequestHeader.EmitVerboseTracesInQuery);
    }

    private RntbdToken getEnableDynamicRidRangeAllocation() {
        return this.get(RntbdConstants.RntbdRequestHeader.EnableDynamicRidRangeAllocation);
    }

    private RntbdToken getEnableLogging() {
        return this.get(RntbdConstants.RntbdRequestHeader.EnableLogging);
    }

    private RntbdToken getEnableLowPrecisionOrderBy() {
        return this.get(RntbdConstants.RntbdRequestHeader.EnableLowPrecisionOrderBy);
    }

    private RntbdToken getEnableScanInQuery() {
        return this.get(RntbdConstants.RntbdRequestHeader.EnableScanInQuery);
    }

    private RntbdToken getEndEpk() {
        return this.get(RntbdConstants.RntbdRequestHeader.EndEpk);
    }

    private RntbdToken getEndId() {
        return this.get(RntbdConstants.RntbdRequestHeader.EndId);
    }

    private RntbdToken getEntityId() {
        return this.get(RntbdConstants.RntbdRequestHeader.EntityId);
    }

    private RntbdToken getEnumerationDirection() {
        return this.get(RntbdConstants.RntbdRequestHeader.EnumerationDirection);
    }

    private RntbdToken getExcludeSystemProperties() {
        return this.get(RntbdConstants.RntbdRequestHeader.ExcludeSystemProperties);
    }

    private RntbdToken getFanoutOperationState() {
        return this.get(RntbdConstants.RntbdRequestHeader.FanoutOperationState);
    }

    private RntbdToken getFilterBySchemaRid() {
        return this.get(RntbdConstants.RntbdRequestHeader.FilterBySchemaRid);
    }

    private RntbdToken getForceQueryScan() {
        return this.get(RntbdConstants.RntbdRequestHeader.ForceQueryScan);
    }

    private RntbdToken getGatewaySignature() {
        return this.get(RntbdConstants.RntbdRequestHeader.GatewaySignature);
    }

    private RntbdToken getIfModifiedSince() {
        return this.get(RntbdConstants.RntbdRequestHeader.IfModifiedSince);
    }

    private RntbdToken getIndexingDirective() {
        return this.get(RntbdConstants.RntbdRequestHeader.IndexingDirective);
    }

    private RntbdToken getIsAutoScaleRequest() {
        return this.get(RntbdConstants.RntbdRequestHeader.IsAutoScaleRequest);
    }

    private RntbdToken getIsFanout() {
        return this.get(RntbdConstants.RntbdRequestHeader.IsFanout);
    }

    private RntbdToken getIsReadOnlyScript() {
        return this.get(RntbdConstants.RntbdRequestHeader.IsReadOnlyScript);
    }

    private RntbdToken getIsUserRequest() {
        return this.get(RntbdConstants.RntbdRequestHeader.IsUserRequest);
    }

    private RntbdToken getMatch() {
        return this.get(RntbdConstants.RntbdRequestHeader.Match);
    }

    private RntbdToken getMigrateCollectionDirective() {
        return this.get(RntbdConstants.RntbdRequestHeader.MigrateCollectionDirective);
    }

    private RntbdToken getPageSize() {
        return this.get(RntbdConstants.RntbdRequestHeader.PageSize);
    }

    private RntbdToken getPartitionCount() {
        return this.get(RntbdConstants.RntbdRequestHeader.PartitionCount);
    }

    private RntbdToken getPartitionKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.PartitionKey);
    }

    private RntbdToken getPartitionKeyRangeId() {
        return this.get(RntbdConstants.RntbdRequestHeader.PartitionKeyRangeId);
    }

    private RntbdToken getPartitionKeyRangeName() {
        return this.get(RntbdConstants.RntbdRequestHeader.PartitionKeyRangeName);
    }

    private RntbdToken getPartitionResourceFilter() {
        return this.get(RntbdConstants.RntbdRequestHeader.PartitionResourceFilter);
    }

    private RntbdToken getPayloadPresent() {
        return this.get(RntbdConstants.RntbdRequestHeader.PayloadPresent);
    }

    private RntbdToken getPermissionName() {
        return this.get(RntbdConstants.RntbdRequestHeader.PermissionName);
    }

    private RntbdToken getPopulateCollectionThroughputInfo() {
        return this.get(RntbdConstants.RntbdRequestHeader.PopulateCollectionThroughputInfo);
    }

    private RntbdToken getPopulatePartitionStatistics() {
        return this.get(RntbdConstants.RntbdRequestHeader.PopulatePartitionStatistics);
    }

    private RntbdToken getPopulateQueryMetrics() {
        return this.get(RntbdConstants.RntbdRequestHeader.PopulateQueryMetrics);
    }

    private RntbdToken getPopulateQuotaInfo() {
        return this.get(RntbdConstants.RntbdRequestHeader.PopulateQuotaInfo);
    }

    private RntbdToken getPostTriggerExclude() {
        return this.get(RntbdConstants.RntbdRequestHeader.PostTriggerExclude);
    }

    private RntbdToken getPostTriggerInclude() {
        return this.get(RntbdConstants.RntbdRequestHeader.PostTriggerInclude);
    }

    private RntbdToken getPreTriggerExclude() {
        return this.get(RntbdConstants.RntbdRequestHeader.PreTriggerExclude);
    }

    private RntbdToken getPreTriggerInclude() {
        return this.get(RntbdConstants.RntbdRequestHeader.PreTriggerInclude);
    }

    private RntbdToken getPrimaryMasterKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.PrimaryMasterKey);
    }

    private RntbdToken getPrimaryReadonlyKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.PrimaryReadonlyKey);
    }

    private RntbdToken getProfileRequest() {
        return this.get(RntbdConstants.RntbdRequestHeader.ProfileRequest);
    }

    private RntbdToken getReadFeedKeyType() {
        return this.get(RntbdConstants.RntbdRequestHeader.ReadFeedKeyType);
    }

    private RntbdToken getRemainingTimeInMsOnClientRequest() {
        return this.get(RntbdConstants.RntbdRequestHeader.RemainingTimeInMsOnClientRequest);
    }

    private RntbdToken getRemoteStorageType() {
        return this.get(RntbdConstants.RntbdRequestHeader.RemoteStorageType);
    }

    private RntbdToken getReplicaPath() {
        return this.get(RntbdConstants.RntbdRequestHeader.ReplicaPath);
    }

    private RntbdToken getResourceId() {
        return this.get(RntbdConstants.RntbdRequestHeader.ResourceId);
    }

    private RntbdToken getResourceSchemaName() {
        return this.get(RntbdConstants.RntbdRequestHeader.ResourceSchemaName);
    }

    private RntbdToken getResourceTokenExpiry() {
        return this.get(RntbdConstants.RntbdRequestHeader.ResourceTokenExpiry);
    }

    private RntbdToken getResponseContinuationTokenLimitInKb() {
        return this.get(RntbdConstants.RntbdRequestHeader.ResponseContinuationTokenLimitInKb);
    }

    private RntbdToken getRestoreMetadataFilter() {
        return this.get(RntbdConstants.RntbdRequestHeader.RestoreMetadaFilter);
    }

    private RntbdToken getRestoreParams() {
        return this.get(RntbdConstants.RntbdRequestHeader.RestoreParams);
    }

    private RntbdToken getSchemaName() {
        return this.get(RntbdConstants.RntbdRequestHeader.SchemaName);
    }

    private RntbdToken getSecondaryMasterKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.SecondaryMasterKey);
    }

    private RntbdToken getSecondaryReadonlyKey() {
        return this.get(RntbdConstants.RntbdRequestHeader.SecondaryReadonlyKey);
    }

    private RntbdToken getSessionToken() {
        return this.get(RntbdConstants.RntbdRequestHeader.SessionToken);
    }

    private RntbdToken getShareThroughput() {
        return this.get(RntbdConstants.RntbdRequestHeader.ShareThroughput);
    }

    private RntbdToken getSharedOfferThroughput() {
        return this.get(RntbdConstants.RntbdRequestHeader.SharedOfferThroughput);
    }

    private RntbdToken getStartEpk() {
        return this.get(RntbdConstants.RntbdRequestHeader.StartEpk);
    }

    private RntbdToken getStartId() {
        return this.get(RntbdConstants.RntbdRequestHeader.StartId);
    }

    private RntbdToken getStoredProcedureName() {
        return this.get(RntbdConstants.RntbdRequestHeader.StoredProcedureName);
    }

    private RntbdToken getSupportSpatialLegacyCoordinates() {
        return this.get(RntbdConstants.RntbdRequestHeader.SupportSpatialLegacyCoordinates);
    }

    private RntbdToken getTargetGlobalCommittedLsn() {
        return this.get(RntbdConstants.RntbdRequestHeader.TargetGlobalCommittedLsn);
    }

    private RntbdToken getTargetLsn() {
        return this.get(RntbdConstants.RntbdRequestHeader.TargetLsn);
    }

    private RntbdToken getTimeToLiveInSeconds() {
        return this.get(RntbdConstants.RntbdRequestHeader.TimeToLiveInSeconds);
    }

    private RntbdToken getTransportRequestID() {
        return this.get(RntbdConstants.RntbdRequestHeader.TransportRequestID);
    }

    private RntbdToken getTriggerName() {
        return this.get(RntbdConstants.RntbdRequestHeader.TriggerName);
    }

    private RntbdToken getUsePolygonsSmallerThanAHemisphere() {
        return this.get(RntbdConstants.RntbdRequestHeader.UsePolygonsSmallerThanAHemisphere);
    }

    private RntbdToken getUserDefinedFunctionName() {
        return this.get(RntbdConstants.RntbdRequestHeader.UserDefinedFunctionName);
    }

    private RntbdToken getUserDefinedTypeName() {
        return this.get(RntbdConstants.RntbdRequestHeader.UserDefinedTypeName);
    }

    private RntbdToken getUserName() {
        return this.get(RntbdConstants.RntbdRequestHeader.UserName);
    }

    private void addAimHeader(Map<String, String> headers) {
        String value = headers.get("A-IM");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getAIM().setValue(value);
        }
    }

    private void addAllowScanOnQuery(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-query-enable-scan");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getEnableScanInQuery().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addBinaryIdIfPresent(Map<String, String> headers) {
        String value = headers.get("x-ms-binary-id");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getBinaryId().setValue(Base64.getDecoder().decode(value));
        }
    }

    private void addCanCharge(Map<String, String> headers) {
        String value = headers.get("x-ms-cancharge");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getCanCharge().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addCanOfferReplaceComplete(Map<String, String> headers) {
        String value = headers.get("x-ms-can-offer-replace-complete");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getCanOfferReplaceComplete().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addCanThrottle(Map<String, String> headers) {
        String value = headers.get("x-ms-canthrottle");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getCanThrottle().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addCollectionRemoteStorageSecurityIdentifier(Map<String, String> headers) {
        String value = headers.get("x-ms-collection-security-identifier");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getCollectionRemoteStorageSecurityIdentifier().setValue(value);
        }
    }

    private void addConsistencyLevelHeader(Map<String, String> headers) {
        String value = headers.get("x-ms-consistency-level");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ConsistencyLevel level = (ConsistencyLevel)EnumUtils.getEnumIgnoreCase(ConsistencyLevel.class, (String)value);
            if (level == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-consistency-level", value);
                throw new IllegalStateException(reason);
            }
            switch (level) {
                case Strong: {
                    this.getConsistencyLevel().setValue(RntbdConstants.RntbdConsistencyLevel.Strong.id());
                    break;
                }
                case BoundedStaleness: {
                    this.getConsistencyLevel().setValue(RntbdConstants.RntbdConsistencyLevel.BoundedStaleness.id());
                    break;
                }
                case Session: {
                    this.getConsistencyLevel().setValue(RntbdConstants.RntbdConsistencyLevel.Session.id());
                    break;
                }
                case Eventual: {
                    this.getConsistencyLevel().setValue(RntbdConstants.RntbdConsistencyLevel.Eventual.id());
                    break;
                }
                case ConsistentPrefix: {
                    this.getConsistencyLevel().setValue(RntbdConstants.RntbdConsistencyLevel.ConsistentPrefix.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addContentSerializationFormat(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-content-serialization-format");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ContentSerializationFormat format = (ContentSerializationFormat)EnumUtils.getEnumIgnoreCase(ContentSerializationFormat.class, (String)value);
            if (format == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-documentdb-content-serialization-format", value);
                throw new IllegalStateException(reason);
            }
            switch (format) {
                case JsonText: {
                    this.getContentSerializationFormat().setValue(RntbdConstants.RntbdContentSerializationFormat.JsonText.id());
                    break;
                }
                case CosmosBinary: {
                    this.getContentSerializationFormat().setValue(RntbdConstants.RntbdContentSerializationFormat.CosmosBinary.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addContinuationToken(RxDocumentServiceRequest request) {
        String value = request.getContinuation();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getContinuationToken().setValue(value);
        }
    }

    private void addDateHeader(Map<String, String> headers) {
        String value = headers.get("x-ms-date");
        if (StringUtils.isEmpty((CharSequence)value)) {
            value = headers.get("date");
        }
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getDate().setValue(value);
        }
    }

    private void addDisableRUPerMinuteUsage(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-disable-ru-per-minute-usage");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getDisableRUPerMinuteUsage().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addEmitVerboseTracesInQuery(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-query-emit-traces");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getEmitVerboseTracesInQuery().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addEnableLogging(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-script-enable-logging");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getEnableLogging().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addEnableLowPrecisionOrderBy(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-query-enable-low-precision-order-by");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getEnableLowPrecisionOrderBy().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addEntityId(Map<String, String> headers) {
        String value = headers.get("x-docdb-entity-id");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getEntityId().setValue(value);
        }
    }

    private void addEnumerationDirection(Map<String, String> headers) {
        String value = headers.get("x-ms-enumeration-direction");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            EnumerationDirection direction = (EnumerationDirection)EnumUtils.getEnumIgnoreCase(EnumerationDirection.class, (String)value);
            if (direction == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-enumeration-direction", value);
                throw new IllegalStateException(reason);
            }
            switch (direction) {
                case Forward: {
                    this.getEnumerationDirection().setValue(RntbdConstants.RntbdEnumerationDirection.Forward.id());
                    break;
                }
                case Reverse: {
                    this.getEnumerationDirection().setValue(RntbdConstants.RntbdEnumerationDirection.Reverse.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addExcludeSystemProperties(Map<String, String> headers) {
        String value = headers.get("x-ms-exclude-system-properties");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getExcludeSystemProperties().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addFanoutOperationStateHeader(Map<String, String> headers) {
        String value = headers.get("x-ms-fanout-operation-state");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            FanoutOperationState format = (FanoutOperationState)EnumUtils.getEnumIgnoreCase(FanoutOperationState.class, (String)value);
            if (format == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-fanout-operation-state", value);
                throw new IllegalStateException(reason);
            }
            switch (format) {
                case Started: {
                    this.getFanoutOperationState().setValue(RntbdConstants.RntbdFanoutOperationState.Started.id());
                    break;
                }
                case Completed: {
                    this.getFanoutOperationState().setValue(RntbdConstants.RntbdFanoutOperationState.Completed.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addIfModifiedSinceHeader(Map<String, String> headers) {
        String value = headers.get("If-Modified-Since");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getIfModifiedSince().setValue(value);
        }
    }

    private void addIndexingDirectiveHeader(Map<String, String> headers) {
        String value = headers.get("x-ms-indexing-directive");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            IndexingDirective directive = (IndexingDirective)EnumUtils.getEnumIgnoreCase(IndexingDirective.class, (String)value);
            if (directive == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-indexing-directive", value);
                throw new IllegalStateException(reason);
            }
            switch (directive) {
                case Default: {
                    this.getIndexingDirective().setValue(RntbdConstants.RntbdIndexingDirective.Default.id());
                    break;
                }
                case Exclude: {
                    this.getIndexingDirective().setValue(RntbdConstants.RntbdIndexingDirective.Exclude.id());
                    break;
                }
                case Include: {
                    this.getIndexingDirective().setValue(RntbdConstants.RntbdIndexingDirective.Include.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addIsAutoScaleRequest(Map<String, String> headers) {
        String value = headers.get("x-ms-is-auto-scale");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getIsAutoScaleRequest().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addIsFanout(Map<String, String> headers) {
        String value = headers.get("x-ms-is-fanout-request");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getIsFanout().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addIsReadOnlyScript(Map<String, String> headers) {
        String value = headers.get("x-ms-is-readonly-script");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getIsReadOnlyScript().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addIsUserRequest(Map<String, String> headers) {
        String value = headers.get("x-ms-cosmos-internal-is-user-request");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getIsUserRequest().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addMatchHeader(Map<String, String> headers, RntbdConstants.RntbdOperationType operationType) {
        String match = null;
        switch (operationType) {
            case Read: 
            case ReadFeed: {
                match = headers.get("If-None-Match");
                break;
            }
            default: {
                match = headers.get("If-Match");
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)match)) {
            this.getMatch().setValue(match);
        }
    }

    private void addMigrateCollectionDirectiveHeader(Map<String, String> headers) {
        String value = headers.get("x-ms-migratecollection-directive");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            MigrateCollectionDirective directive = (MigrateCollectionDirective)EnumUtils.getEnumIgnoreCase(MigrateCollectionDirective.class, (String)value);
            if (directive == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-migratecollection-directive", value);
                throw new IllegalStateException(reason);
            }
            switch (directive) {
                case Freeze: {
                    this.getMigrateCollectionDirective().setValue(RntbdConstants.RntbdMigrateCollectionDirective.Freeze.id());
                    break;
                }
                case Thaw: {
                    this.getMigrateCollectionDirective().setValue(RntbdConstants.RntbdMigrateCollectionDirective.Thaw.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addPageSize(Map<String, String> headers) {
        String value = headers.get("x-ms-max-item-count");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            Long pageSize = longValidator.validate(value, Locale.ROOT);
            if (pageSize == null || !longValidator.isInRange(pageSize, -1L, 0xFFFFFFFFL)) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-max-item-count", value);
                throw new IllegalStateException(reason);
            }
            this.getPageSize().setValue((int)(pageSize < 0L ? 0xFFFFFFFFL : pageSize));
        }
    }

    private void addPopulateCollectionThroughputInfo(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-populatecollectionthroughputinfo");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getPopulateCollectionThroughputInfo().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addPopulatePartitionStatistics(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-populatepartitionstatistics");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getPopulatePartitionStatistics().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addPopulateQueryMetrics(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-populatequerymetrics");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getPopulateQueryMetrics().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addPopulateQuotaInfo(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-populatequotainfo");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getPopulateQuotaInfo().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addProfileRequest(Map<String, String> headers) {
        String value = headers.get("x-ms-profile-request");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getProfileRequest().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addQueryForceScan(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-force-query-scan");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getForceQueryScan().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addRemoteStorageType(Map<String, String> headers) {
        String value = headers.get("x-ms-remote-storage-type");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            RemoteStorageType type = (RemoteStorageType)EnumUtils.getEnumIgnoreCase(RemoteStorageType.class, (String)value);
            if (type == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-remote-storage-type", value);
                throw new IllegalStateException(reason);
            }
            switch (type) {
                case Standard: {
                    this.getRemoteStorageType().setValue(RntbdConstants.RntbdRemoteStorageType.Standard.id());
                    break;
                }
                case Premium: {
                    this.getRemoteStorageType().setValue(RntbdConstants.RntbdRemoteStorageType.Premium.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
    }

    private void addResourceIdOrPathHeaders(RxDocumentServiceRequest request) {
        String value = request.getResourceId();
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getResourceId().setValue(ResourceId.parse((ResourceType)request.getResourceType(), (String)value));
        }
        if (request.getIsNameBased()) {
            String address = request.getResourceAddress();
            String[] fragments = address.split(UrlTrim);
            int count = fragments.length;
            int index = 0;
            if (count > 0 && fragments[0].isEmpty()) {
                ++index;
                --count;
            }
            if (count >= 2) {
                switch (fragments[index]) {
                    case "dbs": {
                        this.getDatabaseName().setValue(fragments[index + 1]);
                        break;
                    }
                    default: {
                        String reason = String.format(Locale.ROOT, "Invalid address for resource %s: %s", value, address);
                        throw new IllegalStateException(reason);
                    }
                }
            }
            if (count >= 4) {
                switch (fragments[index + 2]) {
                    case "colls": {
                        this.getCollectionName().setValue(fragments[index + 3]);
                        break;
                    }
                    case "users": {
                        this.getUserName().setValue(fragments[index + 3]);
                        break;
                    }
                    case "udts": {
                        this.getUserDefinedTypeName().setValue(fragments[index + 3]);
                    }
                }
            }
            if (count >= 6) {
                switch (fragments[index + 4]) {
                    case "docs": {
                        this.getDocumentName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "sprocs": {
                        this.getStoredProcedureName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "permissions": {
                        this.getPermissionName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "udfs": {
                        this.getUserDefinedFunctionName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "triggers": {
                        this.getTriggerName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "conflicts": {
                        this.getConflictName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "pkranges": {
                        this.getPartitionKeyRangeName().setValue(fragments[index + 5]);
                        break;
                    }
                    case "schemas": {
                        this.getSchemaName().setValue(fragments[index + 5]);
                    }
                }
            }
            if (count >= 8) {
                switch (fragments[index + 6]) {
                    case "attachments": {
                        this.getAttachmentName().setValue(fragments[index + 7]);
                    }
                }
            }
        }
    }

    private void addResponseContinuationTokenLimitInKb(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-responsecontinuationtokenlimitinkb");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            Long tokenLimit = longValidator.validate(value, Locale.ROOT);
            if (tokenLimit == null || !longValidator.isInRange(tokenLimit, 0L, 0xFFFFFFFFL)) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-documentdb-responsecontinuationtokenlimitinkb", value);
                throw new IllegalStateException(reason);
            }
            this.getResponseContinuationTokenLimitInKb().setValue((int)(tokenLimit < 0L ? 0xFFFFFFFFL : tokenLimit));
        }
    }

    private void addShareThroughput(Map<String, String> headers) {
        String value = headers.get("x-ms-share-throughput");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getShareThroughput().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addStartAndEndKeys(Map<String, String> headers) {
        String value = headers.get("x-ms-read-key-type");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            ReadFeedKeyType type = (ReadFeedKeyType)EnumUtils.getEnumIgnoreCase(ReadFeedKeyType.class, (String)value);
            if (type == null) {
                String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", "x-ms-read-key-type", value);
                throw new IllegalStateException(reason);
            }
            switch (type) {
                case ResourceId: {
                    this.getReadFeedKeyType().setValue(RntbdConstants.RntbdReadFeedKeyType.ResourceId.id());
                    break;
                }
                case EffectivePartitionKey: {
                    this.getReadFeedKeyType().setValue(RntbdConstants.RntbdReadFeedKeyType.EffectivePartitionKey.id());
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        Base64.Decoder decoder = Base64.getDecoder();
        value = headers.get("x-ms-start-id");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getStartId().setValue(decoder.decode(value));
        }
        if (StringUtils.isNotEmpty((CharSequence)(value = headers.get("x-ms-end-id")))) {
            this.getEndId().setValue(decoder.decode(value));
        }
        if (StringUtils.isNotEmpty((CharSequence)(value = headers.get("x-ms-start-epk")))) {
            this.getStartEpk().setValue(decoder.decode(value));
        }
        if (StringUtils.isNotEmpty((CharSequence)(value = headers.get("x-ms-end-epk")))) {
            this.getEndEpk().setValue(decoder.decode(value));
        }
    }

    private void addSupportSpatialLegacyCoordinates(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-supportspatiallegacycoordinates");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getSupportSpatialLegacyCoordinates().setValue(Boolean.parseBoolean(value));
        }
    }

    private void addUsePolygonsSmallerThanAHemisphere(Map<String, String> headers) {
        String value = headers.get("x-ms-documentdb-usepolygonssmallerthanahemisphere");
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            this.getUsePolygonsSmallerThanAHemisphere().setValue(Boolean.parseBoolean(value));
        }
    }

    private void fillTokenFromHeader(Map<String, String> headers, Supplier<RntbdToken> supplier, String name) {
        String value = headers.get(name);
        if (StringUtils.isNotEmpty((CharSequence)value)) {
            RntbdToken token = supplier.get();
            switch (token.getType()) {
                case SmallString: 
                case String: 
                case ULongString: {
                    token.setValue(value);
                    break;
                }
                case Byte: {
                    token.setValue(Boolean.parseBoolean(value));
                    break;
                }
                case Double: {
                    Double aDouble = doubleValidator.validate(value, Locale.ROOT);
                    if (aDouble == null) {
                        String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", name, value);
                        throw new IllegalStateException(reason);
                    }
                    token.setValue(aDouble);
                    break;
                }
                case Long: {
                    Long aLong = longValidator.validate(value, Locale.ROOT);
                    if (aLong == null || !longValidator.isInRange(aLong, Integer.MIN_VALUE, Integer.MAX_VALUE)) {
                        String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", name, value);
                        throw new IllegalStateException(reason);
                    }
                    token.setValue(aLong);
                    break;
                }
                case ULong: {
                    Long aLong = longValidator.validate(value, Locale.ROOT);
                    if (aLong == null || !longValidator.isInRange(aLong, 0L, 0xFFFFFFFFL)) {
                        String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", name, value);
                        throw new IllegalStateException(reason);
                    }
                    token.setValue(aLong);
                    break;
                }
                case LongLong: {
                    Long aLong = longValidator.validate(value, Locale.ROOT);
                    if (aLong == null) {
                        String reason = String.format(Locale.ROOT, "Invalid value for request header %s: %s", name, value);
                        throw new IllegalStateException(reason);
                    }
                    token.setValue(aLong);
                    break;
                }
                default: {
                    assert (false) : "Recognized header has neither special-case nor default handling to convert from header String to RNTBD token";
                    break;
                }
            }
        }
    }
}

