/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.federation.store.driver;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.federation.store.FederationStateStoreTestUtils;
import org.apache.hadoop.hdfs.server.federation.store.driver.TestStateStoreDriverBase;
import org.apache.hadoop.hdfs.server.federation.store.driver.impl.StateStoreFileImpl;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestStateStoreFile
extends TestStateStoreDriverBase {
    private final String numFileAsyncThreads;

    public TestStateStoreFile(String numFileAsyncThreads) {
        this.numFileAsyncThreads = numFileAsyncThreads;
    }

    @Parameterized.Parameters(name="numFileAsyncThreads-{0}")
    public static List<String[]> data() {
        return Arrays.asList({"20"}, {"0"});
    }

    private static void setupCluster(String numFsAsyncThreads) throws Exception {
        Configuration conf = FederationStateStoreTestUtils.getStateStoreConfiguration(StateStoreFileImpl.class);
        conf.setInt("dfs.federation.router.store.driver.file.async.threads", Integer.parseInt(numFsAsyncThreads));
        TestStateStoreFile.getStateStore(conf);
    }

    @Before
    public void startup() throws Exception {
        TestStateStoreFile.setupCluster(this.numFileAsyncThreads);
        TestStateStoreFile.removeAll(this.getStateStoreDriver());
    }

    @After
    public void tearDown() throws Exception {
        TestStateStoreFile.tearDownCluster();
    }

    @Test
    public void testInsert() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testInsert(this.getStateStoreDriver());
    }

    @Test
    public void testUpdate() throws IllegalArgumentException, ReflectiveOperationException, IOException, SecurityException {
        this.testPut(this.getStateStoreDriver());
    }

    @Test
    public void testDelete() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testRemove(this.getStateStoreDriver());
    }

    @Test
    public void testFetchErrors() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testFetchErrors(this.getStateStoreDriver());
    }

    @Test
    public void testMetrics() throws IllegalArgumentException, IllegalAccessException, IOException {
        this.testMetrics(this.getStateStoreDriver());
    }

    @Test
    public void testCacheLoadMetrics() throws IOException {
        this.getStateStoreService().getMetrics().setCacheLoading("MountTable", -1L);
        long curMountTableLoadNum = this.getMountTableCacheLoadSamples(this.getStateStoreDriver());
        this.getStateStoreService().refreshCaches(true);
        this.testCacheLoadMetrics(this.getStateStoreDriver(), curMountTableLoadNum + 1L, -1.0);
    }
}

