/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs;

import java.io.IOException;
import java.util.EnumSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.AbstractFileSystem;
import org.apache.hadoop.fs.ChecksumFs;
import org.apache.hadoop.fs.CreateFlag;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileContext;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.local.LocalFs;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.test.HadoopTestBase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestChecksumFs
extends HadoopTestBase {
    private Configuration conf;
    private Path testRootDirPath;
    private FileContext fc;

    @Before
    public void setUp() throws Exception {
        this.conf = TestChecksumFs.getTestConfiguration();
        this.fc = FileContext.getFileContext((Configuration)this.conf);
        this.testRootDirPath = new Path(GenericTestUtils.getRandomizedTestDir().getAbsolutePath());
        this.mkdirs(this.testRootDirPath);
    }

    @After
    public void tearDown() throws Exception {
        if (this.fc != null) {
            this.fc.delete(this.testRootDirPath, true);
        }
    }

    @Test
    public void testRenameFileToFile() throws Exception {
        Path srcPath = new Path(this.testRootDirPath, "testRenameSrc");
        Path dstPath = new Path(this.testRootDirPath, "testRenameDst");
        this.verifyRename(srcPath, dstPath, false);
    }

    @Test
    public void testRenameFileToFileWithOverwrite() throws Exception {
        Path srcPath = new Path(this.testRootDirPath, "testRenameSrc");
        Path dstPath = new Path(this.testRootDirPath, "testRenameDst");
        this.verifyRename(srcPath, dstPath, true);
    }

    @Test
    public void testRenameFileIntoDirFile() throws Exception {
        Path srcPath = new Path(this.testRootDirPath, "testRenameSrc");
        Path dstPath = new Path(this.testRootDirPath, "testRenameDir/testRenameDst");
        this.mkdirs(dstPath);
        this.verifyRename(srcPath, dstPath, false);
    }

    @Test
    public void testRenameFileIntoDirFileWithOverwrite() throws Exception {
        Path srcPath = new Path(this.testRootDirPath, "testRenameSrc");
        Path dstPath = new Path(this.testRootDirPath, "testRenameDir/testRenameDst");
        this.mkdirs(dstPath);
        this.verifyRename(srcPath, dstPath, true);
    }

    private void verifyRename(Path srcPath, Path dstPath, boolean overwrite) throws Exception {
        ChecksumFs fs = (ChecksumFs)this.fc.getDefaultFileSystem();
        fs.delete(srcPath, true);
        fs.delete(dstPath, true);
        Options.Rename renameOpt = Options.Rename.NONE;
        if (overwrite) {
            renameOpt = Options.Rename.OVERWRITE;
            this.createTestFile(fs, dstPath, 2);
        }
        this.createTestFile(fs, srcPath, 1);
        TestChecksumFs.assertTrue((String)("Checksum file doesn't exist for source file - " + srcPath), (boolean)this.fc.util().exists(fs.getChecksumFile(srcPath)));
        fs.rename(srcPath, dstPath, new Options.Rename[]{renameOpt});
        TestChecksumFs.assertTrue((String)("Checksum file doesn't exist for dest file - " + srcPath), (boolean)this.fc.util().exists(fs.getChecksumFile(dstPath)));
        try (FSDataInputStream is = fs.open(dstPath);){
            TestChecksumFs.assertEquals((long)1L, (long)is.readInt());
        }
    }

    private static Configuration getTestConfiguration() {
        Configuration conf = new Configuration(false);
        conf.set("fs.defaultFS", "file:///");
        conf.setClass("fs.AbstractFileSystem.file.impl", LocalFs.class, AbstractFileSystem.class);
        return conf;
    }

    private void createTestFile(ChecksumFs fs, Path path, int content) throws IOException {
        try (FSDataOutputStream fout = fs.create(path, EnumSet.of(CreateFlag.CREATE, CreateFlag.OVERWRITE), new Options.CreateOpts[]{Options.CreateOpts.perms((FsPermission)FsPermission.getDefault())});){
            fout.writeInt(content);
        }
    }

    private void mkdirs(Path dirPath) throws IOException {
        this.fc.mkdir(dirPath, FileContext.DEFAULT_PERM, true);
    }
}

