/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.util;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import org.apache.hadoop.test.LambdaTestUtils;
import org.apache.hadoop.util.HttpExceptionUtils;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;

public class TestHttpExceptionUtils {
    @Test
    public void testCreateServletException() throws IOException {
        StringWriter writer = new StringWriter();
        PrintWriter printWriter = new PrintWriter(writer);
        HttpServletResponse response = (HttpServletResponse)Mockito.mock(HttpServletResponse.class);
        Mockito.when((Object)response.getWriter()).thenReturn((Object)printWriter);
        int status = 500;
        IOException ex = new IOException("Hello IOEX");
        HttpExceptionUtils.createServletExceptionResponse((HttpServletResponse)response, (int)status, (Throwable)ex);
        ((HttpServletResponse)Mockito.verify((Object)response)).setStatus(status);
        ((HttpServletResponse)Mockito.verify((Object)response)).setContentType((String)Mockito.eq((Object)"application/json"));
        ObjectMapper mapper = new ObjectMapper();
        Map json = (Map)mapper.readValue(writer.toString(), Map.class);
        json = (Map)json.get("RemoteException");
        Assert.assertEquals((Object)IOException.class.getName(), json.get("javaClassName"));
        Assert.assertEquals((Object)IOException.class.getSimpleName(), json.get("exception"));
        Assert.assertEquals((Object)"Hello IOEX", json.get("message"));
    }

    @Test
    public void testCreateJerseyException() throws IOException {
        IOException ex = new IOException("Hello IOEX");
        Response response = HttpExceptionUtils.createJerseyExceptionResponse((Response.Status)Response.Status.INTERNAL_SERVER_ERROR, (Throwable)ex);
        Assert.assertEquals((long)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), (long)response.getStatus());
        Assert.assertArrayEquals((Object[])Arrays.asList(MediaType.APPLICATION_JSON_TYPE).toArray(), (Object[])((List)response.getMetadata().get((Object)"Content-Type")).toArray());
        Map entity = (Map)response.getEntity();
        entity = (Map)entity.get("RemoteException");
        Assert.assertEquals((Object)IOException.class.getName(), entity.get("javaClassName"));
        Assert.assertEquals((Object)IOException.class.getSimpleName(), entity.get("exception"));
        Assert.assertEquals((Object)"Hello IOEX", entity.get("message"));
    }

    @Test
    public void testValidateResponseOK() throws IOException {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)201);
        HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201);
    }

    @Test
    public void testValidateResponseFailNoErrorMessage() throws Exception {
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)400);
        LambdaTestUtils.intercept(IOException.class, () -> HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201));
    }

    @Test
    public void testValidateResponseNonJsonErrorMessage() throws Exception {
        String msg = "stream";
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getErrorStream()).thenReturn((Object)is);
        Mockito.when((Object)conn.getResponseMessage()).thenReturn((Object)"msg");
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)400);
        LambdaTestUtils.interceptAndValidateMessageContains(IOException.class, Arrays.asList(Integer.toString(400), "msg", "com.fasterxml.jackson.core.JsonParseException"), () -> HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201));
    }

    @Test
    public void testValidateResponseJsonErrorKnownException() throws Exception {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("exception", IllegalStateException.class.getSimpleName());
        json.put("javaClassName", IllegalStateException.class.getName());
        json.put("message", "EX");
        HashMap<String, HashMap<String, String>> response = new HashMap<String, HashMap<String, String>>();
        response.put("RemoteException", json);
        ObjectMapper jsonMapper = new ObjectMapper();
        String msg = jsonMapper.writeValueAsString(response);
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getErrorStream()).thenReturn((Object)is);
        Mockito.when((Object)conn.getResponseMessage()).thenReturn((Object)"msg");
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)400);
        LambdaTestUtils.intercept(IllegalStateException.class, "EX", () -> HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201));
    }

    @Test
    public void testValidateResponseJsonErrorUnknownException() throws Exception {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("exception", "FooException");
        json.put("javaClassName", "foo.FooException");
        json.put("message", "EX");
        HashMap<String, HashMap<String, String>> response = new HashMap<String, HashMap<String, String>>();
        response.put("RemoteException", json);
        ObjectMapper jsonMapper = new ObjectMapper();
        String msg = jsonMapper.writeValueAsString(response);
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getErrorStream()).thenReturn((Object)is);
        Mockito.when((Object)conn.getResponseMessage()).thenReturn((Object)"msg");
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)400);
        LambdaTestUtils.interceptAndValidateMessageContains(IOException.class, Arrays.asList(Integer.toString(400), "foo.FooException", "EX"), () -> HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201));
    }

    @Test
    public void testValidateResponseJsonErrorNonException() throws Exception {
        HashMap<String, String> json = new HashMap<String, String>();
        json.put("exception", "invalid");
        json.put("javaClassName", String.class.getName());
        json.put("message", "EX");
        HashMap<String, HashMap<String, String>> response = new HashMap<String, HashMap<String, String>>();
        response.put("RemoteException", json);
        ObjectMapper jsonMapper = new ObjectMapper();
        String msg = jsonMapper.writeValueAsString(response);
        ByteArrayInputStream is = new ByteArrayInputStream(msg.getBytes(StandardCharsets.UTF_8));
        HttpURLConnection conn = (HttpURLConnection)Mockito.mock(HttpURLConnection.class);
        Mockito.when((Object)conn.getErrorStream()).thenReturn((Object)is);
        Mockito.when((Object)conn.getResponseMessage()).thenReturn((Object)"msg");
        Mockito.when((Object)conn.getResponseCode()).thenReturn((Object)400);
        LambdaTestUtils.interceptAndValidateMessageContains(IOException.class, Arrays.asList(Integer.toString(400), "java.lang.String", "EX"), () -> HttpExceptionUtils.validateResponse((HttpURLConnection)conn, (int)201));
    }
}

