/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.contracts.services;

import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobListResultEntrySchema;
import org.apache.hadoop.fs.azurebfs.contracts.services.BlobListResultSchema;
import org.apache.hadoop.fs.azurebfs.utils.DateTimeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BlobListXmlParser
extends DefaultHandler {
    private final BlobListResultSchema listResultSchema;
    private final String url;
    private BlobListResultEntrySchema currentBlobEntry;
    private StringBuilder bld = new StringBuilder();
    private final Stack<String> elements = new Stack();

    public BlobListXmlParser(BlobListResultSchema listResultSchema, String url) {
        this.listResultSchema = listResultSchema;
        this.url = url;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.elements.push(localName);
        if ("Blob".equals(localName) || "BlobPrefix".equals(localName)) {
            this.currentBlobEntry = new BlobListResultEntrySchema();
        }
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String value;
        String currentNode = this.elements.pop();
        if (!currentNode.equals(localName)) {
            throw new SAXException("Invalid XML");
        }
        String parentNode = "";
        if (this.elements.size() > 0) {
            parentNode = this.elements.peek();
        }
        if ((value = this.bld.toString()).isEmpty()) {
            value = null;
        }
        if ("Blob".equals(currentNode)) {
            this.listResultSchema.addBlobListEntry(this.currentBlobEntry);
            this.currentBlobEntry = null;
        }
        if ("BlobPrefix".equals(currentNode)) {
            this.currentBlobEntry.setIsDirectory(true);
            this.listResultSchema.addBlobListEntry(this.currentBlobEntry);
            this.currentBlobEntry = null;
        }
        if ("NextMarker".equals(currentNode)) {
            this.listResultSchema.setNextMarker(value);
        }
        if (currentNode.equals("Name") && (parentNode.equals("Blob") || parentNode.equals("BlobPrefix"))) {
            if (value.endsWith("/")) {
                value = value.substring(0, value.length() - 1);
            }
            this.currentBlobEntry.setName(value);
            this.currentBlobEntry.setPath(new Path("/" + value));
            this.currentBlobEntry.setUrl(this.url + "/" + value);
        }
        if (parentNode.equals("Metadata")) {
            this.currentBlobEntry.addMetadata(currentNode, value);
            if ("hdi_isfolder".equalsIgnoreCase(currentNode)) {
                this.currentBlobEntry.setIsDirectory(Boolean.valueOf(value));
            }
        }
        if (parentNode.equals("Properties")) {
            if (currentNode.equals("Creation-Time")) {
                this.currentBlobEntry.setCreationTime(value);
            }
            if (currentNode.equals("Last-Modified")) {
                this.currentBlobEntry.setLastModifiedTime(value);
            }
            if (currentNode.equals("Etag")) {
                this.currentBlobEntry.setETag(value);
            }
            if (currentNode.equals("Owner")) {
                this.currentBlobEntry.setOwner(value);
            }
            if (currentNode.equals("Group")) {
                this.currentBlobEntry.setGroup(value);
            }
            if (currentNode.equals("Permissions")) {
                this.currentBlobEntry.setPermission(value);
            }
            if (currentNode.equals("Acl")) {
                this.currentBlobEntry.setAcl(value);
            }
            if (currentNode.equals("ResourceType") && "directory".equals(value)) {
                this.currentBlobEntry.setIsDirectory(true);
            }
            if (currentNode.equals("Content-Length")) {
                this.currentBlobEntry.setContentLength(Long.parseLong(value));
            }
            if (currentNode.equals("CopyId")) {
                this.currentBlobEntry.setCopyId(value);
            }
            if (currentNode.equals("CopyStatus")) {
                this.currentBlobEntry.setCopyStatus(value);
            }
            if (currentNode.equals("CopySource")) {
                this.currentBlobEntry.setCopySourceUrl(value);
            }
            if (currentNode.equals("CopyProgress")) {
                this.currentBlobEntry.setCopyProgress(value);
            }
            if (currentNode.equals("CopyCompletionTime")) {
                this.currentBlobEntry.setCopyCompletionTime(DateTimeUtils.parseLastModifiedTime(value));
            }
            if (currentNode.equals("CopyStatusDescription")) {
                this.currentBlobEntry.setCopyStatusDescription(value);
            }
        }
        this.bld = new StringBuilder();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.bld.append(ch, start, length);
    }
}

