/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.azurebfs.services;

import java.io.IOException;
import java.util.Objects;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.AbfsRestOperationException;
import org.apache.hadoop.fs.azurebfs.contracts.exceptions.InvalidIngressServiceException;
import org.apache.hadoop.fs.azurebfs.contracts.services.AppendRequestParameters;
import org.apache.hadoop.fs.azurebfs.contracts.services.AzureServiceErrorCode;
import org.apache.hadoop.fs.azurebfs.services.AbfsBlock;
import org.apache.hadoop.fs.azurebfs.services.AbfsClient;
import org.apache.hadoop.fs.azurebfs.services.AbfsOutputStream;
import org.apache.hadoop.fs.azurebfs.services.AbfsRestOperation;
import org.apache.hadoop.fs.azurebfs.services.AzureBlockManager;
import org.apache.hadoop.fs.azurebfs.utils.TracingContext;
import org.apache.hadoop.fs.store.DataBlocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AzureIngressHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbfsOutputStream.class);
    private AbfsOutputStream abfsOutputStream;

    protected AzureIngressHandler(AbfsOutputStream abfsOutputStream) {
        this.abfsOutputStream = abfsOutputStream;
    }

    public AbfsOutputStream getAbfsOutputStream() {
        return this.abfsOutputStream;
    }

    public void setAbfsOutputStream(AbfsOutputStream abfsOutputStream) {
        this.abfsOutputStream = abfsOutputStream;
    }

    public abstract String getETag();

    protected abstract int bufferData(AbfsBlock var1, byte[] var2, int var3, int var4) throws IOException;

    protected abstract AbfsRestOperation remoteWrite(AbfsBlock var1, DataBlocks.BlockUploadData var2, AppendRequestParameters var3, TracingContext var4) throws IOException;

    protected abstract AbfsRestOperation remoteFlush(long var1, boolean var3, boolean var4, String var5, TracingContext var6) throws IOException;

    protected abstract void writeAppendBlobCurrentBufferToService() throws IOException;

    protected abstract AbfsRestOperation remoteAppendBlobWrite(String var1, DataBlocks.BlockUploadData var2, AbfsBlock var3, AppendRequestParameters var4, TracingContext var5) throws IOException;

    protected boolean shouldIngressHandlerBeSwitched(AbfsRestOperationException ex) {
        if (ex == null || ex.getErrorCode() == null) {
            return false;
        }
        String errorCode = ex.getErrorCode().getErrorCode();
        if (errorCode != null) {
            return ex.getStatusCode() == 409 && (Objects.equals(errorCode, AzureServiceErrorCode.BLOB_OPERATION_NOT_SUPPORTED.getErrorCode()) || Objects.equals(errorCode, AzureServiceErrorCode.INVALID_APPEND_OPERATION.getErrorCode()));
        }
        return false;
    }

    protected InvalidIngressServiceException getIngressHandlerSwitchException(AbfsRestOperationException e) {
        if (e.getMessage().contains("Blob operation is not supported.")) {
            return new InvalidIngressServiceException(e.getStatusCode(), AzureServiceErrorCode.BLOB_OPERATION_NOT_SUPPORTED.getErrorCode(), "Blob operation is not supported. " + this.getClass().getName(), e);
        }
        return new InvalidIngressServiceException(e.getStatusCode(), AzureServiceErrorCode.INVALID_APPEND_OPERATION.getErrorCode(), "The resource was created or modified by the Azure Blob Service API and cannot be appended to by the Azure Data Lake Storage Service API " + this.getClass().getName(), e);
    }

    protected abstract AzureBlockManager getBlockManager();

    public abstract AbfsClient getClient();
}

