/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.service.api.records;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableMap;
import org.apache.hadoop.thirdparty.com.google.common.collect.ImmutableSet;

@ApiModel(description="ResourceInformation determines unit/value of resource types in addition to memory and vcores. It will be part of Resource object")
public class ResourceInformation {
    @SerializedName(value="value")
    private Long value = null;
    @SerializedName(value="unit")
    private String unit = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;
    @SerializedName(value="tags")
    private Set<String> tags = null;

    public ResourceInformation value(Long value) {
        this.value = value;
        return this;
    }

    public ResourceInformation tags(Set<String> resourceTags) {
        this.tags = resourceTags;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="tags")
    public Set<String> getTags() {
        return this.tags == null ? ImmutableSet.of() : this.tags;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="attributes")
    public Map<String, String> getAttributes() {
        return this.attributes == null ? ImmutableMap.of() : this.attributes;
    }

    public ResourceInformation attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    @ApiModelProperty(value="Integer value of the resource.")
    @JsonProperty(value="value")
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }

    public ResourceInformation unit(String unit) {
        this.unit = unit;
        return this;
    }

    @ApiModelProperty(value="")
    @JsonProperty(value="unit")
    public String getUnit() {
        return this.unit == null ? "" : this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResourceInformation resourceInformation = (ResourceInformation)o;
        return Objects.equals(this.value, resourceInformation.value) && Objects.equals(this.unit, resourceInformation.unit);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ResourceInformation {\n").append("    value: ").append(this.toIndentedString(this.value)).append("\n").append("    unit: ").append(this.toIndentedString(this.unit)).append("\n").append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n").append("    tags: ").append(this.toIndentedString(this.tags)).append("\n").append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

