/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract;

import java.io.FileNotFoundException;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.contract.AbstractFSContractTestBase;
import org.apache.hadoop.fs.contract.ContractTestUtils;
import org.apache.hadoop.shaded.org.assertj.core.api.AbstractLongAssert;
import org.apache.hadoop.shaded.org.assertj.core.api.Assertions;
import org.apache.hadoop.test.LambdaTestUtils;
import org.junit.Test;

public abstract class AbstractContractContentSummaryTest
extends AbstractFSContractTestBase {
    @Test
    public void testGetContentSummary() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path parent = this.path("parent");
        Path nested = this.path(parent + "/a/b/c");
        Path filePath = this.path(nested + "file.txt");
        fs.mkdirs(parent);
        fs.mkdirs(nested);
        ContractTestUtils.touch(this.getFileSystem(), filePath);
        ContentSummary summary = fs.getContentSummary(parent);
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getDirectoryCount()).as("Summary " + summary, new Object[0])).isEqualTo(4L);
        ((AbstractLongAssert)Assertions.assertThat((long)summary.getFileCount()).as("Summary " + summary, new Object[0])).isEqualTo(1L);
    }

    @Test
    public void testGetContentSummaryIncorrectPath() throws Throwable {
        FileSystem fs = this.getFileSystem();
        Path parent = this.path("parent");
        Path nested = this.path(parent + "/a");
        fs.mkdirs(parent);
        LambdaTestUtils.intercept(FileNotFoundException.class, () -> fs.getContentSummary(nested));
    }
}

