/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileUtil;
import org.apache.hadoop.ha.HAServiceProtocol;
import org.apache.hadoop.hdfs.protocol.ExtendedBlock;
import org.apache.hadoop.hdfs.protocolPB.DatanodeProtocolClientSideTranslatorPB;
import org.apache.hadoop.hdfs.server.datanode.BPOfferService;
import org.apache.hadoop.hdfs.server.datanode.BPServiceActor;
import org.apache.hadoop.hdfs.server.datanode.DataNode;
import org.apache.hadoop.hdfs.server.datanode.StorageLocation;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsDatasetSpi;
import org.apache.hadoop.hdfs.server.datanode.fsdataset.FsVolumeSpi;
import org.apache.hadoop.hdfs.server.namenode.NameNode;
import org.apache.hadoop.hdfs.server.protocol.DatanodeCommand;
import org.apache.hadoop.hdfs.server.protocol.DatanodeRegistration;
import org.apache.hadoop.hdfs.server.protocol.HeartbeatResponse;
import org.apache.hadoop.hdfs.server.protocol.NNHAStatusHeartbeat;
import org.apache.hadoop.hdfs.server.protocol.NamespaceInfo;
import org.apache.hadoop.hdfs.server.protocol.SlowDiskReports;
import org.apache.hadoop.hdfs.server.protocol.SlowPeerReports;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.server.protocol.VolumeFailureSummary;
import org.apache.hadoop.shaded.org.mockito.ArgumentMatchers;
import org.apache.hadoop.shaded.org.mockito.Mockito;
import org.apache.hadoop.shaded.org.mockito.invocation.InvocationOnMock;
import org.apache.hadoop.shaded.org.mockito.stubbing.Answer;
import org.apache.hadoop.util.Preconditions;
import org.junit.Assert;

public class InternalDataNodeTestUtils {
    public static final String TEST_CLUSTER_ID = "testClusterID";
    public static final String TEST_POOL_ID = "BP-TEST";

    public static DatanodeRegistration getDNRegistrationForBP(DataNode dn, String bpid) throws IOException {
        return dn.getDNRegistrationForBP(bpid);
    }

    public static void mockDatanodeBlkPinning(DataNode dn, final boolean pinned) throws IOException {
        FsDatasetSpi<? extends FsVolumeSpi> data = dn.data;
        dn.data = Mockito.spy(data);
        Mockito.doAnswer(new Answer<Object>(){

            @Override
            public Object answer(InvocationOnMock invocation) throws IOException {
                return pinned;
            }
        }).when(dn.data).getPinning(ArgumentMatchers.any(ExtendedBlock.class));
    }

    public static DatanodeProtocolClientSideTranslatorPB spyOnBposToNN(DataNode dn, NameNode nn) {
        String bpid = nn.getNamesystem().getBlockPoolId();
        BPOfferService bpos = null;
        for (BPOfferService bPOfferService : dn.getAllBpOs()) {
            if (!bPOfferService.getBlockPoolId().equals(bpid)) continue;
            bpos = bPOfferService;
            break;
        }
        Preconditions.checkArgument((bpos != null ? 1 : 0) != 0, (String)"No such bpid: %s", (Object[])new Object[]{bpid});
        BPServiceActor bpsa = null;
        for (BPServiceActor thisBpsa : bpos.getBPServiceActors()) {
            if (!thisBpsa.getNNSocketAddress().equals(nn.getServiceRpcAddress())) continue;
            bpsa = thisBpsa;
            break;
        }
        Preconditions.checkArgument((bpsa != null ? 1 : 0) != 0, (String)"No service actor to NN at %s", (Object[])new Object[]{nn.getServiceRpcAddress()});
        DatanodeProtocolClientSideTranslatorPB datanodeProtocolClientSideTranslatorPB = bpsa.getNameNodeProxy();
        DatanodeProtocolClientSideTranslatorPB spy = Mockito.spy(datanodeProtocolClientSideTranslatorPB);
        bpsa.setNameNode(spy);
        return spy;
    }

    public static DataNode startDNWithMockNN(Configuration conf, final InetSocketAddress nnSocketAddr, String dnDataDir) throws IOException {
        FileSystem.setDefaultUri((Configuration)conf, (String)("hdfs://" + nnSocketAddr.getHostName() + ":" + nnSocketAddr.getPort()));
        ArrayList<StorageLocation> locations = new ArrayList<StorageLocation>();
        File dataDir = new File(dnDataDir);
        FileUtil.fullyDelete((File)dataDir);
        dataDir.mkdirs();
        StorageLocation location = StorageLocation.parse(dataDir.getPath());
        locations.add(location);
        final DatanodeProtocolClientSideTranslatorPB namenode = Mockito.mock(DatanodeProtocolClientSideTranslatorPB.class);
        Mockito.doAnswer(new Answer<DatanodeRegistration>(){

            @Override
            public DatanodeRegistration answer(InvocationOnMock invocation) throws Throwable {
                return (DatanodeRegistration)invocation.getArguments()[0];
            }
        }).when(namenode).registerDatanode(Mockito.any(DatanodeRegistration.class));
        Mockito.when(namenode.versionRequest()).thenReturn(new NamespaceInfo(1, TEST_CLUSTER_ID, TEST_POOL_ID, 1L));
        Mockito.when(namenode.sendHeartbeat((DatanodeRegistration)Mockito.any(), (StorageReport[])Mockito.any(), Mockito.anyLong(), Mockito.anyLong(), Mockito.anyInt(), Mockito.anyInt(), Mockito.anyInt(), (VolumeFailureSummary)Mockito.any(), Mockito.anyBoolean(), (SlowPeerReports)Mockito.any(), (SlowDiskReports)Mockito.any())).thenReturn(new HeartbeatResponse(new DatanodeCommand[0], new NNHAStatusHeartbeat(HAServiceProtocol.HAServiceState.ACTIVE, 1L), null, ThreadLocalRandom.current().nextLong() | 1L));
        DataNode dn = new DataNode(conf, locations, null, null){

            @Override
            DatanodeProtocolClientSideTranslatorPB connectToNN(InetSocketAddress nnAddr) throws IOException {
                Assert.assertEquals((Object)nnSocketAddr, (Object)nnAddr);
                return namenode;
            }
        };
        dn.getAllBpOs().get(0).triggerHeartbeatForTests();
        return dn;
    }
}

