/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.util.Map;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.security.http.RestCsrfPreventionFilter;
import org.apache.hadoop.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandler;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpVersion;
import org.apache.hadoop.shaded.io.netty.util.ReferenceCountUtil;
import org.apache.hadoop.shaded.javax.servlet.FilterConfig;
import org.apache.hadoop.shaded.javax.servlet.ServletException;
import org.slf4j.Logger;

@InterfaceAudience.Private
@ChannelHandler.Sharable
final class RestCsrfPreventionFilterHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private static final Logger LOG = DatanodeHttpServer.LOG;
    private final RestCsrfPreventionFilter restCsrfPreventionFilter;

    RestCsrfPreventionFilterHandler(RestCsrfPreventionFilter restCsrfPreventionFilter) {
        if (restCsrfPreventionFilter == null) {
            LOG.warn("Got null for restCsrfPreventionFilter - will not do any filtering.");
        }
        this.restCsrfPreventionFilter = restCsrfPreventionFilter;
    }

    @Override
    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (this.restCsrfPreventionFilter != null) {
            this.restCsrfPreventionFilter.handleHttpInteraction((RestCsrfPreventionFilter.HttpInteraction)new NettyHttpInteraction(ctx, req));
        } else {
            new NettyHttpInteraction(ctx, req).proceed();
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        LOG.error("Exception in " + this.getClass().getSimpleName(), cause);
        RestCsrfPreventionFilterHandler.sendResponseAndClose(ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR));
    }

    private static void sendResponseAndClose(ChannelHandlerContext ctx, DefaultHttpResponse resp) {
        resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
    }

    public static RestCsrfPreventionFilter initializeState(Configuration conf) {
        if (!conf.getBoolean("dfs.webhdfs.rest-csrf.enabled", false)) {
            return null;
        }
        String restCsrfClassName = RestCsrfPreventionFilter.class.getName();
        Map restCsrfParams = RestCsrfPreventionFilter.getFilterParams((Configuration)conf, (String)"dfs.webhdfs.rest-csrf.");
        RestCsrfPreventionFilter filter = new RestCsrfPreventionFilter();
        try {
            filter.init((FilterConfig)new DatanodeHttpServer.MapBasedFilterConfig(restCsrfClassName, restCsrfParams));
        }
        catch (ServletException e) {
            throw new IllegalStateException("Failed to initialize RestCsrfPreventionFilter.", e);
        }
        return filter;
    }

    private static final class NettyHttpInteraction
    implements RestCsrfPreventionFilter.HttpInteraction {
        private final ChannelHandlerContext ctx;
        private final HttpRequest req;

        NettyHttpInteraction(ChannelHandlerContext ctx, HttpRequest req) {
            this.ctx = ctx;
            this.req = req;
        }

        public String getHeader(String header) {
            return this.req.headers().get(header);
        }

        public String getMethod() {
            return this.req.getMethod().name();
        }

        public void proceed() {
            ReferenceCountUtil.retain(this.req);
            this.ctx.fireChannelRead(this.req);
        }

        public void sendError(int code, String message) {
            HttpResponseStatus status = new HttpResponseStatus(code, message);
            RestCsrfPreventionFilterHandler.sendResponseAndClose(this.ctx, new DefaultHttpResponse(HttpVersion.HTTP_1_1, status));
        }
    }
}

