/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode.web;

import java.net.InetSocketAddress;
import org.apache.hadoop.hdfs.server.datanode.web.DatanodeHttpServer;
import org.apache.hadoop.shaded.io.netty.bootstrap.Bootstrap;
import org.apache.hadoop.shaded.io.netty.buffer.Unpooled;
import org.apache.hadoop.shaded.io.netty.channel.Channel;
import org.apache.hadoop.shaded.io.netty.channel.ChannelFuture;
import org.apache.hadoop.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.hadoop.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.hadoop.shaded.io.netty.channel.ChannelInitializer;
import org.apache.hadoop.shaded.io.netty.channel.ChannelPipeline;
import org.apache.hadoop.shaded.io.netty.channel.SimpleChannelInboundHandler;
import org.apache.hadoop.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.hadoop.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.DefaultHttpResponse;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpHeaderValues;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpRequestEncoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseEncoder;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.hadoop.shaded.io.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;

class SimpleHttpProxyHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private String uri;
    private Channel proxiedChannel;
    private final InetSocketAddress host;
    static final Logger LOG = DatanodeHttpServer.LOG;

    SimpleHttpProxyHandler(InetSocketAddress host) {
        this.host = host;
    }

    @Override
    public void channelRead0(final ChannelHandlerContext ctx, final HttpRequest req) {
        this.uri = req.uri();
        final Channel client = ctx.channel();
        Bootstrap proxiedServer = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(client.eventLoop())).channel(NioSocketChannel.class)).handler(new ChannelInitializer<SocketChannel>(){

            @Override
            protected void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                p.addLast(new HttpRequestEncoder(), new Forwarder(SimpleHttpProxyHandler.this.uri, client));
            }
        });
        ChannelFuture f = proxiedServer.connect(this.host);
        this.proxiedChannel = f.channel();
        f.addListener(new ChannelFutureListener(){

            @Override
            public void operationComplete(ChannelFuture future) throws Exception {
                if (future.isSuccess()) {
                    ctx.channel().pipeline().remove(HttpResponseEncoder.class);
                    DefaultFullHttpRequest newReq = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, req.method(), req.uri());
                    newReq.headers().add(req.headers());
                    newReq.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    future.channel().writeAndFlush(newReq);
                } else {
                    DefaultHttpResponse resp = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    resp.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
                    LOG.info("Proxy " + SimpleHttpProxyHandler.this.uri + " failed. Cause: ", future.cause());
                    ctx.writeAndFlush(resp).addListener(ChannelFutureListener.CLOSE);
                    client.close();
                }
            }
        });
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.proxiedChannel != null) {
            this.proxiedChannel.close();
            this.proxiedChannel = null;
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Proxy for " + this.uri + " failed. cause: ", cause);
        }
        if (this.proxiedChannel != null) {
            this.proxiedChannel.close();
            this.proxiedChannel = null;
        }
        ctx.close();
    }

    private static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush(Unpooled.EMPTY_BUFFER).addListener(ChannelFutureListener.CLOSE);
        }
    }

    private static class Forwarder
    extends ChannelInboundHandlerAdapter {
        private final String uri;
        private final Channel client;

        private Forwarder(String uri, Channel client) {
            this.uri = uri;
            this.client = client;
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            SimpleHttpProxyHandler.closeOnFlush(this.client);
        }

        @Override
        public void channelRead(final ChannelHandlerContext ctx, Object msg) {
            this.client.writeAndFlush(msg).addListener(new ChannelFutureListener(){

                @Override
                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        LOG.debug("Proxy failed. Cause: ", future.cause());
                        future.channel().close();
                    }
                }
            });
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            LOG.debug("Proxy for " + this.uri + " failed. cause: ", cause);
            SimpleHttpProxyHandler.closeOnFlush(ctx.channel());
        }
    }
}

