/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequest;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerRequestFilter;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ContainerResponseFilter;
import org.apache.hadoop.shaded.com.sun.jersey.spi.container.ResourceFilter;
import org.apache.hadoop.shaded.javax.ws.rs.core.MultivaluedMap;
import org.apache.hadoop.shaded.javax.ws.rs.core.UriBuilder;
import org.apache.hadoop.util.StringUtils;

public class ParamFilter
implements ResourceFilter {
    private static final ContainerRequestFilter LOWER_CASE = new ContainerRequestFilter(){

        @Override
        public ContainerRequest filter(ContainerRequest request) {
            MultivaluedMap<String, String> parameters = request.getQueryParameters();
            if (ParamFilter.containsUpperCase(parameters.keySet())) {
                URI lower = ParamFilter.rebuildQuery(request.getRequestUri(), (MultivaluedMap<String, String>)parameters);
                request.setUris(request.getBaseUri(), lower);
            }
            return request;
        }
    };

    @Override
    public ContainerRequestFilter getRequestFilter() {
        return LOWER_CASE;
    }

    @Override
    public ContainerResponseFilter getResponseFilter() {
        return null;
    }

    static boolean containsUpperCase(Iterable<String> strings) {
        for (String s : strings) {
            for (int i = 0; i < s.length(); ++i) {
                if (!Character.isUpperCase(s.charAt(i))) continue;
                return true;
            }
        }
        return false;
    }

    private static URI rebuildQuery(URI uri, MultivaluedMap<String, String> parameters) {
        UriBuilder b = UriBuilder.fromUri((URI)uri).replaceQuery("");
        for (Map.Entry e : parameters.entrySet()) {
            String key = StringUtils.toLowerCase((String)((String)e.getKey()));
            for (String v : (List)e.getValue()) {
                b = b.queryParam(key, new Object[]{v});
            }
        }
        return b.build(new Object[0]);
    }
}

