/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.io.file.tfile;

import java.io.IOException;
import org.apache.hadoop.util.Time;

public class Timer {
    long startTimeEpoch;
    long finishTimeEpoch;

    public void startTime() throws IOException {
        this.startTimeEpoch = Time.now();
    }

    public void stopTime() throws IOException {
        this.finishTimeEpoch = Time.now();
    }

    public long getIntervalMillis() throws IOException {
        return this.finishTimeEpoch - this.startTimeEpoch;
    }

    public void printlnWithTimestamp(String message) throws IOException {
        System.out.println(this.formatCurrentTime() + "  " + message);
    }

    public String formatTime(long millis) {
        return Time.formatTime((long)millis);
    }

    public String getIntervalString() throws IOException {
        long time = this.getIntervalMillis();
        return this.formatTime(time);
    }

    public String formatCurrentTime() {
        return this.formatTime(Time.now());
    }
}

