/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.registry.client.types;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.hadoop.shaded.com.fasterxml.jackson.annotation.JsonProperty;

@InterfaceAudience.Public
@InterfaceStability.Evolving
@JsonIgnoreProperties(ignoreUnknown=true)
public final class RegistryPathStatus {
    public final String path;
    public final long time;
    public final long size;
    public final int children;

    public RegistryPathStatus(@JsonProperty(value="path") String path, @JsonProperty(value="time") long time, @JsonProperty(value="size") long size, @JsonProperty(value="children") int children) {
        this.path = path;
        this.time = time;
        this.size = size;
        this.children = children;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RegistryPathStatus status = (RegistryPathStatus)other;
        if (this.size != status.size) {
            return false;
        }
        if (this.time != status.time) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(status.path) : status.path != null);
    }

    public int hashCode() {
        return this.path != null ? this.path.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RegistryPathStatus{");
        sb.append("path='").append(this.path).append('\'');
        sb.append(", time=").append(this.time);
        sb.append(", size=").append(this.size);
        sb.append(", children=").append(this.children);
        sb.append('}');
        return sb.toString();
    }
}

