/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant;

import org.apache.hadoop.shaded.net.bytebuddy.description.type.TypeDefinition;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.Implementation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant.DoubleConstant;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant.FloatConstant;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant.LongConstant;
import org.apache.hadoop.shaded.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import org.apache.hadoop.shaded.net.bytebuddy.jar.asm.MethodVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum DefaultValue implements StackManipulation
{
    INTEGER(IntegerConstant.ZERO),
    LONG(LongConstant.ZERO),
    FLOAT(FloatConstant.ZERO),
    DOUBLE(DoubleConstant.ZERO),
    VOID(StackManipulation.Trivial.INSTANCE),
    REFERENCE(NullConstant.INSTANCE);

    private final StackManipulation stackManipulation;

    private DefaultValue(StackManipulation stackManipulation) {
        this.stackManipulation = stackManipulation;
    }

    public static StackManipulation of(TypeDefinition typeDefinition) {
        if (typeDefinition.isPrimitive()) {
            if (typeDefinition.represents(Long.TYPE)) {
                return LONG;
            }
            if (typeDefinition.represents(Double.TYPE)) {
                return DOUBLE;
            }
            if (typeDefinition.represents(Float.TYPE)) {
                return FLOAT;
            }
            if (typeDefinition.represents(Void.TYPE)) {
                return VOID;
            }
            return INTEGER;
        }
        return REFERENCE;
    }

    @Override
    public boolean isValid() {
        return this.stackManipulation.isValid();
    }

    @Override
    public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context implementationContext) {
        return this.stackManipulation.apply(methodVisitor, implementationContext);
    }
}

