/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.ehcache.impl.internal.store.disk.factories;

import java.nio.IntBuffer;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.shaded.org.ehcache.core.spi.store.Store;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap.SwitchableEvictionAdvisor;
import org.apache.hadoop.shaded.org.ehcache.impl.internal.store.offheap.factories.EhcacheSegmentFactory;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.AbstractLockedOffHeapHashMap;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.paging.MappedPageSource;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentReadWriteLockedOffHeapClockCache;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.disk.persistent.PersistentStorageEngine;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.pinning.PinnableSegment;
import org.apache.hadoop.shaded.org.ehcache.shadow.org.terracotta.offheapstore.util.Factory;

public class EhcachePersistentSegmentFactory<K, V>
implements Factory<PinnableSegment<K, V>> {
    private final Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory;
    private final MappedPageSource tableSource;
    private final int tableSize;
    private final SwitchableEvictionAdvisor<? super K, ? super V> evictionAdvisor;
    private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;
    private final boolean bootstrap;

    public EhcachePersistentSegmentFactory(MappedPageSource source, Factory<? extends PersistentStorageEngine<? super K, ? super V>> storageEngineFactory, int initialTableSize, SwitchableEvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener, boolean bootstrap) {
        this.storageEngineFactory = storageEngineFactory;
        this.tableSource = source;
        this.tableSize = initialTableSize;
        this.evictionAdvisor = evictionAdvisor;
        this.evictionListener = evictionListener;
        this.bootstrap = bootstrap;
    }

    @Override
    public EhcachePersistentSegment<K, V> newInstance() {
        PersistentStorageEngine<K, V> storageEngine = this.storageEngineFactory.newInstance();
        try {
            return new EhcachePersistentSegment<K, V>(this.tableSource, storageEngine, this.tableSize, this.bootstrap, this.evictionAdvisor, this.evictionListener);
        }
        catch (RuntimeException e) {
            storageEngine.destroy();
            throw e;
        }
    }

    public static class EhcachePersistentSegment<K, V>
    extends PersistentReadWriteLockedOffHeapClockCache<K, V> {
        private final SwitchableEvictionAdvisor<? super K, ? super V> evictionAdvisor;
        private final EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener;

        EhcachePersistentSegment(MappedPageSource source, PersistentStorageEngine<? super K, ? super V> storageEngine, int tableSize, boolean bootstrap, SwitchableEvictionAdvisor<? super K, ? super V> evictionAdvisor, EhcacheSegmentFactory.EhcacheSegment.EvictionListener<K, V> evictionListener) {
            super(source, storageEngine, tableSize, bootstrap);
            this.evictionAdvisor = evictionAdvisor;
            this.evictionListener = evictionListener;
        }

        @Override
        public V put(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value);
            return this.put(key, value, metadata);
        }

        private int getEvictionAdviceStatus(K key, V value) {
            return this.evictionAdvisor.adviseAgainstEviction(key, value) ? 0x20000000 : 0;
        }

        @Override
        public V putPinned(K key, V value) {
            int metadata = this.getEvictionAdviceStatus(key, value) | 0x40000000;
            return this.put(key, value, metadata);
        }

        @Override
        protected boolean evictable(int status) {
            return super.evictable(status) && ((status & 0x20000000) == 0 || !this.evictionAdvisor.isSwitchedOn());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean evict(int index, boolean shrink) {
            Lock lock = this.writeLock();
            lock.lock();
            try {
                Map.Entry entry = this.getEntryAtTableOffset(index);
                boolean evicted = super.evict(index, shrink);
                if (evicted) {
                    this.evictionListener.onEviction(entry.getKey(), entry.getValue());
                }
                boolean bl = evicted;
                return bl;
            }
            finally {
                lock.unlock();
            }
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new EntrySet();
        }

        private class EntrySet
        extends AbstractLockedOffHeapHashMap.LockedEntrySet {
            private EntrySet() {
                super(EhcachePersistentSegment.this);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                EhcachePersistentSegment.this.readLock().lock();
                try {
                    AbstractLockedOffHeapHashMap.LockedEntryIterator lockedEntryIterator = new AbstractLockedOffHeapHashMap.LockedEntryIterator(){

                        @Override
                        protected Map.Entry<K, V> create(IntBuffer entry) {
                            Object entryObject = super.create(entry);
                            ((Store.ValueHolder)entryObject.getValue()).get();
                            return entryObject;
                        }
                    };
                    return lockedEntryIterator;
                }
                finally {
                    EhcachePersistentSegment.this.readLock().unlock();
                }
            }
        }
    }
}

