/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.glassfish.grizzly;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.List;
import org.apache.hadoop.shaded.org.glassfish.grizzly.CompletionHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Connection;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ConnectionProbe;
import org.apache.hadoop.shaded.org.glassfish.grizzly.GrizzlyFuture;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Processor;
import org.apache.hadoop.shaded.org.glassfish.grizzly.ProcessorSelector;
import org.apache.hadoop.shaded.org.glassfish.grizzly.SocketConnectorHandler;
import org.apache.hadoop.shaded.org.glassfish.grizzly.Transport;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.FutureImpl;
import org.apache.hadoop.shaded.org.glassfish.grizzly.impl.SafeFutureImpl;

public abstract class AbstractSocketConnectorHandler
implements SocketConnectorHandler {
    protected final Transport transport;
    private Processor processor;
    private ProcessorSelector processorSelector;
    protected final List<ConnectionProbe> probes = new LinkedList<ConnectionProbe>();

    public AbstractSocketConnectorHandler(Transport transport) {
        this.transport = transport;
        this.processor = transport.getProcessor();
        this.processorSelector = transport.getProcessorSelector();
    }

    public GrizzlyFuture<Connection> connect(String host, int port) {
        return this.connect(new InetSocketAddress(host, port));
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, (SocketAddress)null);
    }

    @Override
    public void connect(SocketAddress remoteAddress, CompletionHandler<Connection> completionHandler) {
        this.connect(remoteAddress, null, completionHandler);
    }

    public GrizzlyFuture<Connection> connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connectAsync(remoteAddress, localAddress, null, true);
    }

    @Override
    public void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletionHandler<Connection> completionHandler) {
        this.connectAsync(remoteAddress, localAddress, completionHandler, false);
    }

    protected abstract FutureImpl<Connection> connectAsync(SocketAddress var1, SocketAddress var2, CompletionHandler<Connection> var3, boolean var4);

    public Processor getProcessor() {
        return this.processor;
    }

    public void setProcessor(Processor processor) {
        this.processor = processor;
    }

    public ProcessorSelector getProcessorSelector() {
        return this.processorSelector;
    }

    public void setProcessorSelector(ProcessorSelector processorSelector) {
        this.processorSelector = processorSelector;
    }

    public void addMonitoringProbe(ConnectionProbe probe) {
        this.probes.add(probe);
    }

    public boolean removeMonitoringProbe(ConnectionProbe probe) {
        return this.probes.remove(probe);
    }

    public ConnectionProbe[] getMonitoringProbes() {
        return this.probes.toArray(new ConnectionProbe[this.probes.size()]);
    }

    protected void preConfigure(Connection connection) {
    }

    protected FutureImpl<Connection> makeCancellableFuture(final Connection connection) {
        return new SafeFutureImpl<Connection>(){

            @Override
            protected void done() {
                try {
                    if (!this.isCancelled()) {
                        this.get();
                        return;
                    }
                }
                catch (Throwable ignored) {
                    // empty catch block
                }
                try {
                    connection.closeSilently();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
    }

    public static abstract class Builder<E extends Builder> {
        protected final AbstractSocketConnectorHandler connectorHandler;

        public Builder(AbstractSocketConnectorHandler connectorHandler) {
            this.connectorHandler = connectorHandler;
        }

        public E processor(Processor processor) {
            this.connectorHandler.setProcessor(processor);
            return (E)this;
        }

        public E processorSelector(ProcessorSelector processorSelector) {
            this.connectorHandler.setProcessorSelector(processorSelector);
            return (E)this;
        }

        public E probe(ConnectionProbe connectionProbe) {
            this.connectorHandler.addMonitoringProbe(connectionProbe);
            return (E)this;
        }
    }
}

