/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.kosmix.kosmosfs.access;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.hadoop.shaded.org.kosmix.kosmosfs.access.Positionable;

public class KfsInputChannel
implements ReadableByteChannel,
Positionable {
    private static final int DEFAULT_BUF_SIZE = 0x100000;
    private ByteBuffer readBuffer = ByteBuffer.allocateDirect(0x100000);
    private int kfsFd = -1;
    private long cPtr;

    private static final native int read(long var0, int var2, ByteBuffer var3, int var4, int var5);

    private static final native int close(long var0, int var2);

    private static final native int seek(long var0, int var2, long var3);

    private static final native long tell(long var0, int var2);

    public KfsInputChannel(long ptr, int fd) {
        this.readBuffer.flip();
        this.kfsFd = fd;
        this.cPtr = ptr;
    }

    @Override
    public boolean isOpen() {
        return this.kfsFd > 0;
    }

    @Override
    public int read(ByteBuffer dst) throws IOException {
        int r1;
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        int r0 = dst.remaining();
        while (dst.hasRemaining()) {
            if (!this.readBuffer.hasRemaining()) {
                this.readBuffer.clear();
                this.readDirect(this.readBuffer);
                this.readBuffer.flip();
                if (!this.readBuffer.hasRemaining()) break;
            }
            int lim = this.readBuffer.limit();
            if (dst.remaining() < this.readBuffer.remaining()) {
                this.readBuffer.limit(this.readBuffer.position() + dst.remaining());
            }
            dst.put(this.readBuffer);
            this.readBuffer.limit(lim);
        }
        if ((r1 = dst.remaining()) < r0 || r0 == 0) {
            return r0 - r1;
        }
        return -1;
    }

    private void readDirect(ByteBuffer buf) throws IOException {
        if (!buf.isDirect()) {
            throw new IllegalArgumentException("need direct buffer");
        }
        int pos = buf.position();
        int sz = KfsInputChannel.read(this.cPtr, this.kfsFd, buf, pos, buf.limit());
        if (sz < 0) {
            throw new IOException("readDirect failed");
        }
        buf.position(pos + sz);
    }

    @Override
    public int seek(long offset) throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        this.readBuffer.clear();
        this.readBuffer.flip();
        return KfsInputChannel.seek(this.cPtr, this.kfsFd, offset);
    }

    @Override
    public long tell() throws IOException {
        if (this.kfsFd < 0) {
            throw new IOException("File closed");
        }
        return KfsInputChannel.tell(this.cPtr, this.kfsFd) - (long)this.readBuffer.remaining();
    }

    @Override
    public void close() throws IOException {
        if (this.kfsFd < 0) {
            return;
        }
        KfsInputChannel.close(this.cPtr, this.kfsFd);
        this.kfsFd = -1;
    }

    protected void finalize() throws Throwable {
        if (this.kfsFd < 0) {
            return;
        }
        this.close();
    }
}

