/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.yarn.server.nodemanager.containermanager.linux.runtime.docker.DockerCommand;

public class DockerExecCommand
extends DockerCommand {
    private static final String EXEC_COMMAND = "exec";
    private final Map<String, String> userEnv;

    public DockerExecCommand(String containerId) {
        super(EXEC_COMMAND);
        super.addCommandArguments("name", containerId);
        this.userEnv = new LinkedHashMap<String, String>();
    }

    public DockerExecCommand setInteractive() {
        super.addCommandArguments("interactive", "true");
        return this;
    }

    public DockerExecCommand setTTY() {
        super.addCommandArguments("tty", "true");
        return this;
    }

    public DockerExecCommand setOverrideCommandWithArgs(List<String> overrideCommandWithArgs) {
        for (String override : overrideCommandWithArgs) {
            super.addCommandArguments("launch-command", override);
        }
        return this;
    }

    @Override
    public Map<String, List<String>> getDockerCommandWithArguments() {
        return super.getDockerCommandWithArguments();
    }
}

