/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.federation;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.retry.RetryPolicy;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.util.concurrent.HadoopExecutors;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.server.federation.retry.FederationActionRetry;
import org.apache.hadoop.yarn.server.federation.store.FederationStateStore;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.AddReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.ApplicationHomeSubCluster;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeletePoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeletePoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.DeleteSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetApplicationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationsHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetReservationsHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPoliciesConfigurationsResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoRequest;
import org.apache.hadoop.yarn.server.federation.store.records.GetSubClustersInfoResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterMasterKeyResponse;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenRequest;
import org.apache.hadoop.yarn.server.federation.store.records.RouterRMTokenResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SetSubClusterPolicyConfigurationResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterDeregisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterHeartbeatResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterId;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterInfo;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterRegisterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.SubClusterState;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateApplicationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterRequest;
import org.apache.hadoop.yarn.server.federation.store.records.UpdateReservationHomeSubClusterResponse;
import org.apache.hadoop.yarn.server.federation.utils.FederationStateStoreFacade;
import org.apache.hadoop.yarn.server.records.Version;
import org.apache.hadoop.yarn.server.resourcemanager.RMContext;
import org.apache.hadoop.yarn.server.resourcemanager.ResourceManager;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationClientMethod;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreHeartbeat;
import org.apache.hadoop.yarn.server.resourcemanager.federation.FederationStateStoreServiceMetrics;
import org.apache.hadoop.yarn.server.resourcemanager.rmapp.RMApp;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.MonotonicClock;
import org.apache.hadoop.yarn.webapp.util.WebAppUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FederationStateStoreService
extends AbstractService
implements FederationStateStore {
    public static final Logger LOG = LoggerFactory.getLogger(FederationStateStoreService.class);
    private Configuration config;
    private ScheduledExecutorService scheduledExecutorService;
    private FederationStateStoreHeartbeat stateStoreHeartbeat;
    private FederationStateStore stateStoreClient = null;
    private SubClusterId subClusterId;
    private long heartbeatInterval;
    private long heartbeatInitialDelay;
    private RMContext rmContext;
    private final Clock clock = new MonotonicClock();
    private FederationStateStoreServiceMetrics metrics;
    private String cleanUpThreadNamePrefix = "FederationStateStoreService-Clean-Thread";
    private int cleanUpRetryCountNum;
    private long cleanUpRetrySleepTime;

    public FederationStateStoreService(RMContext rmContext) {
        super(FederationStateStoreService.class.getName());
        LOG.info("FederationStateStoreService initialized");
        this.rmContext = rmContext;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.config = conf;
        RetryPolicy retryPolicy = FederationStateStoreFacade.createRetryPolicy(conf);
        this.stateStoreClient = (FederationStateStore)FederationStateStoreFacade.createRetryInstance(conf, "yarn.federation.state-store.class", "org.apache.hadoop.yarn.server.federation.store.impl.MemoryFederationStateStore", FederationStateStore.class, retryPolicy);
        this.stateStoreClient.init(conf);
        LOG.info("Initialized state store client class");
        this.subClusterId = SubClusterId.newInstance(YarnConfiguration.getClusterId((Configuration)conf));
        this.heartbeatInterval = conf.getLong("yarn.federation.state-store.heartbeat-interval-secs", 300L);
        if (this.heartbeatInterval <= 0L) {
            this.heartbeatInterval = 300L;
        }
        this.heartbeatInitialDelay = conf.getTimeDuration("yarn.federation.state-store.heartbeat.initial-delay", 30L, TimeUnit.SECONDS);
        if (this.heartbeatInitialDelay <= 0L) {
            LOG.warn("{} configured value is wrong, must be > 0; using default value of {}", (Object)"yarn.federation.state-store.heartbeat.initial-delay", (Object)30);
            this.heartbeatInitialDelay = 30L;
        }
        this.cleanUpRetryCountNum = conf.getInt("yarn.federation.state-store.clean-up-retry-count", 1);
        this.cleanUpRetrySleepTime = conf.getTimeDuration("yarn.federation.state-store.clean-up-retry-sleep-time", YarnConfiguration.DEFAULT_FEDERATION_STATESTORE_CLEANUP_RETRY_SLEEP_TIME, TimeUnit.MILLISECONDS);
        LOG.info("Initialized federation membership service.");
        this.metrics = FederationStateStoreServiceMetrics.getMetrics();
        LOG.info("Initialized federation statestore service metrics.");
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        this.registerAndInitializeHeartbeat();
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        Exception ex = null;
        try {
            if (this.scheduledExecutorService != null && !this.scheduledExecutorService.isShutdown()) {
                this.scheduledExecutorService.shutdown();
                LOG.info("Stopped federation membership heartbeat");
            }
        }
        catch (Exception e) {
            LOG.error("Failed to shutdown ScheduledExecutorService", (Throwable)e);
            ex = e;
        }
        if (this.stateStoreClient != null) {
            try {
                this.deregisterSubCluster(SubClusterDeregisterRequest.newInstance(this.subClusterId, SubClusterState.SC_UNREGISTERED));
            }
            finally {
                this.stateStoreClient.close();
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    private String getServiceAddress(InetSocketAddress address) {
        InetSocketAddress socketAddress = NetUtils.getConnectAddress((InetSocketAddress)address);
        return socketAddress.getAddress().getHostAddress() + ":" + socketAddress.getPort();
    }

    private void registerAndInitializeHeartbeat() {
        String clientRMAddress = this.getServiceAddress(this.rmContext.getClientRMService().getBindAddress());
        String amRMAddress = this.getServiceAddress(this.rmContext.getApplicationMasterService().getBindAddress());
        String rmAdminAddress = this.getServiceAddress(this.config.getSocketAddr("yarn.resourcemanager.admin.address", "0.0.0.0:8033", 8033));
        String webAppAddress = this.getServiceAddress(NetUtils.createSocketAddr((String)WebAppUtils.getRMWebAppURLWithScheme((Configuration)this.config)));
        SubClusterInfo subClusterInfo = SubClusterInfo.newInstance(this.subClusterId, amRMAddress, clientRMAddress, rmAdminAddress, webAppAddress, SubClusterState.SC_NEW, ResourceManager.getClusterTimeStamp(), "");
        try {
            this.registerSubCluster(SubClusterRegisterRequest.newInstance(subClusterInfo));
            LOG.info("Successfully registered for federation subcluster: {}", (Object)subClusterInfo);
        }
        catch (Exception e) {
            throw new YarnRuntimeException("Failed to register Federation membership with the StateStore", (Throwable)e);
        }
        this.stateStoreHeartbeat = new FederationStateStoreHeartbeat(this.subClusterId, this.stateStoreClient, this.rmContext.getScheduler());
        this.scheduledExecutorService = HadoopExecutors.newSingleThreadScheduledExecutor();
        this.scheduledExecutorService.scheduleWithFixedDelay(this.stateStoreHeartbeat, this.heartbeatInitialDelay, this.heartbeatInterval, TimeUnit.SECONDS);
        LOG.info("Started federation membership heartbeat with interval: {} and initial delay: {}", (Object)this.heartbeatInterval, (Object)this.heartbeatInitialDelay);
    }

    @VisibleForTesting
    public FederationStateStore getStateStoreClient() {
        return this.stateStoreClient;
    }

    @VisibleForTesting
    public FederationStateStoreHeartbeat getStateStoreHeartbeatThread() {
        return this.stateStoreHeartbeat;
    }

    @Override
    public Version getCurrentVersion() {
        return this.stateStoreClient.getCurrentVersion();
    }

    @Override
    public Version loadVersion() throws Exception {
        return this.stateStoreClient.getCurrentVersion();
    }

    @Override
    public void storeVersion() throws Exception {
        this.stateStoreClient.storeVersion();
    }

    @Override
    public void checkVersion() throws Exception {
        this.stateStoreClient.checkVersion();
    }

    @Override
    public void deleteStateStore() throws Exception {
        this.stateStoreClient.deleteStateStore();
    }

    @Override
    public GetSubClusterPolicyConfigurationResponse getPolicyConfiguration(GetSubClusterPolicyConfigurationRequest request) throws YarnException {
        FederationClientMethod<GetSubClusterPolicyConfigurationResponse> clientMethod = new FederationClientMethod<GetSubClusterPolicyConfigurationResponse>("getPolicyConfiguration", GetSubClusterPolicyConfigurationRequest.class, (Object)request, GetSubClusterPolicyConfigurationResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public SetSubClusterPolicyConfigurationResponse setPolicyConfiguration(SetSubClusterPolicyConfigurationRequest request) throws YarnException {
        FederationClientMethod<SetSubClusterPolicyConfigurationResponse> clientMethod = new FederationClientMethod<SetSubClusterPolicyConfigurationResponse>("setPolicyConfiguration", SetSubClusterPolicyConfigurationRequest.class, (Object)request, SetSubClusterPolicyConfigurationResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetSubClusterPoliciesConfigurationsResponse getPoliciesConfigurations(GetSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        FederationClientMethod<GetSubClusterPoliciesConfigurationsResponse> clientMethod = new FederationClientMethod<GetSubClusterPoliciesConfigurationsResponse>("getPoliciesConfigurations", GetSubClusterPoliciesConfigurationsRequest.class, (Object)request, GetSubClusterPoliciesConfigurationsResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public DeleteSubClusterPoliciesConfigurationsResponse deletePoliciesConfigurations(DeleteSubClusterPoliciesConfigurationsRequest request) throws YarnException {
        FederationClientMethod<DeleteSubClusterPoliciesConfigurationsResponse> clientMethod = new FederationClientMethod<DeleteSubClusterPoliciesConfigurationsResponse>("deletePoliciesConfigurations", DeleteSubClusterPoliciesConfigurationsRequest.class, (Object)request, DeleteSubClusterPoliciesConfigurationsResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public DeletePoliciesConfigurationsResponse deleteAllPoliciesConfigurations(DeletePoliciesConfigurationsRequest request) throws Exception {
        FederationClientMethod<DeletePoliciesConfigurationsResponse> clientMethod = new FederationClientMethod<DeletePoliciesConfigurationsResponse>("deleteAllPoliciesConfigurations", DeletePoliciesConfigurationsRequest.class, (Object)request, DeletePoliciesConfigurationsResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public SubClusterRegisterResponse registerSubCluster(SubClusterRegisterRequest request) throws YarnException {
        FederationClientMethod<SubClusterRegisterResponse> clientMethod = new FederationClientMethod<SubClusterRegisterResponse>("registerSubCluster", SubClusterRegisterRequest.class, (Object)request, SubClusterRegisterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public SubClusterDeregisterResponse deregisterSubCluster(SubClusterDeregisterRequest request) throws YarnException {
        FederationClientMethod<SubClusterDeregisterResponse> clientMethod = new FederationClientMethod<SubClusterDeregisterResponse>("deregisterSubCluster", SubClusterDeregisterRequest.class, (Object)request, SubClusterDeregisterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public SubClusterHeartbeatResponse subClusterHeartbeat(SubClusterHeartbeatRequest request) throws YarnException {
        FederationClientMethod<SubClusterHeartbeatResponse> clientMethod = new FederationClientMethod<SubClusterHeartbeatResponse>("subClusterHeartbeat", SubClusterHeartbeatRequest.class, (Object)request, SubClusterHeartbeatResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetSubClusterInfoResponse getSubCluster(GetSubClusterInfoRequest request) throws YarnException {
        FederationClientMethod<GetSubClusterInfoResponse> clientMethod = new FederationClientMethod<GetSubClusterInfoResponse>("getSubCluster", GetSubClusterInfoRequest.class, (Object)request, GetSubClusterInfoResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetSubClustersInfoResponse getSubClusters(GetSubClustersInfoRequest request) throws YarnException {
        FederationClientMethod<GetSubClustersInfoResponse> clientMethod = new FederationClientMethod<GetSubClustersInfoResponse>("getSubClusters", GetSubClustersInfoRequest.class, (Object)request, GetSubClustersInfoResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public AddApplicationHomeSubClusterResponse addApplicationHomeSubCluster(AddApplicationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<AddApplicationHomeSubClusterResponse> clientMethod = new FederationClientMethod<AddApplicationHomeSubClusterResponse>("addApplicationHomeSubCluster", AddApplicationHomeSubClusterRequest.class, (Object)request, AddApplicationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public UpdateApplicationHomeSubClusterResponse updateApplicationHomeSubCluster(UpdateApplicationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<UpdateApplicationHomeSubClusterResponse> clientMethod = new FederationClientMethod<UpdateApplicationHomeSubClusterResponse>("updateApplicationHomeSubCluster", AddApplicationHomeSubClusterRequest.class, (Object)request, UpdateApplicationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetApplicationHomeSubClusterResponse getApplicationHomeSubCluster(GetApplicationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<GetApplicationHomeSubClusterResponse> clientMethod = new FederationClientMethod<GetApplicationHomeSubClusterResponse>("getApplicationHomeSubCluster", GetApplicationHomeSubClusterRequest.class, (Object)request, GetApplicationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetApplicationsHomeSubClusterResponse getApplicationsHomeSubCluster(GetApplicationsHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<GetApplicationsHomeSubClusterResponse> clientMethod = new FederationClientMethod<GetApplicationsHomeSubClusterResponse>("getApplicationsHomeSubCluster", GetApplicationsHomeSubClusterRequest.class, (Object)request, GetApplicationsHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public DeleteApplicationHomeSubClusterResponse deleteApplicationHomeSubCluster(DeleteApplicationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<DeleteApplicationHomeSubClusterResponse> clientMethod = new FederationClientMethod<DeleteApplicationHomeSubClusterResponse>("deleteApplicationHomeSubCluster", DeleteApplicationHomeSubClusterRequest.class, (Object)request, DeleteApplicationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public AddReservationHomeSubClusterResponse addReservationHomeSubCluster(AddReservationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<AddReservationHomeSubClusterResponse> clientMethod = new FederationClientMethod<AddReservationHomeSubClusterResponse>("addReservationHomeSubCluster", AddReservationHomeSubClusterRequest.class, (Object)request, AddReservationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetReservationHomeSubClusterResponse getReservationHomeSubCluster(GetReservationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<GetReservationHomeSubClusterResponse> clientMethod = new FederationClientMethod<GetReservationHomeSubClusterResponse>("getReservationHomeSubCluster", GetReservationHomeSubClusterRequest.class, (Object)request, GetReservationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public GetReservationsHomeSubClusterResponse getReservationsHomeSubCluster(GetReservationsHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<GetReservationsHomeSubClusterResponse> clientMethod = new FederationClientMethod<GetReservationsHomeSubClusterResponse>("getReservationsHomeSubCluster", GetReservationsHomeSubClusterRequest.class, (Object)request, GetReservationsHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public UpdateReservationHomeSubClusterResponse updateReservationHomeSubCluster(UpdateReservationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<UpdateReservationHomeSubClusterResponse> clientMethod = new FederationClientMethod<UpdateReservationHomeSubClusterResponse>("updateReservationHomeSubCluster", GetReservationsHomeSubClusterRequest.class, (Object)request, UpdateReservationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public DeleteReservationHomeSubClusterResponse deleteReservationHomeSubCluster(DeleteReservationHomeSubClusterRequest request) throws YarnException {
        FederationClientMethod<DeleteReservationHomeSubClusterResponse> clientMethod = new FederationClientMethod<DeleteReservationHomeSubClusterResponse>("deleteReservationHomeSubCluster", DeleteReservationHomeSubClusterRequest.class, (Object)request, DeleteReservationHomeSubClusterResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterMasterKeyResponse storeNewMasterKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterMasterKeyResponse> clientMethod = new FederationClientMethod<RouterMasterKeyResponse>("storeNewMasterKey", RouterMasterKeyRequest.class, (Object)request, RouterMasterKeyResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterMasterKeyResponse removeStoredMasterKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterMasterKeyResponse> clientMethod = new FederationClientMethod<RouterMasterKeyResponse>("removeStoredMasterKey", RouterMasterKeyRequest.class, (Object)request, RouterMasterKeyResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterMasterKeyResponse getMasterKeyByDelegationKey(RouterMasterKeyRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterMasterKeyResponse> clientMethod = new FederationClientMethod<RouterMasterKeyResponse>("getMasterKeyByDelegationKey", RouterMasterKeyRequest.class, (Object)request, RouterMasterKeyResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterRMTokenResponse storeNewToken(RouterRMTokenRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterRMTokenResponse> clientMethod = new FederationClientMethod<RouterRMTokenResponse>("storeNewToken", RouterRMTokenRequest.class, (Object)request, RouterRMTokenResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterRMTokenResponse updateStoredToken(RouterRMTokenRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterRMTokenResponse> clientMethod = new FederationClientMethod<RouterRMTokenResponse>("updateStoredToken", RouterRMTokenRequest.class, (Object)request, RouterRMTokenResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterRMTokenResponse removeStoredToken(RouterRMTokenRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterRMTokenResponse> clientMethod = new FederationClientMethod<RouterRMTokenResponse>("removeStoredToken", RouterRMTokenRequest.class, (Object)request, RouterRMTokenResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public RouterRMTokenResponse getTokenByRouterStoreToken(RouterRMTokenRequest request) throws YarnException, IOException {
        FederationClientMethod<RouterRMTokenResponse> clientMethod = new FederationClientMethod<RouterRMTokenResponse>("getTokenByRouterStoreToken", RouterRMTokenRequest.class, (Object)request, RouterRMTokenResponse.class, this.stateStoreClient, this.clock);
        return clientMethod.invoke();
    }

    @Override
    public int incrementDelegationTokenSeqNum() {
        return this.stateStoreClient.incrementDelegationTokenSeqNum();
    }

    @Override
    public int getDelegationTokenSeqNum() {
        return this.stateStoreClient.getDelegationTokenSeqNum();
    }

    @Override
    public void setDelegationTokenSeqNum(int seqNum) {
        this.stateStoreClient.setDelegationTokenSeqNum(seqNum);
    }

    @Override
    public int getCurrentKeyId() {
        return this.stateStoreClient.getCurrentKeyId();
    }

    @Override
    public int incrementCurrentKeyId() {
        return this.stateStoreClient.incrementCurrentKeyId();
    }

    public void createCleanUpFinishApplicationThread(String stage) {
        String threadName = this.cleanUpThreadNamePrefix + "-" + stage;
        Thread finishApplicationThread = new Thread(this.createCleanUpFinishApplicationThread());
        finishApplicationThread.setName(threadName);
        finishApplicationThread.start();
        LOG.info("CleanUpFinishApplicationThread has been started {}.", (Object)threadName);
    }

    private Runnable createCleanUpFinishApplicationThread() {
        return () -> this.createCleanUpFinishApplication();
    }

    private void createCleanUpFinishApplication() {
        try {
            GetApplicationsHomeSubClusterRequest request = GetApplicationsHomeSubClusterRequest.newInstance(this.subClusterId);
            GetApplicationsHomeSubClusterResponse response = this.getApplicationsHomeSubCluster(request);
            List<ApplicationHomeSubCluster> applicationHomeSCs = response.getAppsHomeSubClusters();
            long successCleanUpAppCount = 0L;
            HashMap<ApplicationId, RMApp> rmApps = new HashMap<ApplicationId, RMApp>(this.rmContext.getRMApps());
            if (rmApps != null && !rmApps.isEmpty()) {
                for (ApplicationHomeSubCluster applicationHomeSC : applicationHomeSCs) {
                    ApplicationId applicationId = applicationHomeSC.getApplicationId();
                    if (rmApps.containsKey(applicationId)) continue;
                    try {
                        Boolean cleanUpSuccess = this.cleanUpFinishApplicationsWithRetries(applicationId, false);
                        if (!cleanUpSuccess.booleanValue()) continue;
                        LOG.info("application = {} has been cleaned up successfully.", (Object)applicationId);
                        ++successCleanUpAppCount;
                    }
                    catch (Exception e) {
                        LOG.error("problem during application = {} cleanup.", (Object)applicationId, (Object)e);
                    }
                }
            }
            LOG.info("cleanup finished applications size = {}, number = {} successful cleanup.", (Object)applicationHomeSCs.size(), (Object)successCleanUpAppCount);
        }
        catch (Exception e) {
            LOG.error("problem during cleanup applications.", (Throwable)e);
        }
    }

    public boolean cleanUpFinishApplicationsWithRetries(ApplicationId appId, boolean isQuery) throws Exception {
        DeleteApplicationHomeSubClusterRequest req = DeleteApplicationHomeSubClusterRequest.newInstance(appId);
        return ((FederationActionRetry<Boolean>)retry -> this.invokeCleanUpFinishApp(appId, isQuery, req)).runWithRetries(this.cleanUpRetryCountNum, this.cleanUpRetrySleepTime);
    }

    private boolean invokeCleanUpFinishApp(ApplicationId applicationId, boolean isQuery, DeleteApplicationHomeSubClusterRequest delRequest) throws YarnException {
        DeleteApplicationHomeSubClusterResponse response;
        boolean isAppNeedClean = true;
        if (isQuery) {
            isAppNeedClean = this.isApplicationNeedClean(applicationId);
        }
        if (isAppNeedClean && (response = this.deleteApplicationHomeSubCluster(delRequest)) != null) {
            LOG.info("The applicationId = {} has been successfully cleaned up.", (Object)applicationId);
            return true;
        }
        return false;
    }

    private boolean isApplicationNeedClean(ApplicationId applicationId) {
        block4: {
            GetApplicationHomeSubClusterRequest queryRequest = GetApplicationHomeSubClusterRequest.newInstance(applicationId);
            try {
                GetApplicationHomeSubClusterResponse queryResp = this.getApplicationHomeSubCluster(queryRequest);
                if (queryResp != null) {
                    ApplicationHomeSubCluster appHomeSC = queryResp.getApplicationHomeSubCluster();
                    SubClusterId homeSubClusterId = appHomeSC.getHomeSubCluster();
                    if (!this.subClusterId.equals(homeSubClusterId)) {
                        LOG.warn("The homeSubCluster of applicationId = {} belong subCluster = {},  not belong subCluster = {} and is not allowed to delete.", new Object[]{applicationId, homeSubClusterId, this.subClusterId});
                        return false;
                    }
                    break block4;
                }
                LOG.warn("The applicationId = {} not belong subCluster = {}  and is not allowed to delete.", (Object)applicationId, (Object)this.subClusterId);
                return false;
            }
            catch (Exception e) {
                LOG.warn("query applicationId = {} error.", (Object)applicationId, (Object)e);
                return false;
            }
        }
        return true;
    }
}

