/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.reservation;

import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ReservationId;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.NoOverCommitPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.Plan;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.RLESparseResourceAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationAllocation;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.ReservationSchedulerConfiguration;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningException;
import org.apache.hadoop.yarn.server.resourcemanager.reservation.exceptions.PlanningQuotaException;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.LimitedPrivate(value={"yarn"})
@InterfaceStability.Unstable
public class CapacityOverTimePolicy
extends NoOverCommitPolicy {
    private ReservationSchedulerConfiguration conf;
    private long validWindow;
    private float maxInst;
    private float maxAvg;

    @Override
    public void init(String reservationQueuePath, ReservationSchedulerConfiguration conf) {
        this.conf = conf;
        this.validWindow = this.conf.getReservationWindow(reservationQueuePath);
        this.maxInst = this.conf.getInstantaneousMaxCapacity(reservationQueuePath) / 100.0f;
        this.maxAvg = this.conf.getAverageCapacity(reservationQueuePath) / 100.0f;
    }

    @Override
    public void validate(Plan plan, ReservationAllocation reservation) throws PlanningException {
        try {
            super.validate(plan, reservation);
        }
        catch (PlanningException p) {
            throw new PlanningQuotaException(p);
        }
        long checkStart = reservation.getStartTime() - this.validWindow;
        long checkEnd = reservation.getEndTime() + this.validWindow;
        RLESparseResourceAllocation consumptionForUserOverTime = plan.getConsumptionForUserOverTime(reservation.getUser(), checkStart, checkEnd);
        ReservationAllocation old = plan.getReservationById(reservation.getReservationId());
        if (old != null) {
            consumptionForUserOverTime = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), consumptionForUserOverTime, old.getResourcesOverTime(checkStart, checkEnd), RLESparseResourceAllocation.RLEOperator.add, checkStart, checkEnd);
        }
        RLESparseResourceAllocation resRLE = reservation.getResourcesOverTime(checkStart, checkEnd);
        RLESparseResourceAllocation toCheck = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), consumptionForUserOverTime, resRLE, RLESparseResourceAllocation.RLEOperator.add, Long.MIN_VALUE, Long.MAX_VALUE);
        TreeMap<Long, Resource> integralUp = new TreeMap<Long, Resource>();
        TreeMap<Long, Resource> integralDown = new TreeMap<Long, Resource>();
        long prevTime = toCheck.getEarliestStartTime();
        IntegralResource prevResource = new IntegralResource(0L, 0L);
        IntegralResource runningTot = new IntegralResource(0L, 0L);
        TreeMap<Long, Resource> temp = new TreeMap<Long, Resource>();
        for (Map.Entry pointToCheck : toCheck.getCumulative().entrySet()) {
            Long timeToCheck = (Long)pointToCheck.getKey();
            Resource resourceToCheck = (Resource)pointToCheck.getValue();
            Long nextPoint = toCheck.getCumulative().higherKey(timeToCheck);
            if (nextPoint == null || toCheck.getCumulative().get(nextPoint) == null) continue;
            int i = 1;
            while ((long)i <= (nextPoint - timeToCheck) / this.validWindow) {
                temp.put(timeToCheck + (long)i * this.validWindow, resourceToCheck);
                ++i;
            }
        }
        temp.putAll(toCheck.getCumulative());
        for (Map.Entry currPoint : temp.entrySet()) {
            Long currTime = (Long)currPoint.getKey();
            Resource currResource = (Resource)currPoint.getValue();
            prevResource.multiplyBy(currTime - prevTime);
            runningTot.add(prevResource);
            integralUp.put(currTime, this.normalizeToResource(runningTot, this.validWindow));
            integralDown.put(currTime + this.validWindow, this.normalizeToResource(runningTot, this.validWindow));
            if (currResource != null) {
                prevResource.memory = currResource.getMemorySize();
                prevResource.vcores = currResource.getVirtualCores();
            } else {
                prevResource.memory = 0L;
                prevResource.vcores = 0L;
            }
            prevTime = currTime;
        }
        RLESparseResourceAllocation intUp = new RLESparseResourceAllocation(integralUp, plan.getResourceCalculator());
        RLESparseResourceAllocation intDown = new RLESparseResourceAllocation(integralDown, plan.getResourceCalculator());
        RLESparseResourceAllocation integral = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), intUp, intDown, RLESparseResourceAllocation.RLEOperator.subtract, Long.MIN_VALUE, Long.MAX_VALUE);
        TreeMap<Long, Resource> tlimit = new TreeMap<Long, Resource>();
        Resource maxAvgRes = Resources.multiply((Resource)plan.getTotalCapacity(), (double)this.maxAvg);
        tlimit.put(toCheck.getEarliestStartTime() - this.validWindow, maxAvgRes);
        RLESparseResourceAllocation targetLimit = new RLESparseResourceAllocation(tlimit, plan.getResourceCalculator());
        try {
            RLESparseResourceAllocation.merge(plan.getResourceCalculator(), plan.getTotalCapacity(), targetLimit, integral, RLESparseResourceAllocation.RLEOperator.subtractTestNonNegative, checkStart, checkEnd);
        }
        catch (PlanningException p) {
            throw new PlanningQuotaException("Integral (avg over time) quota capacity " + this.maxAvg + " over a window of " + this.validWindow / 1000L + " seconds,  would be exceeded by accepting reservation: " + reservation.getReservationId(), p);
        }
    }

    private Resource normalizeToResource(IntegralResource runningTot, long window) {
        int memory = (int)Math.round((double)runningTot.memory / (double)window);
        int vcores = (int)Math.round((double)runningTot.vcores / (double)window);
        return Resource.newInstance((int)memory, (int)vcores);
    }

    @Override
    public RLESparseResourceAllocation availableResources(RLESparseResourceAllocation available, Plan plan, String user, ReservationId oldId, long start, long end) throws PlanningException {
        Resource planTotalCapacity = plan.getTotalCapacity();
        Resource maxInsRes = Resources.multiply((Resource)planTotalCapacity, (double)this.maxInst);
        TreeMap<Long, Resource> instQuota = new TreeMap<Long, Resource>();
        instQuota.put(start, maxInsRes);
        RLESparseResourceAllocation instRLEQuota = new RLESparseResourceAllocation(instQuota, plan.getResourceCalculator());
        RLESparseResourceAllocation used = plan.getConsumptionForUserOverTime(user, start, end);
        ReservationAllocation old = plan.getReservationById(oldId);
        if (old != null) {
            used = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), Resources.clone((Resource)plan.getTotalCapacity()), used, old.getResourcesOverTime(start, end), RLESparseResourceAllocation.RLEOperator.subtract, start, end);
        }
        instRLEQuota = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), planTotalCapacity, instRLEQuota, used, RLESparseResourceAllocation.RLEOperator.subtract, start, end);
        instRLEQuota = RLESparseResourceAllocation.merge(plan.getResourceCalculator(), planTotalCapacity, available, instRLEQuota, RLESparseResourceAllocation.RLEOperator.min, start, end);
        return instRLEQuota;
    }

    @Override
    public long getValidWindow() {
        return this.validWindow;
    }

    private static class IntegralResource {
        long memory;
        long vcores;

        public IntegralResource(Resource resource) {
            this.memory = resource.getMemorySize();
            this.vcores = resource.getVirtualCores();
        }

        public IntegralResource(long mem, long vcores) {
            this.memory = mem;
            this.vcores = vcores;
        }

        public void add(Resource r) {
            this.memory += r.getMemorySize();
            this.vcores += (long)r.getVirtualCores();
        }

        public void add(IntegralResource r) {
            this.memory += r.memory;
            this.vcores += r.vcores;
        }

        public void subtract(Resource r) {
            this.memory -= r.getMemorySize();
            this.vcores -= (long)r.getVirtualCores();
        }

        public IntegralResource negate() {
            return new IntegralResource(-this.memory, -this.vcores);
        }

        public void multiplyBy(long window) {
            this.memory *= window;
            this.vcores *= window;
        }

        public long compareTo(IntegralResource other) {
            long diff = this.memory - other.memory;
            if (diff == 0L) {
                diff = this.vcores - other.vcores;
            }
            return diff;
        }

        public String toString() {
            return "<memory:" + this.memory + ", vCores:" + this.vcores + ">";
        }
    }
}

