/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.placement;

import java.io.IOException;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.yarn.api.records.ApplicationSubmissionContext;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.server.resourcemanager.placement.ApplicationPlacementContext;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FSPlacementRule;
import org.apache.hadoop.yarn.server.resourcemanager.placement.FairQueuePlacementUtils;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.ResourceScheduler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class SpecifiedPlacementRule
extends FSPlacementRule {
    private static final Logger LOG = LoggerFactory.getLogger(SpecifiedPlacementRule.class);

    @Override
    public boolean initialize(ResourceScheduler scheduler) throws IOException {
        super.initialize(scheduler);
        if (this.getParentRule() != null) {
            throw new IOException("Parent rule should not be configured for Specified rule.");
        }
        return true;
    }

    @Override
    public ApplicationPlacementContext getPlacementForApp(ApplicationSubmissionContext asc, String user) throws YarnException {
        String queueName = asc.getQueue();
        if (!FairQueuePlacementUtils.isValidQueueName(queueName)) {
            LOG.error("Specified queue name not valid: '{}'", (Object)queueName);
            throw new YarnException("Application submitted by user " + user + "with illegal queue name '" + queueName + "'.");
        }
        if (queueName.equals("default")) {
            return null;
        }
        queueName = FairQueuePlacementUtils.assureRoot(queueName);
        if (this.createQueue || this.configuredQueue(queueName)) {
            return new ApplicationPlacementContext(queueName);
        }
        return null;
    }
}

