/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity;

import java.util.Set;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.CalculationContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.QueueCapacityVector;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.capacity.ResourceCalculationDriver;

public abstract class AbstractQueueCapacityCalculator {
    public abstract void updateCapacitiesAfterCalculation(ResourceCalculationDriver var1, CSQueue var2, String var3);

    public abstract QueueCapacityVector.ResourceUnitCapacityType getCapacityType();

    public abstract double calculateMinimumResource(ResourceCalculationDriver var1, CalculationContext var2, String var3);

    public abstract double calculateMaximumResource(ResourceCalculationDriver var1, CalculationContext var2, String var3);

    public abstract void calculateResourcePrerequisites(ResourceCalculationDriver var1);

    protected Set<String> getResourceNames(CSQueue queue, String label) {
        return this.getResourceNames(queue, label, this.getCapacityType());
    }

    protected Set<String> getResourceNames(CSQueue queue, String label, QueueCapacityVector.ResourceUnitCapacityType capacityType) {
        return queue.getConfiguredCapacityVector(label).getResourceNamesByCapacityType(capacityType);
    }
}

