/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.apache.commons.math3.util.Precision;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.NodeId;
import org.apache.hadoop.yarn.api.records.NodeState;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceOption;
import org.apache.hadoop.yarn.server.api.protocolrecords.NMContainerStatus;
import org.apache.hadoop.yarn.server.api.records.OpportunisticContainersStatus;
import org.apache.hadoop.yarn.server.resourcemanager.ClusterMonitor;
import org.apache.hadoop.yarn.server.resourcemanager.rmnode.RMNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.ClusterNode;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.distributed.QueueLimitCalculator;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NodeQueueLoadMonitor
implements ClusterMonitor {
    protected static final Logger LOG = LoggerFactory.getLogger(NodeQueueLoadMonitor.class);
    protected int numNodesForAnyAllocation = 10;
    private final ScheduledExecutorService scheduledExecutor;
    protected final List<NodeId> sortedNodes;
    protected final Map<NodeId, ClusterNode> clusterNodes = new ConcurrentHashMap<NodeId, ClusterNode>();
    protected final Map<String, RMNode> nodeByHostName = new ConcurrentHashMap<String, RMNode>();
    protected final Map<String, Set<NodeId>> nodeIdsByRack = new ConcurrentHashMap<String, Set<NodeId>>();
    protected final LoadComparator comparator;
    protected QueueLimitCalculator thresholdCalculator;
    protected ReentrantReadWriteLock sortedNodesLock = new ReentrantReadWriteLock();
    protected ReentrantReadWriteLock clusterNodesLock = new ReentrantReadWriteLock();
    Runnable computeTask = new Runnable(){

        @Override
        public void run() {
            ReentrantReadWriteLock.WriteLock writeLock = NodeQueueLoadMonitor.this.sortedNodesLock.writeLock();
            writeLock.lock();
            try {
                try {
                    NodeQueueLoadMonitor.this.updateSortedNodes();
                }
                catch (Exception ex) {
                    LOG.warn("Got Exception while sorting nodes..", (Throwable)ex);
                }
                if (NodeQueueLoadMonitor.this.thresholdCalculator != null) {
                    NodeQueueLoadMonitor.this.thresholdCalculator.update();
                }
            }
            finally {
                writeLock.unlock();
            }
        }
    };

    @VisibleForTesting
    NodeQueueLoadMonitor(LoadComparator comparator) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.comparator = comparator;
        this.scheduledExecutor = null;
    }

    public NodeQueueLoadMonitor(long nodeComputationInterval, LoadComparator comparator, int numNodes) {
        this.sortedNodes = new ArrayList<NodeId>();
        this.scheduledExecutor = Executors.newScheduledThreadPool(1);
        this.comparator = comparator;
        this.scheduledExecutor.scheduleAtFixedRate(this.computeTask, nodeComputationInterval, nodeComputationInterval, TimeUnit.MILLISECONDS);
        this.numNodesForAnyAllocation = numNodes;
    }

    protected void updateSortedNodes() {
        List nodeIds = this.sortNodes(true).stream().map(n -> n.nodeId).collect(Collectors.toList());
        this.sortedNodes.clear();
        this.sortedNodes.addAll(nodeIds);
    }

    List<NodeId> getSortedNodes() {
        return this.sortedNodes;
    }

    public QueueLimitCalculator getThresholdCalculator() {
        return this.thresholdCalculator;
    }

    public void stop() {
        if (this.scheduledExecutor != null) {
            this.scheduledExecutor.shutdown();
        }
    }

    Map<NodeId, ClusterNode> getClusterNodes() {
        return this.clusterNodes;
    }

    Comparator<ClusterNode> getComparator() {
        return this.comparator;
    }

    public void initThresholdCalculator(float sigma, int limitMin, int limitMax) {
        this.thresholdCalculator = new QueueLimitCalculator(this, sigma, limitMin, limitMax);
    }

    @Override
    public void addNode(List<NMContainerStatus> containerStatuses, RMNode rmNode) {
        this.nodeByHostName.put(rmNode.getHostName(), rmNode);
        this.addIntoNodeIdsByRack(rmNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeNode(RMNode removedRMNode) {
        ClusterNode node;
        LOG.info("Node delete event for: {}", (Object)removedRMNode.getNode().getName());
        this.nodeByHostName.remove(removedRMNode.getHostName());
        this.removeFromNodeIdsByRack(removedRMNode);
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            node = this.clusterNodes.remove(removedRMNode.getNodeID());
            this.onNodeRemoved(node);
        }
        finally {
            writeLock.unlock();
        }
        if (LOG.isDebugEnabled()) {
            if (node != null) {
                LOG.debug("Delete ClusterNode: " + removedRMNode.getNodeID());
            } else {
                LOG.debug("Node not in list!");
            }
        }
    }

    protected void onNodeRemoved(ClusterNode node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateNode(RMNode rmNode) {
        LOG.debug("Node update event from: {}", (Object)rmNode.getNodeID());
        OpportunisticContainersStatus opportunisticContainersStatus = rmNode.getOpportunisticContainersStatus();
        if (opportunisticContainersStatus == null) {
            opportunisticContainersStatus = OpportunisticContainersStatus.newInstance();
        }
        ReentrantReadWriteLock.WriteLock writeLock = this.clusterNodesLock.writeLock();
        writeLock.lock();
        try {
            ClusterNode clusterNode = this.clusterNodes.get(rmNode.getNodeID());
            if (clusterNode == null) {
                this.onNewNodeAdded(rmNode, opportunisticContainersStatus);
            } else {
                this.onExistingNodeUpdated(rmNode, clusterNode, opportunisticContainersStatus);
            }
        }
        finally {
            writeLock.unlock();
        }
    }

    protected void onNewNodeAdded(RMNode rmNode, OpportunisticContainersStatus status) {
        int opportQueueCapacity = status.getOpportQueueCapacity();
        int estimatedQueueWaitTime = status.getEstimatedQueueWaitTime();
        int waitQueueLength = status.getWaitQueueLength();
        if (rmNode.getState() != NodeState.DECOMMISSIONING && (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH || this.comparator == LoadComparator.QUEUE_LENGTH_THEN_RESOURCES)) {
            ClusterNode.Properties properties = ClusterNode.Properties.newInstance().setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength).setNodeLabels(rmNode.getNodeLabels()).setCapability(rmNode.getTotalCapability()).setAllocatedResource(rmNode.getAllocatedContainerResource()).setQueueCapacity(opportQueueCapacity).updateTimestamp();
            this.clusterNodes.put(rmNode.getNodeID(), new ClusterNode(rmNode.getNodeID()).setProperties(properties));
            LOG.info("Inserting ClusterNode [{}] with queue wait time [{}] and wait queue length [{}]", new Object[]{rmNode.getNode(), estimatedQueueWaitTime, waitQueueLength});
        } else {
            LOG.warn("IGNORING ClusterNode [{}] with queue wait time [{}] and wait queue length [{}]", new Object[]{rmNode.getNode(), estimatedQueueWaitTime, waitQueueLength});
        }
    }

    protected void onExistingNodeUpdated(RMNode rmNode, ClusterNode clusterNode, OpportunisticContainersStatus status) {
        int estimatedQueueWaitTime = status.getEstimatedQueueWaitTime();
        int waitQueueLength = status.getWaitQueueLength();
        if (rmNode.getState() != NodeState.DECOMMISSIONING && (estimatedQueueWaitTime != -1 || this.comparator == LoadComparator.QUEUE_LENGTH || this.comparator == LoadComparator.QUEUE_LENGTH_THEN_RESOURCES)) {
            ClusterNode.Properties properties = ClusterNode.Properties.newInstance().setQueueWaitTime(estimatedQueueWaitTime).setQueueLength(waitQueueLength).setNodeLabels(rmNode.getNodeLabels()).setCapability(rmNode.getTotalCapability()).setAllocatedResource(rmNode.getAllocatedContainerResource()).updateTimestamp();
            clusterNode.setProperties(properties);
            LOG.debug("Updating ClusterNode [{}] with queue wait time [{}] and wait queue length [{}]", new Object[]{rmNode.getNodeID(), estimatedQueueWaitTime, waitQueueLength});
        } else {
            this.clusterNodes.remove(rmNode.getNodeID());
            LOG.info("Deleting ClusterNode [" + rmNode.getNodeID() + "] with queue wait time [" + clusterNode.getQueueWaitTime() + "] and wait queue length [" + clusterNode.getQueueLength() + "]");
        }
    }

    @Override
    public void updateNodeResource(RMNode rmNode, ResourceOption resourceOption) {
        LOG.debug("Node resource update event from: {}", (Object)rmNode.getNodeID());
    }

    public List<NodeId> selectNodes() {
        return this.selectLeastLoadedNodes(-1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NodeId> selectLeastLoadedNodes(int k) {
        ReentrantReadWriteLock.ReadLock readLock = this.sortedNodesLock.readLock();
        readLock.lock();
        try {
            ArrayList<NodeId> retVal;
            ArrayList<NodeId> arrayList = retVal = k < this.sortedNodes.size() && k >= 0 ? new ArrayList<NodeId>(this.sortedNodes).subList(0, k) : new ArrayList<NodeId>(this.sortedNodes);
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public RMNode selectLocalNode(String hostName, Set<String> blacklist, Resource request) {
        ClusterNode clusterNode;
        if (blacklist.contains(hostName)) {
            return null;
        }
        RMNode node = this.nodeByHostName.get(hostName);
        if (node != null && (clusterNode = this.clusterNodes.get(node.getNodeID())) != null && this.comparator.compareAndIncrement(clusterNode, 1, request)) {
            return node;
        }
        return null;
    }

    public RMNode selectRackLocalNode(String rackName, Set<String> blacklist, Resource request) {
        Set<NodeId> nodesOnRack = this.nodeIdsByRack.get(rackName);
        if (nodesOnRack != null) {
            for (NodeId nodeId : nodesOnRack) {
                ClusterNode node;
                if (blacklist.contains(nodeId.getHost()) || (node = this.clusterNodes.get(nodeId)) == null || !this.comparator.compareAndIncrement(node, 1, request)) continue;
                return this.nodeByHostName.get(nodeId.getHost());
            }
        }
        return null;
    }

    public RMNode selectAnyNode(Set<String> blacklist, Resource request) {
        List<NodeId> nodeIds = this.getCandidatesForSelectAnyNode();
        int size = nodeIds.size();
        if (size <= 0) {
            return null;
        }
        Random rand = new Random();
        int startIndex = rand.nextInt(size);
        for (int i = 0; i < size; ++i) {
            ClusterNode node;
            int index = i + startIndex;
            NodeId nodeId = nodeIds.get(index %= size);
            if (nodeId == null || blacklist.contains(nodeId.getHost()) || (node = this.clusterNodes.get(nodeId)) == null || !this.comparator.compareAndIncrement(node, 1, request)) continue;
            return this.nodeByHostName.get(nodeId.getHost());
        }
        return null;
    }

    protected List<NodeId> getCandidatesForSelectAnyNode() {
        return this.selectLeastLoadedNodes(this.numNodesForAnyAllocation);
    }

    protected void removeFromNodeIdsByRack(RMNode removedNode) {
        this.nodeIdsByRack.computeIfPresent(removedNode.getRackName(), (k, v) -> {
            v.remove(removedNode.getNodeID());
            return v;
        });
    }

    protected void addIntoNodeIdsByRack(RMNode addedNode) {
        this.nodeIdsByRack.compute(addedNode.getRackName(), (k, v) -> v == null ? ConcurrentHashMap.newKeySet() : v).add(addedNode.getNodeID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ClusterNode> sortNodes(boolean excludeFullNodes) {
        ReentrantReadWriteLock.ReadLock readLock = this.clusterNodesLock.readLock();
        readLock.lock();
        try {
            ClusterNode[] nodes = new ClusterNode[this.clusterNodes.size()];
            int nodesIdx = 0;
            Resource clusterResource = Resource.newInstance((Resource)Resources.none());
            for (ClusterNode object : this.clusterNodes.values()) {
                Resources.addTo((Resource)clusterResource, (Resource)object.getCapability());
                nodes[nodesIdx] = object;
                ++nodesIdx;
            }
            this.comparator.setClusterResource(clusterResource);
            ArrayList<ClusterNode> retList = new ArrayList<ClusterNode>();
            Arrays.sort(nodes, this.comparator);
            for (ClusterNode cNode : nodes) {
                if (excludeFullNodes && !this.comparator.isNodeAvailable(cNode)) continue;
                retList.add(cNode);
            }
            ArrayList<ClusterNode> arrayList = retList;
            return arrayList;
        }
        finally {
            readLock.unlock();
        }
    }

    public static enum LoadComparator implements Comparator<ClusterNode>
    {
        QUEUE_LENGTH,
        QUEUE_WAIT_TIME,
        QUEUE_LENGTH_THEN_RESOURCES;

        private Resource clusterResource = Resources.none();
        private final DominantResourceCalculator resourceCalculator = new DominantResourceCalculator();

        private boolean shouldPerformMinRatioComputation() {
            if (this.clusterResource == null) {
                return false;
            }
            return !this.resourceCalculator.isAnyMajorResourceZeroOrNegative(this.clusterResource);
        }

        private int compareQueueLengthThenResources(ClusterNode o1, ClusterNode o2) {
            int diff = o1.getQueueLength() - o2.getQueueLength();
            if (diff != 0) {
                return diff;
            }
            Resource availableResource1 = o1.getAvailableResource();
            Resource availableResource2 = o2.getAvailableResource();
            if (this.shouldPerformMinRatioComputation()) {
                float availableRatio1 = this.resourceCalculator.minRatio(availableResource1, this.clusterResource);
                float availableRatio2 = this.resourceCalculator.minRatio(availableResource2, this.clusterResource);
                diff = Precision.compareTo((double)availableRatio2, (double)availableRatio1, (double)Precision.EPSILON);
            }
            if (diff == 0) {
                diff = availableResource2.getVirtualCores() - availableResource1.getVirtualCores();
            }
            if (diff == 0) {
                diff = Long.compare(availableResource2.getMemorySize(), availableResource1.getMemorySize());
            }
            return diff;
        }

        @Override
        public int compare(ClusterNode o1, ClusterNode o2) {
            int diff;
            switch (this) {
                case QUEUE_LENGTH_THEN_RESOURCES: {
                    diff = this.compareQueueLengthThenResources(o1, o2);
                    break;
                }
                default: {
                    diff = this.getMetric(o1) - this.getMetric(o2);
                }
            }
            if (diff == 0) {
                return (int)(o2.getTimestamp() - o1.getTimestamp());
            }
            return diff;
        }

        @VisibleForTesting
        void setClusterResource(Resource clusterResource) {
            this.clusterResource = clusterResource;
        }

        public ResourceCalculator getResourceCalculator() {
            return this.resourceCalculator;
        }

        public int getMetric(ClusterNode c) {
            switch (this) {
                case QUEUE_WAIT_TIME: {
                    return c.getQueueWaitTime();
                }
            }
            return c.getQueueLength();
        }

        public boolean compareAndIncrement(ClusterNode c, int incrementSize, Resource requested) {
            switch (this) {
                case QUEUE_LENGTH_THEN_RESOURCES: {
                    return c.compareAndIncrementAllocation(incrementSize, (ResourceCalculator)this.resourceCalculator, requested);
                }
                case QUEUE_WAIT_TIME: {
                    return true;
                }
            }
            return c.compareAndIncrementAllocation(incrementSize);
        }

        public boolean isNodeAvailable(ClusterNode cn) {
            int queueCapacity = cn.getQueueCapacity();
            int queueLength = cn.getQueueLength();
            if (this == QUEUE_LENGTH_THEN_RESOURCES) {
                if (queueCapacity <= 0) {
                    return queueLength <= 0;
                }
                return queueLength < queueCapacity;
            }
            return queueCapacity <= 0 || queueLength < queueCapacity;
        }
    }
}

