/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.classification.VisibleForTesting;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSContext;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.FSQueue;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.Schedulable;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.SchedulingPolicy;
import org.apache.hadoop.yarn.server.resourcemanager.scheduler.fair.policies.ComputeFairShares;
import org.apache.hadoop.yarn.util.resource.DominantResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceCalculator;
import org.apache.hadoop.yarn.util.resource.ResourceUtils;
import org.apache.hadoop.yarn.util.resource.Resources;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class DominantResourceFairnessPolicy
extends SchedulingPolicy {
    public static final String NAME = "DRF";
    private static final int NUM_RESOURCES = ResourceUtils.getNumberOfCountableResourceTypes();
    private static final DominantResourceFairnessComparator COMPARATORN = new DominantResourceFairnessComparatorN();
    private static final DominantResourceFairnessComparator COMPARATOR2 = new DominantResourceFairnessComparator2();
    private static final DominantResourceCalculator CALCULATOR = new DominantResourceCalculator();

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Comparator<Schedulable> getComparator() {
        if (NUM_RESOURCES == 2) {
            return COMPARATOR2;
        }
        return COMPARATORN;
    }

    @Override
    public ResourceCalculator getResourceCalculator() {
        return CALCULATOR;
    }

    @Override
    public void computeShares(Collection<? extends Schedulable> schedulables, Resource totalResources) {
        for (ResourceInformation info : ResourceUtils.getResourceTypesArray()) {
            ComputeFairShares.computeShares(schedulables, totalResources, info.getName());
        }
    }

    @Override
    public void computeSteadyShares(Collection<? extends FSQueue> queues, Resource totalResources) {
        for (ResourceInformation info : ResourceUtils.getResourceTypesArray()) {
            ComputeFairShares.computeSteadyShares(queues, totalResources, info.getName());
        }
    }

    @Override
    public boolean checkIfUsageOverFairShare(Resource usage, Resource fairShare) {
        return !Resources.fitsIn((Resource)usage, (Resource)fairShare);
    }

    @Override
    public Resource getHeadroom(Resource queueFairShare, Resource queueUsage, Resource maxAvailable) {
        long queueAvailableMemory = Math.max(queueFairShare.getMemorySize() - queueUsage.getMemorySize(), 0L);
        int queueAvailableCPU = Math.max(queueFairShare.getVirtualCores() - queueUsage.getVirtualCores(), 0);
        Resource headroom = Resources.createResource((long)Math.min(maxAvailable.getMemorySize(), queueAvailableMemory), (int)Math.min(maxAvailable.getVirtualCores(), queueAvailableCPU));
        return headroom;
    }

    @Override
    public void initialize(FSContext fsContext) {
        COMPARATORN.setFSContext(fsContext);
        COMPARATOR2.setFSContext(fsContext);
    }

    @VisibleForTesting
    static class DominantResourceFairnessComparator2
    extends DominantResourceFairnessComparator {
        DominantResourceFairnessComparator2() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res;
            boolean s2Needy;
            ResourceInformation[] resourceInfo1 = s1.getResourceUsage().getResources();
            ResourceInformation[] resourceInfo2 = s2.getResourceUsage().getResources();
            ResourceInformation[] minShareInfo1 = s1.getMinShare().getResources();
            ResourceInformation[] minShareInfo2 = s2.getMinShare().getResources();
            ResourceInformation[] clusterInfo = this.fsContext.getClusterResource().getResources();
            double[] shares1 = new double[2];
            double[] shares2 = new double[2];
            int dominant1 = this.calculateClusterAndFairRatios(resourceInfo1, s1.getWeight(), clusterInfo, shares1);
            int dominant2 = this.calculateClusterAndFairRatios(resourceInfo2, s2.getWeight(), clusterInfo, shares2);
            boolean s1Needy = resourceInfo1[dominant1].getValue() < minShareInfo1[dominant1].getValue();
            boolean bl = s2Needy = resourceInfo2[dominant2].getValue() < minShareInfo2[dominant2].getValue();
            if (!s2Needy && !s1Needy) {
                res = (int)Math.signum(shares1[dominant1] - shares2[dominant2]);
                if (res == 0) {
                    res = (int)Math.signum(shares1[1 - dominant1] - shares2[1 - dominant2]);
                }
            } else if (s1Needy && !s2Needy) {
                res = -1;
            } else if (s2Needy && !s1Needy) {
                res = 1;
            } else {
                double[] minShares2;
                double[] minShares1 = this.calculateMinShareRatios(resourceInfo1, minShareInfo1);
                res = (int)Math.signum(minShares1[dominant1] - (minShares2 = this.calculateMinShareRatios(resourceInfo2, minShareInfo2))[dominant2]);
                if (res == 0) {
                    res = (int)Math.signum(minShares1[1 - dominant1] - minShares2[1 - dominant2]);
                }
            }
            if (res == 0) {
                res = this.compareAttributes(s1, s2);
            }
            return res;
        }

        @VisibleForTesting
        int calculateClusterAndFairRatios(ResourceInformation[] resourceInfo, float weight, ResourceInformation[] clusterInfo, double[] shares) {
            shares[0] = (double)resourceInfo[0].getValue() / (double)clusterInfo[0].getValue();
            shares[1] = (double)resourceInfo[1].getValue() / (double)clusterInfo[1].getValue();
            int dominant = shares[1] > shares[0] ? 1 : 0;
            shares[0] = shares[0] / (double)weight;
            shares[1] = shares[1] / (double)weight;
            return dominant;
        }

        @VisibleForTesting
        double[] calculateMinShareRatios(ResourceInformation[] resourceInfo, ResourceInformation[] minShareInfo) {
            double[] minShares1 = new double[]{(double)resourceInfo[0].getValue() / (double)minShareInfo[0].getValue(), (double)resourceInfo[1].getValue() / (double)minShareInfo[1].getValue()};
            return minShares1;
        }
    }

    @VisibleForTesting
    static class DominantResourceFairnessComparatorN
    extends DominantResourceFairnessComparator {
        DominantResourceFairnessComparatorN() {
        }

        @Override
        public int compare(Schedulable s1, Schedulable s2) {
            int res;
            boolean s2Needy;
            Resource usage1 = s1.getResourceUsage();
            Resource usage2 = s2.getResourceUsage();
            Resource minShare1 = s1.getMinShare();
            Resource minShare2 = s2.getMinShare();
            Resource clusterCapacity = this.fsContext.getClusterResource();
            float[][] ratios1 = new float[NUM_RESOURCES][3];
            float[][] ratios2 = new float[NUM_RESOURCES][3];
            int dominant1 = this.calculateClusterAndFairRatios(usage1, clusterCapacity, ratios1, s1.getWeight());
            int dominant2 = this.calculateClusterAndFairRatios(usage2, clusterCapacity, ratios2, s2.getWeight());
            boolean s1Needy = usage1.getResources()[dominant1].getValue() < minShare1.getResources()[dominant1].getValue();
            boolean bl = s2Needy = usage2.getResources()[dominant2].getValue() < minShare2.getResources()[dominant2].getValue();
            if (!s2Needy && !s1Needy) {
                this.sortRatios(ratios1, ratios2);
                res = this.compareRatios(ratios1, ratios2, 1);
            } else if (s1Needy && !s2Needy) {
                res = -1;
            } else if (s2Needy && !s1Needy) {
                res = 1;
            } else {
                this.calculateMinShareRatios(usage1, minShare1, ratios1);
                this.calculateMinShareRatios(usage2, minShare2, ratios2);
                this.sortRatios(ratios1, ratios2);
                res = this.compareRatios(ratios1, ratios2, 2);
            }
            if (res == 0) {
                res = this.compareAttributes(s1, s2);
            }
            return res;
        }

        @VisibleForTesting
        void sortRatios(float[][] ratios1, float[][] ratios2) {
            Arrays.sort(ratios1, (o1, o2) -> (int)Math.signum(o2[0] - o1[0]));
            Arrays.sort(ratios2, (o1, o2) -> (int)Math.signum(o2[0] - o1[0]));
        }

        @VisibleForTesting
        int calculateClusterAndFairRatios(Resource resource, Resource cluster, float[][] ratios, float weight) {
            ResourceInformation[] resourceInfo = resource.getResources();
            ResourceInformation[] clusterInfo = cluster.getResources();
            int max = 0;
            for (int i = 0; i < clusterInfo.length; ++i) {
                ratios[i][0] = (float)resourceInfo[i].getValue() / (float)clusterInfo[i].getValue();
                if (ratios[i][0] > ratios[max][0]) {
                    max = i;
                }
                ratios[i][1] = ratios[i][0] / weight;
            }
            return max;
        }

        @VisibleForTesting
        void calculateMinShareRatios(Resource resource, Resource minShare, float[][] ratios) {
            ResourceInformation[] resourceInfo = resource.getResources();
            ResourceInformation[] minShareInfo = minShare.getResources();
            for (int i = 0; i < minShareInfo.length; ++i) {
                ratios[i][2] = (float)resourceInfo[i].getValue() / (float)minShareInfo[i].getValue();
            }
        }

        @VisibleForTesting
        int compareRatios(float[][] ratios1, float[][] ratios2, int index) {
            int ret = 0;
            for (int i = 0; i < ratios1.length && (ret = (int)Math.signum(ratios1[i][index] - ratios2[i][index])) == 0; ++i) {
            }
            return ret;
        }
    }

    public static abstract class DominantResourceFairnessComparator
    implements Comparator<Schedulable> {
        protected FSContext fsContext;

        public void setFSContext(FSContext fsContext) {
            this.fsContext = fsContext;
        }

        protected int compareAttributes(Schedulable s1, Schedulable s2) {
            int res = (int)Math.signum(s1.getStartTime() - s2.getStartTime());
            if (res == 0) {
                res = s1.getName().compareTo(s2.getName());
            }
            return res;
        }
    }
}

