/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.csi.adaptor;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.service.AbstractService;
import org.apache.hadoop.yarn.api.CsiAdaptorPlugin;
import org.apache.hadoop.yarn.api.CsiAdaptorProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.GetPluginInfoRequest;
import org.apache.hadoop.yarn.api.protocolrecords.GetPluginInfoResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodePublishVolumeResponse;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeRequest;
import org.apache.hadoop.yarn.api.protocolrecords.NodeUnpublishVolumeResponse;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesRequest;
import org.apache.hadoop.yarn.api.protocolrecords.ValidateVolumeCapabilitiesResponse;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.ipc.YarnRPC;
import org.apache.hadoop.yarn.util.csi.CsiConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsiAdaptorProtocolService
extends AbstractService
implements CsiAdaptorProtocol {
    private static final Logger LOG = LoggerFactory.getLogger(CsiAdaptorProtocolService.class);
    private Server server;
    private InetSocketAddress adaptorServiceAddress;
    private CsiAdaptorPlugin serverImpl;

    public CsiAdaptorProtocolService(CsiAdaptorPlugin adaptorImpl) {
        super(CsiAdaptorProtocolService.class.getName());
        this.serverImpl = adaptorImpl;
    }

    protected void serviceInit(Configuration conf) throws Exception {
        this.adaptorServiceAddress = CsiConfigUtils.getCsiAdaptorAddressForDriver((String)this.serverImpl.getDriverName(), (Configuration)conf);
        super.serviceInit(conf);
    }

    protected void serviceStart() throws Exception {
        Configuration conf = this.getConfig();
        YarnRPC rpc = YarnRPC.create((Configuration)conf);
        this.server = rpc.getServer(CsiAdaptorProtocol.class, (Object)this.serverImpl, this.adaptorServiceAddress, conf, null, 1);
        this.server.start();
        LOG.info("{} started, listening on address: {}", (Object)CsiAdaptorProtocolService.class.getName(), (Object)this.adaptorServiceAddress.toString());
        super.serviceStart();
    }

    protected void serviceStop() throws Exception {
        if (this.server != null) {
            this.server.stop();
        }
        super.serviceStop();
    }

    public GetPluginInfoResponse getPluginInfo(GetPluginInfoRequest request) throws YarnException, IOException {
        return this.serverImpl.getPluginInfo(request);
    }

    public ValidateVolumeCapabilitiesResponse validateVolumeCapacity(ValidateVolumeCapabilitiesRequest request) throws YarnException, IOException {
        return this.serverImpl.validateVolumeCapacity(request);
    }

    public NodePublishVolumeResponse nodePublishVolume(NodePublishVolumeRequest request) throws YarnException, IOException {
        return this.serverImpl.nodePublishVolume(request);
    }

    public NodeUnpublishVolumeResponse nodeUnpublishVolume(NodeUnpublishVolumeRequest request) throws YarnException, IOException {
        return this.serverImpl.nodeUnpublishVolume(request);
    }
}

