/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.tools.dynamometer.workloadgenerator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.VirtualInputSplit;
import org.apache.hadoop.tools.dynamometer.workloadgenerator.VirtualRecordReader;

public class VirtualInputFormat<K, V>
extends FileInputFormat<K, V> {
    public List<InputSplit> getSplits(JobContext job) throws IOException {
        Configuration conf = job.getConfiguration();
        int numMappers = conf.getInt("createfile.num-mappers", -1);
        if (numMappers == -1) {
            throw new IOException("Number of mappers should be provided as input");
        }
        ArrayList<InputSplit> splits = new ArrayList<InputSplit>(numMappers);
        for (int i = 0; i < numMappers; ++i) {
            splits.add(new VirtualInputSplit());
        }
        return splits;
    }

    public RecordReader<K, V> createRecordReader(InputSplit split, TaskAttemptContext context) throws IOException, InterruptedException {
        return new VirtualRecordReader();
    }
}

